let ServerLevel = Java.loadClass("net.minecraft.server.level.ServerLevel")
let ChunkStatus = Java.loadClass("net.minecraft.world.level.chunk.ChunkStatus")
let Registries = Java.loadClass("net.minecraft.core.registries.Registries")
/**
 * 
 * @param {Internal.Entity} entity
 * @param {String} structure 
 * @returns 
 */
function isInStructure(entity, structure) {
    let pos = entity.block.pos
    let dimension = entity.getLevel().dimensionKey;
    let sw = entity.server.getLevel(dimension);
    if (sw instanceof ServerLevel) {
        let chunk = sw.getChunk(pos.x >> 4, pos.z >> 4, ChunkStatus.STRUCTURE_REFERENCES, false);
        if (chunk == null) {
            return false;
        }
        let references = chunk.getAllReferences();
        for (references of references.entrySet()) {
            let e = references
            let longs = e.getValue();
            if (!longs.isEmpty()) {
                let struct = e.getKey();
                let key = sw.registryAccess().registryOrThrow(Registries.STRUCTURE).getKey(struct);
                
                if (key.toString() == structure) {
                    return true;
                } else {
                    return false;
                }
            }
        }
    }
    return false;

}
