function handleHomingProjectile (projectileId, player, target, count) {
    if (!player || !target) return

    if (count > 1) {
        for (let i = 0; i < count; i++) {
            Utils.server.scheduleInTicks(i * 3, v => {
                handleHomingProjectile(projectileId, player, target, 1)
            })
        }
    } else {
        let projectile = player.level.createEntity(projectileId)
        projectile.x = player.x
        projectile.y = player.y + player.eyeHeight + 1
        projectile.z = player.z
        projectile.tags.add(`Owner:${player.username}`)
        projectile.spawn()
        projectile.playSound(`alexscaves:abyssmarine_glow_on`, 10, 1)
        projectile.mergeNbt({
            NoGravity: true,
            Glowing: true,
            damage: 5,
            Damage: 5,
            ExplosionRadius: 3,
        })
        Utils.server.scheduleInTicks(1, v => {
            if (target.alive && projectile.alive) {
                v.repeating = true
                let dirV = {
                    x: (target.x - projectile.x) / 10,
                    y: (target.y + 1.5 - projectile.y) / 10,
                    z: (target.z - projectile.z) / 10
                }

                projectile.addMotion(dirV.x * 0.075, dirV.y * 0.075, dirV.z * 0.075)

                if (parseInt(projectile.x) == parseInt(target.x) && projectile.y > target.y && parseInt(projectile.z) == parseInt(target.z)) {
                    projectile.addMotion(0.0, -0.90, 0.0)
                }
            } else {
                v.repeating = false
                projectile.addMotion(0.0, -2.0, 0.0)
            }
        })
    }

}