 // Utility function to capitalize and format modifier names
    
 function formatModifierName(modifier) {
    return modifier
        .split(':')
        .map(word => word.charAt(0).toUpperCase() + word.slice(1))
        .join(' ')
        .replace(/([a-z])([0-9])/g, '$1 $2');
}



function generateUUID() {
    let uuid = '', i, random;
    for (i = 0; i < 36; i++) {
        if (i === 8 || i === 13 || i === 18 || i === 23) {
            uuid += '-';
        } else if (i === 14) {
            uuid += '4';
        } else if (i === 19) {
            random = (Math.random() * 16) | 0;
            uuid += ((random & 0x3) | 0x8).toString(16);
        } else {
            random = (Math.random() * 16) | 0;
            uuid += random.toString(16);
        }
    }
    return uuid;
}

function generateRandomString(length) {
    let characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    let result = '';
    for (let i = 0; i < length; i++) {
        result += characters.charAt(Math.floor(Math.random() * characters.length));
    }
    return result;
}



// Function to generate all unique combinations up to a specified length
function getCombinations(array, maxLength) {
let results = [];

function helper(start, current) {
    results.push(current.slice()); // Add the current combination to the results

    // Stop recursion if the current combination reaches maxLength
    if (current.length === maxLength) return;

    for (let i = start; i < array.length; i++) {
        current.push(array[i]);
        helper(i + 1, current); // Recursively build combinations
        current.pop(); // Backtrack
    }
}

helper(0, []);
return results;
}