
function getMods(player, mod) {
    let toApply = []
    if (player.tags.contains(mod)) {
        // Get the modifier data using the mod
        let info = new_modifiers.modifier_items[mod];
        let data = info.data;
        let value = info.value;
        let operation = info.operation;
        let tag = info.tag;
        if (operation == 'single') {
            toApply.push(data)
        }
       // Utils.server.tell(toApply)
        return toApply
    }

}


function applyMods (item, boss, player) {
    if (!variant_mods[item]) return
    if (variant_mods[item].category != 'mod') return
    // get the item from the object
    let info = variant_mods[item]
    // get the category
    let type = info.type
    let value = info.value
    if (player.persistentData.get(type)) {
        //Utils.server.tell(`Player has ${type} with a value of ${player.persistentData.getInt(type)}`)
        boss.persistentData.putInt(type, player.persistentData.getInt(type))
        //Utils.server.tell(type)
        player.persistentData.remove(type)
        let multiplier = 0
        if (type == 'summoner') {
            multiplier = Math.ceil(1+(0.5*value))
        } else if (type == 'power_boost') {
            multiplier = 3*value
        } else if (type == 'burst') {
            multiplier = 2*value
        } else if (type == 'combo') {
            multiplier = 2*value
        }


        player.persistentData.boss_difficulty = player.persistentData.boss_difficulty * multiplier
       // Utils.server.tell(`Value: Multiplier: ${multiplier}`)

    } else {
        return
    }
    //Utils.server.tell(`Applied the ${item} cipher to the boss`)
}
        


function applyCiphers (item, boss, player) {
    if (!variant_mods[item]) return
    if (variant_mods[item].category != 'cipher') return
    // get the item from the object
    let info = variant_mods[item]
    // get the category
    let type = info.type
    let value = info.value
    if (player.persistentData.get(type)) {
        ///Utils.server.tell(`Player has ${type} with a value of ${player.persistentData.getInt(type)}`)
        let amp = player.persistentData.getInt(type)
        applyEffect(boss, type, 'infinite', amp-1)
        player.persistentData.remove(type)
        // round up to the nearest integer 1+(0.25*amp)}
        let multiplier = Math.ceil(amp)
        player.persistentData.boss_difficulty = player.persistentData.boss_difficulty * multiplier
        //Utils.server.tell(`Amp: ${multiplier}`)
    } else {
        return
    }
    //Utils.server.tell(`Applied the ${item} cipher to the boss`)
}