// Put this in a startup script (kubejs/startup_scripts/colored_glow.js)
// or in a server script that loads early.

// Simple named colors → hex (WITHOUT the leading #, as CGL expects)
const GLOW_COLORS = {
  // WHITE / GRAYS
  light_gray: 'd3d3d3',
  gray: '808080',
  dark_gray: '505050',

  // RED
  light_red: 'ff7f7f',
  red: 'ff0000',
  dark_red: '8b0000',

  // ORANGE
  light_orange: 'ffb84d',
  orange: 'ffa500',
  dark_orange: 'cc8400',

  // YELLOW
  light_yellow: 'ffffaa',
  yellow: 'ffff00',
  dark_yellow: 'cccc00',

  // GREEN
  light_green: '90ee90',
  green: '00ff00',
  dark_green: '006400',

  // CYAN / AQUA
  light_cyan: 'aaffff',
  cyan: '00ffff',
  dark_cyan: '008b8b',

  // BLUE
  light_blue: 'add8e6',
  blue: '0000ff',
  dark_blue: '00008b',

  // PURPLE
  light_purple: 'd19ce8',
  purple: '800080',
  dark_purple: '4b006b',

  // PINK
  light_pink: 'ffb6c1',
  pink: 'ff69b4',
  dark_pink: 'c71585',

  // BROWN
  light_brown: 'd2b48c',
  brown: 'a52a2a',
  dark_brown: '5c1919',

  // SPECIAL NEUTRALS / FANTASY TONES
  light_void: 'aa77ff',
  void: '7a00cc',
  dark_void: '3e0066',

  light_shadow: '666666',
  shadow: '303030',
  dark_shadow: '0f0f0f',

  light_gold: 'ffe680',
  gold: 'ffd700',
  dark_gold: 'b39700'
};


/**
 * applyGlow(entity, color, duration)
 *
 * entity   - KubeJS EntityJS object
 * color    - string (e.g. "purple", "red", "rainbow", "random", or hex "#b3cc27ff" / "ff00ff")
 * duration - ticks the entity should glow for
 */
global.applyGlow = function(entity, color, duration) {
  if (!entity) return;
    
  // Optional: only care about living things
  if (entity.isLiving && !entity.isLiving()) return;

  let key = (color || 'white').toLowerCase().trim();
  let cglColor;

  // Pass through special ColoredGlowLib keywords
  if (key === 'rainbow' || key === 'random') {
    cglColor = key;
  } else {
    // Named color lookup
    cglColor = GLOW_COLORS[key];

    // If not a named color, treat it as hex (with or without #)
    if (!cglColor) {
      let cleaned = key.replace('#', '');
      if (/^[0-9a-f]{3}([0-9a-f]{3})?$/i.test(cleaned)) {
        cglColor = cleaned;
      } else {
        // Fallback if it's garbage
        cglColor = 'ffffff';
      }
    }
  }
  Utils.server.runCommandSilent(`/effect clear ${entity.uuid} minecraft:glowing`);
  Utils.server.runCommandSilent(`/cgl clear ${uuid} true`);
  // Clamp duration (in ticks)
  let ticks
  if (duration != 'infinite') {
    ticks = Math.max(1, duration | 0);
  } else {
    ticks = duration
  }
  //Utils.server.tell(ticks)
  // Apply vanilla glowing effect so the outline actually shows
  // (API name might differ slightly depending on KubeJS version;
  // if it errors, swap to entity.addEffect or similar.)
  if (entity.potionEffects && entity.potionEffects.add) {
    if (ticks != 'infinite') {
        entity.potionEffects.add('minecraft:glowing', ticks, 0, false, false);
    } else {
        Utils.server.runCommandSilent(`/effect give ${entity.uuid} minecraft:glowing ${ticks} 0 true`)
    }
    
  }

  const uuid = String(entity.uuid);

  // Set the ColoredGlowLib color on this specific entity
  Utils.server.runCommandSilent(`/cgl setglowcolor ${uuid} ${cglColor}`);

  // After duration, remove glowing + clear color
  if (ticks == 'infinite') return
  /**
   *   Utils.server.scheduleInTicks(ticks, () => {
    try {
      if (entity && entity.potionEffects) {
        Utils.server.runCommandSilent(`/effect clear ${entity.uuid} minecraft:glowing`);
        Utils.server.runCommandSilent(`/cgl clear ${uuid} true`);
      }
      // Clear color entry for this entity; useDefault=true so it falls back
      Utils.server.runCommandSilent(`/cgl clear ${uuid} true`);
    } catch (e) {
      // entity might be gone; safe to ignore
    }
  });
   * 
   * 
   */

};
