

/**
 * 
 * @param {*} entity The main entity that you are finding allies for
 * @param {*} type 'player', 'pet'
 * @param {*} range The range in which to find allies
 * 
 * 
 * Checks for allies in a range. This includes players, pets, and allied players pets.
 *  - Returns an object called Check with two properties: boolean and count. 
 *   -> boolean: true if there is an ally, false if there is not
 *   -> count: the number of allies found. Useful for implementing group play mechanics. ex.) Stacking effects based on nearby players
 * 
 * 
 */

function allyCheck (entity, type, range) {
    if (type == 'player') {
        let box = AABB.of(entity.x+range, entity.y+range, entity.z+range, entity.x-range, entity.y-range, entity.z-range)
        let dim = entity.dimension
        let entitiesWithin = dim.getEntitiesWithin(box)
        let check = {
            boolean: false,
            count: 0
        }
        entitiesWithin.forEach(ent => {
            if (ent.tags.contains('tamed_beast')) {
                let owner_username = ent.persistentData.get('owner')
                let owner = entity.server.getPlayer(owner_username)
                // if the owner team is the same as the entity team OR the owner username is the same as the entity username
                if (owner.team == entity.team || owner_username == entity.username) {
                    check.boolean = true
                    check.count++
                }
            } else if (ent.player) {
                if (ent.team == entity.team) {
                    check.boolean = true
                    check.count++
                }
            }
        })
        return check
    }
}

/**
 * @param {*} entity the entity who is checking
 * @param {*} target The entity you are checking to see if it is an ally
 * @param {*} includeSelf 
 * @returns 
 * 
 * Returns true if the entity is an ally, false if it is not


*/
function isAlly (entity, target, includeSelf) {
    if (!entity) return false
    if (!target) return false
    if (includeSelf && target == entity) return true
    if (target.persistentData && target.persistentData.getString('owner')) {
        let owner = entity.server.getPlayer(target.persistentData.getString('owner'))
        if (owner && owner.username == entity.username) return true
    }

    if (entity.persistentData && entity.persistentData.getString('owner')) {
        let owner = entity.server.getPlayer(entity.persistentData.getString('owner'))
        if (owner && owner.username == target.username) return true
    }

    if (entity.team && target.team) {
        if (entity.team.getName() == target.team.getName()) return true
    }

    return false
}

EntityEvents.hurt(event => {
    if (!event.source) return
    if (!event.source.actual) return
    if (!event.entity) return
    if (isAlly(event.source.actual, event.entity)) {
        event.cancel()
    }
})




/**
 * 
 * @param {*} sourceEntity The entity you are checking from
 * @param {*} properties OBJECT: range: number, check for allies: boolean, includeSelf: boolean, entityType: list (this is so you can check for one, none, or multiple entities)
 * @param {*} desiredReturn The type of return you want. Can be 'boolean' or 'number'. If boolean, it will act as a basic check for allies or enemies. If number, it will return the number of allies or enemies found
 *
 */
function checkEntitiesWithinRange (sourceEntity, properties, desiredReturn) {
    if (sourceEntity == null || properties == null) {
        console.log('Invalid sourceLocation or properties')
        return 
    }
    

    

}




function enemyCheck (entity, type, range) {
    if (type == 'player') {
        let box = AABB.of(entity.x+range, entity.y+range, entity.z+range, entity.x-range, entity.y-range, entity.z-range)
        let dim = entity.dimension
        let entitiesWithin = dim.getEntitiesWithin(box)
        let check = {
            boolean: false,
            count: 0
        }
        entitiesWithin.forEach(ent => {
            if (ent.tags.contains('tamed_beast')) {
                let owner_username = ent.persistentData.owner
                let owner = entity.server.getPlayer(owner_username)
                // if the owner team is the same as the entity team OR the owner username is the same as the entity username
                if (owner.team != entity.team && owner_username != entity.username) {
                    check.boolean = true
                    check.count++
                }
            } else if (ent.player) {
                if (ent.team != entity.team) {
                    check.boolean = true
                    check.count++
                }
            }
        })
        return check
    }
}
