
let withered_wand =new WeakMap()

ItemEvents.firstLeftClicked('kubejs:withered_wand', event => {
    let player = event.player;
    if (player.cooldowns.isOnCooldown('kubejs:withered_wand')) return
    if (withered_wand[player.username] == undefined) {
        withered_wand[player.username] = 1
    } else {
        withered_wand[player.username]++
    }
    if (withered_wand[player.username] > 4) {
        player.cooldowns.addCooldown('kubejs:withered_wand', 2400)
        withered_wand[player.username] = 0

    } 
    let arrow = event.level.createEntity('kubejs:entity.withered_wand');
    arrow.tags.add(`Owner:${event.player.username}`);
    //arrow.tags.add('echoing_void')
    
    // Set the arrow's initial position to be at the player's location
    arrow.setPosition(event.player.x, event.player.y + 1, event.player.z);
    let x_rad = event.player.pitch * JavaMath.PI / 180;
    let y_rad = event.player.yaw * JavaMath.PI / 180;

    let dirV = {
        x: -Math.sin(y_rad) * Math.cos(x_rad),
        y: -Math.sin(x_rad),
        z: Math.cos(y_rad) * Math.cos(x_rad)
    }
    arrow.addMotion(dirV.x * 8, dirV.y * 8, dirV.z * 8)

    // Spawn the arrow in the world
    arrow.spawn();
    arrow.playSound(`blocky_siege:soul_screams`, 10, 2)
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle bosses_of_mass_destruction:soul_flame ${player.x} ${player.y} ${player.z} 1 1 1 4 500`)
    Utils.server.scheduleInTicks(600, () => {
        arrow.kill()
    })
    //arrow.playSound(`blocky_siege:molten_mortar_shell_impact`, 10, 2)
    //arrow.playSound(`blocky_siege:soul_screams`, 10, 2)
    //Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle cataclysm:soul_lava ${player.x} ${player.y} ${player.z} 0.5 0.5 0.5 4 40`)
})


EntityEvents.spawned('kubejs:entity.withered_wand', event => {
    event.entity.glowing = true
    Utils.server.scheduleInTicks(20, () => {
        let random2 = Math.floor(Math.random() * 8) + 4;
        // loop equal to random2
        for (let i = 0; i < random2; i++) {
            // choose a number between 1 and 3
            let random_x = Math.floor(Math.random() * 3) + 1;
            let random_z = Math.floor(Math.random() * 3) + 1;
            Utils.server.scheduleInTicks(20*i, () => {
                let howitzer = event.level.createEntity('blocky_siege:projectile_giant_sculk_bomb_projectile')
                howitzer.setPosition(event.entity.x+random_x, event.entity.y+10, event.entity.z+random_z)
                howitzer.addMotion(0, -1, 0)
                howitzer.spawn()
            })
        }
    })
})