/** Whispers of the Wood:
 *  - Right click to go insane and invisible for 30 seconds
 *  - Enemies that you hit are marked with whispers_of_the_elderwood_target
 *  - After 30 seconds, teleport back to where you were and remove the insanity effect
 *  - If you kill a target, kill all other targets that are marked
 * 
 */




ItemEvents.rightClicked('kubejs:whispers_of_the_elderwood', event => {
    event.player.tags.add('whispers_of_the_elderwood')
    event.player.potionEffects.add('minecraft:speed', 600, 1)
    event.player.potionEffects.add('irons_spellbooks:true_invisibility', 600, 1)
    event.player.potionEffects.add('cofh_core:true_invisibility', 600, 0)
    event.player.persistentData.putInt('whispers_x', event.player.x)
    event.player.persistentData.putInt('whispers_y', event.player.y)
    event.player.persistentData.putInt('whispers_z', event.player.z)
    Utils.server.runCommandSilent(`/sanity set ${event.player.username} 0`) // Put insanity level at 0
    Utils.server.scheduleInTicks(600, () => {
        event.player.tags.remove('whispers_of_the_elderwood')
        // COMMAND: put insanity level back to normal
        Utils.server.runCommandSilent(`/sanity set ${event.player.username} 100`)
        // COMMAND: teleport player back to where they were
        event.player.setPosition(event.player.persistentData.getInt('whispers_x'), event.player.persistentData.getInt('whispers_y'), event.player.persistentData.getInt('whispers_z'))

    })
})


ItemEvents.entityInteracted(event => {
    let player = event.player
    if (!player.tags.contains('whispers_of_the_elderwood')) return
    let ent = event.target
    ent.tags.add(`whispers_of_the_elderwood_target`)
    ent.tags.add(`whispers_target:${player.username}`)
    //Utils.server.runCommandSilent(`/photon fx photon:whispers_of_the_elderwood entity ${ent.uuid}`)

})

EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.tags.contains('whispers_of_the_elderwood')) return
    event.cancel()
})

EntityEvents.death(event => {
    if (!event.source.player) return
    let player = event.source.player
    // get the username of the player by getting everything after the colon
    if (!event.entity.tags.contains('whispers_of_the_elderwood_target')) return
    let username_check = event.entity.tags.find(tag => tag.startsWith('whispers_target')).split(':')[1]
    if (username_check !== event.source.player.username) return
    let x = event.entity.x
    let y = event.entity.y
    let z = event.entity.z
    let box = AABB.of(x+40, y+40, z+40, x-40, y-40, z-40)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    entitiesWithin.forEach(ent => {
        if (ent.tags.contains('whispers_of_the_elderwood_target')) {
            if (ent != player) {
                ent.kill()
            }
            
        }
    })

})



