
/**
 * ItemEvents.rightClicked('kubejs:pulsating_artifact', event => {
    event.player.cooldowns.addCooldown('kubejs:pulsating_artifact', 10)
    let player = event.player
    player.swing()
    let ball = event.level.createEntity('irons_spellbooks:ball_lightning')
    let x_rad = player.pitch * JavaMath.PI / 180;
    let y_rad = player.yaw * JavaMath.PI / 180;
    let dirV = {
        x: -Math.sin(y_rad) * Math.cos(x_rad),
        y: -Math.sin(x_rad),
        z: Math.cos(y_rad) * Math.cos(x_rad)
    }
    ball.setPosition(player.x, player.y+1, player.z)
    ball.addMotion(dirV.x * 1.5, dirV.y * 1.5, dirV.z * 1.5)
    ball.tags.add(`pulsating_ball`)
    ball.tags.add(`Owner:${player.username}`)
    ball.spawn()
})

EntityEvents.hurt(event => {
    if (event.source.immediate == null) return
    if (event.source.immediate == undefined) return
    if (event.source.immediate.type != 'irons_spellbooks:ball_lightning') return
    if (!event.source.immediate.tags.contains('pulsating_ball')) return
    let player_username = event.source.immediate.tags.find(tag => tag.startsWith('Owner')).split(':')[1]
    let player = event.server.getPlayer(player_username)
    if (event.entity == player) {
        event.cancel()
        return
    } else {
        event.entity.attack(5)
        event.entity.tags.add('pulsating_ball_target')
        Utils.server.scheduleInTicks(100, () => {
            let x_rad = player.pitch * JavaMath.PI / 180;
            let y_rad = player.yaw * JavaMath.PI / 180;
            let dirV = {
                x: -Math.sin(y_rad) * Math.cos(x_rad),
                y: -Math.sin(x_rad),
                z: Math.cos(y_rad) * Math.cos(x_rad)
            }
            let box = AABB.of(player.x+30, player.y+30, player.z+30, player.x-30, player.y-30, player.z-30)
            let dim = event.level
            let entitiesWithin = dim.getEntitiesWithin(box).filter(entity => entity.tags.contains('pulsating_ball_target'))
            entitiesWithin.forEach(ent => {
                ent.teleportTo(player.x+dirV.x*5, player.y+dirV.y*5, player.z+dirV.z*5)
                Utils.server.scheduleRepeatingInTicks(5, () => {
                    if (ent.alive) {
                        let dirV2 = {
                            x: -Math.sin(y_rad) * Math.cos(x_rad),
                            y: -Math.sin(x_rad),
                            z: Math.cos(y_rad) * Math.cos(x_rad)
                        }
                        ent.addMotion(player.x+dirV2.x* -1, player.y+dirV2.y* -1, player.z+dirV2.z* -1)
                    }
                })
            })
        })
    }
})
 * 
 */

let pulsating_artifact = [
    'void',
    'fire',
    'lightning',
]

ItemEvents.rightClicked('kubejs:pulsating_artifact', event => {
    if (event.player.persistentData.pulse_target != true) return
    let player = event.player
    if (player.magicData.getMana() < 30) return
    player.magicData.setMana(player.magicData.getMana() - 30)
    // choose a random element from the pulsating_artifact array
    let ent = ''
    if (player.persistentData.getString('pulse_type') == 'void') {
        ent = 'irons_spellbooks:comet'
    } else if (player.persistentData.getString('pulse_type') == 'fire') {
        ent = 'irons_spellbooks:magma_ball'
    } else if (player.persistentData.getString('pulse_type') == 'lightning') {
        ent = 'irons_spellbooks:lightning_lance'
    }
        
    player.swing()
    let ball = event.level.createEntity(ent)
    ball.setPosition(player.x, player.y+4, player.z)
    ball.tags.add(`pulsating_ball`)
    ball.tags.add(`Owner:${player.username}`)
    ball.spawn()
    ball.playSound(`alexscaves:abyssmarine_glow_on`, 10, 1)
    Utils.server.scheduleInTicks(1, v => {
        if (player.persistentData.pulse_target == true) {
            v.repeating = true
            //add motion to make it move towards the pulse coordinates
            let x = player.persistentData.getFloat('pulse_x')
            let y = player.persistentData.getFloat('pulse_y')
            let z = player.persistentData.getFloat('pulse_z')
            let dirV = {
                x: (x - ball.x) / 10,
                y: (y+1.5 - ball.y) / 10,
                z: (z - ball.z) / 10
            }
            ball.mergeNbt({
                AoeDamage:20.0,
                NoGravity:true,
                ExplosionRadius:6.0,
                Damage:20.0
            })
            ball.addMotion(dirV.x*0.05, dirV.y*0.05, dirV.z*0.05)
            if (parseInt(ball.x) == parseInt(x) && ball.y > y && parseInt(ball.z) == parseInt(z)) {
                ball.addMotion(0.0, -0.5, 0.0)
            }

        } else {
            v.repeating = false
            ball.addMotion(0.0, -2.0, 0.0)
        }
    })
})






ItemEvents.firstLeftClicked('kubejs:pulsating_artifact', event => {
    let player = event.player
    player.swing()
    if (player.magicData.getMana() < 5) return
    player.magicData.setMana(player.magicData.getMana() - 5)
    // choose random string from pulsating_artifact array
    let random = pulsating_artifact[Math.floor(Math.random() * pulsating_artifact.length)]
    if (random == 'void') {
        let dim = event.level.dimension
    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${player.username} magic_missile`)
    } else if (random == 'fire') {
        let dim = event.level.dimension
    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${player.username} firebolt`)
    } else if (random == 'lightning') {
        let dim = event.level.dimension
    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${player.username} ball_lightning`)
    }
})

EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (event.entity.tags.contains('pulsating_ball_target')) return
    event.entity.tags.add('pulsating_ball_target')
    let player = event.source.player
    if (event.source.immediate == null) return
    if (event.source.immediate.type != 'irons_spellbooks:ball_lightning' && event.source.immediate.type != 'irons_spellbooks:firebolt' && event.source.immediate.type != 'irons_spellbooks:magic_missile') return
    if (event.source.immediate.type == 'irons_spellbooks:magic_missile') {
        player.persistentData.putString('pulse_type', 'void')
    } else if (event.source.immediate.type == 'irons_spellbooks:firebolt') {
        player.persistentData.putString('pulse_type', 'fire')
    } else if (event.source.immediate.type == 'irons_spellbooks:ball_lightning') {
        player.persistentData.putString('pulse_type', 'lightning')
    }
    if (!event.source.player.mainHandItem != 'kubejs:pulsating_artifact') return
    
    Utils.server.scheduleInTicks(1, e => {
        if (event.entity.alive) {
            e.repeating = true
            //Utils.server.tell('repeating')
            player.persistentData.putFloat('pulse_x', event.entity.x)
            player.persistentData.putFloat('pulse_y', event.entity.y)
            player.persistentData.putFloat('pulse_z', event.entity.z)
            player.persistentData.putBoolean('pulse_target', true)
        } else {
            e.repeating = false
            //Utils.server.tell('not repeating')
            player.persistentData.putFloat('pulse_x', event.entity.x)
            player.persistentData.putFloat('pulse_y', event.entity.y)
            player.persistentData.putFloat('pulse_z', event.entity.z)
            player.persistentData.putBoolean('pulse_target', false)
        }

    })
})