/**
 * ItemEvents.rightClicked('kubejs:pearls_of_the_moon', event => {
    event.player.tags.add('tears_of_the_moon')
    Utils.server.runCommandSilent(`/photon fx photon:fire_circle_explosion entity ${event.player.username}`)
    Utils.server.scheduleInTicks(1000, () => { // 1000 ticks = 50 seconds
        event.player.tags.remove('tears_of_the_moon')

    })
})

PlayerEvents.tick(event => {
    // if the player does not have the tag, return
    if (!event.player.tags.contains('tears_of_the_moon')) return
    // get a box around the player and add 5 ticks of levitation to every entity in the box except the player
    let box = AABB.of(event.player.x+15, event.player.y+15, event.player.z+15, event.player.x-15, event.player.y-5, event.player.z-15)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    entitiesWithin.forEach(ent => {
        if (ent.alive) {
            if (!ent.player) {
                if (ent.isMonster()) {
                    Utils.server.scheduleInTicks(30, () => {
                        Utils.server.runCommandSilent(`/summon minecraft:tnt ${ent.x} ${ent.y} ${ent.z} {Fuse:0,Fire:1}`)
                        Utils.server.runCommandSilent(`/summon minecraft:tnt ${ent.x} ${ent.y} ${ent.z} {Fuse:0,Fire:1}`)
                        Utils.server.runCommandSilent(`/summon minecraft:tnt ${ent.x} ${ent.y} ${ent.z} {Fuse:0,Fire:1}`)
                    })
                }
            }
        }
    })
})

 * 
 */


ItemEvents.rightClicked('kubejs:pearls_of_the_moon', event => {
    event.player.tags.add('tears_of_the_moon')
    event.player.potionEffects.add('slowness', 300, 2, true, true)
    //Utils.server.runCommandSilent(`/photon fx photon:pearls entity ${event.player.username}`)
    event.player.cooldowns.addCooldown('kubejs:pearls_of_the_moon', 3600) // 3600 ticks = 3 minutes
    Utils.server.scheduleInTicks(300, () => {
        event.player.tags.remove('tears_of_the_moon')
    }) // 300 ticks = 15 seconds
})

EntityEvents.hurt(event => {
    if (!event.entity.player) return
    let player = event.entity
    if (!player.tags.contains('tears_of_the_moon')) return
    if (event.source.actual.tags.contains('boss')) return
    let ent = event.source.actual
    applyEffect(ent, 'minecraft:levitation', 10, 10)
    Utils.server.scheduleInTicks(15, () => {
        if (ent.health < 100) {
            let x = ent.x
            let y = ent.y
            let z = ent.z
            ent.kill()
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle alexscaves:amber_monolith ${x} ${y} ${z} 0.5 0.5 0.5 1000000 2000 force @a`)
            ent.playSound('irons_spellbooks:cast.generic.lightning', 100, 1)
        }
    })
    event.cancel()
})