/**
 * Aethereal Gemstone
 *  - Use to slow all enemies around you for 5 seconds
 * - Hit enemies to launch them (when the time is up) and then explode
 * 
 */

ItemEvents.rightClicked('kubejs:aethereal_gemstone', event => {
    event.player.tags.add('aethereal_gemstone')
    event.player.persistentData.putInt('aethereal_gemstone_counter', 100)
    event.player.potionEffects.add('minecraft:speed', 80, 2, false, true)
    event.player.cooldowns.addCooldown(event.item, 3840) //3840 ticks = 3 minutes
    let player = event.player
    let box = AABB.of(player.x+20, player.y+5, player.z+20, player.x-20, player.y-5, player.z-20)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    entitiesWithin.forEach(ent => {
        if (ent != player) {
            ent.tags.add('aethereal_gemstone_target')
            Utils.server.runCommandSilent(`/effect give ${ent.uuid} minecells:stunned ${player.persistentData.aethereal_gemstone_counter} 1 true`)
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle alexsmobs:skulk_boom ${ent.x} ${ent.y} ${ent.z} 0 0 0 0.01 1`)
            Utils.server.scheduleInTicks(player.persistentData.aethereal_gemstone_counter, () => {
                ent.tags.remove('aethereal_gemstone_target')
            })
        }
    })
})

PlayerEvents.tick(event => {
    if (!event.player.tags.contains('aethereal_gemstone')) return
    event.player.persistentData.aethereal_gemstone_counter -= 1
})

EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    let ent = event.entity
    if (!ent.tags.contains('aethereal_gemstone_target')) return
    if (!player.tags.contains('aethereal_gemstone')) return
    player.knockback(ent, 1, 1)
    let x_rad = player.pitch * JavaMath.PI / 180;
    let y_rad = player.yaw * JavaMath.PI / 180;
    let dirV = {
        x: -Math.sin(y_rad) * Math.cos(x_rad),
        y: -Math.sin(x_rad),
        z: Math.cos(y_rad) * Math.cos(x_rad)
    }
    let tnt = event.level.createEntity('minecraft:tnt')
    tnt.mergeNbt({Fuse: 3})
    let tnt2 = event.level.createEntity('minecraft:tnt')
    tnt2.mergeNbt({Fuse: 3})
    Utils.server.scheduleInTicks(player.persistentData.aethereal_gemstone_counter, () => {
        ent.addMotion(dirV.x * 4, 1.5, dirV.z * 4)
        Utils.server.scheduleInTicks(10, () => {
            tnt.x = ent.x
            tnt.y = ent.y
            tnt.z = ent.z
            tnt.spawn()
            tnt2.x = ent.x
            tnt2.y = ent.y
            tnt2.z = ent.z
            tnt2.spawn()
        })
    })
        
})



// Celestial Glass
let celestial_glass_counter =new WeakMap()
ItemEvents.firstLeftClicked('kubejs:celestial_glass', event => {
    let player = event.player;
    if (player.cooldowns.isOnCooldown('kubejs:celestial_glass')) return
    let arrow = event.level.createEntity('kubejs:entity.celestial_glass');
    arrow.tags.add(`Owner:${event.player.username}`);
    
    // Set the arrow's initial position to be at the player's location
    arrow.setPosition(event.player.x, event.player.y + 1, event.player.z);
    let x_rad = event.player.pitch * JavaMath.PI / 180;
    let y_rad = event.player.yaw * JavaMath.PI / 180;

    let dirV = {
        x: -Math.sin(y_rad) * Math.cos(x_rad),
        y: -Math.sin(x_rad),
        z: Math.cos(y_rad) * Math.cos(x_rad)
    }
    arrow.addMotion(dirV.x * 8, dirV.y * 8, dirV.z * 8)

    // Spawn the arrow in the world
    arrow.spawn();
    arrow.playSound('alexscaves:extinction_spear_throw', 1, 1)
    if (celestial_glass_counter[event.player.username] == undefined) {
        celestial_glass_counter[event.player.username] = 1
    } else {
        celestial_glass_counter[event.player.username] += 1
    }
    if (celestial_glass_counter[event.player.username] == 3) {
        player.cooldowns.addCooldown('kubejs:celestial_glass', 3600)
        celestial_glass_counter[event.player.username] = 0
    }
})


PlayerEvents.tick(event => {
    if (event.player.tags.contains('celestial_glass')) return
    let player = event.player
    let x = player.x
    let y = player.y
    let z = player.z
    let box = AABB.of(x+3, y+3, z+3, x-3, y-3, z-3)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    // Look for the celestial glass entity
    entitiesWithin.forEach(ent => {
        if (ent.type == 'kubejs:entity.celestial_glass') {
            // If the entity is within the box, apply the effect
                player.potionEffects.add('minecraft:regeneration', 40, 3)
                player.potionEffects.add('minecraft:resistance', 40, 3)
                player.potionEffects.add('minecraft:strength', 40, 3)
                player.potionEffects.add('minecraft:absorption', 40, 3)
                player.potionEffects.add('minecraft:night_vision', 280, 3)
                player.tags.add('celestial_glass')
                event.server.scheduleInTicks(40, () => {
                    player.tags.remove('celestial_glass')
                })
        }
    })
})


EntityEvents.spawned('kubejs:entity.celestial_glass', event => {
    Utils.server.scheduleInTicks(10, () => {
        //Utils.server.runCommand(`/photon fx photon:celestial_glass_aura entity ${event.entity.uuid}`)
    })
    event.server.scheduleInTicks(500, () => { // 500 ticks = 25 seconds
        event.entity.playSound('minecraft:block.large_amethyst_bud.place', 1, 1)
        event.entity.kill()

    })
})




ItemEvents.firstRightClicked('kubejs:enslaved_celestial_hammer', event => {
    event.player.swing()
})


//_____________________________________________________________________________________________________________________
// Elderwood Wand: Launches entities into the air and then slams them back down and hits them with a fireball
ItemEvents.entityInteracted('kubejs:elderwood_wand', event => {
    event.player.swing()
    let box = AABB.of(event.target.x+10, event.target.y+10, event.target.z+10, event.target.x-10, event.target.y-10, event.target.z-10)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    entitiesWithin.forEach(ent => {
        if (ent != event.player) {
            if (ent.living) {
                ent.addMotion(0, 2, 0)
                ent.playSound('minecraft:entity.enderman.teleport', 1, 2)
                Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle wrd:snow_particle ${ent.x} ${ent.y+1} ${ent.z} 0.5 0.5 0.5 2 100`)
                Utils.server.scheduleInTicks(25, () => {
                    ent.addMotion(0, -10, 0)
                    Utils.server.scheduleInTicks(8, () => {
                        ent.playSound('irons_spellbooks:spell.gust.cast', 1, 2)
                        applyEffect(ent, 'alexscaves:stunned', 80, 2)
                        event.level.spawnLightning(ent.x, ent.y, ent.z, false)
    
                    })
                })
            }
        }
    })
    //event.player.persistentData.putInt('launch_entity', event.target.uuid)
})

//_____________________________________________________________________________________________________________________

// Corrupted Elderwood Wand
// - Right Click an enemy to make them levitate and then right click again to launch them in the direction you are facing
ItemEvents.entityInteracted('kubejs:corrupted_elderwood_wand', event => {
    let player = event.player
    let target = event.target
    event.player.swing()
    if (target.tags.contains('corrupted_elderwood_wand_target')) return
    Utils.server.scheduleInTicks(10, () => {
        target.tags.add(`corrupted_elderwood_wand_target`)
    })
        applyEffect(target, 'minecraft:levitation', 100, 1)
        target.playSound('irons_spellbooks:cast.generic.nature', 1, 2)
        Utils.server.scheduleInTicks(100, () => {
            target.tags.remove(`corrupted_elderwood_wand_target`)
        })
    //event.player.persistentData.putInt('launch_entity', event.target.uuid)
})

ItemEvents.rightClicked('kubejs:corrupted_elderwood_wand', event => {
    let player = event.player
    event.player.swing()
    let box = AABB.of(player.x+15, player.y+15, player.z+15, player.x-15, player.y-15, player.z-15)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    player.magicData.setMana(player.magicData.getMana() - 10)
    entitiesWithin.forEach(ent => {
        if (ent.tags.contains('corrupted_elderwood_wand_target')) {
            let x_rad = player.pitch * JavaMath.PI / 180;
            let y_rad = player.yaw * JavaMath.PI / 180;
            let dirV = {
                x: -Math.sin(y_rad) * Math.cos(x_rad),
                y: -Math.sin(x_rad),
                z: Math.cos(y_rad) * Math.cos(x_rad)
            }
            ent.addMotion(dirV.x * 3, dirV.y * 3.4, dirV.z * 3)
            Utils.server.runCommandSilent(`/effect clear ${ent.uuid} minecraft:levitation`)
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle cataclysm:phantom_wing_flame ${ent.x} ${ent.y+1} ${ent.z} 0 0 0 0.1 30`)
            ent.playSound('irons_spellbooks:spell.gust.cast', 1, 2)
            Utils.server.scheduleInTicks(25, () => {
                ent.addMotion(0, -10, 0)
            })
            
            Utils.server.scheduleInTicks(35, () => {
                if (!ent.alive) return
                Utils.server.runCommandSilent(`/summon minecraft:fireball ${ent.x} ${ent.y+3} ${ent.z} {ExplosionPower:3, Motion:[0.0, -3.0, 0.0]}`)
                Utils.server.scheduleInTicks(3, () => {
                    if (!ent.alive) return
                    Utils.server.runCommandSilent(`/summon minecraft:fireball ${ent.x} ${ent.y+3} ${ent.z} {ExplosionPower:3, Motion:[0.0, -3.0, 0.0]}`)
                    Utils.server.scheduleInTicks(3, () => {
                        if (!ent.alive) return
                        Utils.server.runCommandSilent(`/summon minecraft:fireball ${ent.x} ${ent.y+3} ${ent.z} {ExplosionPower:3, Motion:[0.0, -3.0, 0.0]}`)
                    })
                })
            })
        }
    })
})
//_____________________________________________________________________________________________________________________


// Archangel Wand
// - Right Click to launch a ball of lightning. If the ball hits an entity, that entity will be teleported to the crosshair location

/**
 * ItemEvents.pickedUp(`kubejs:archangel_wand`, event => {
    //if (event.player.persistentData.get('archangel')) return
    event.player.persistentData.putInt('archangel', 0)
})



ItemEvents.rightClicked('kubejs:archangel_wand', event => {
    let player = event.player
    player.swing()
    if (player.persistentData.archangel == 0) {
        let ball = event.level.createEntity('irons_spellbooks:ball_lightning')
        let x_rad = player.pitch * JavaMath.PI / 180;
        let y_rad = player.yaw * JavaMath.PI / 180;
        let dirV = {
            x: -Math.sin(y_rad) * Math.cos(x_rad),
            y: -Math.sin(x_rad),
            z: Math.cos(y_rad) * Math.cos(x_rad)
        }
        ball.setPosition(player.x, player.y+1, player.z)
        ball.addMotion(dirV.x * 1.5, dirV.y * 1.5, dirV.z * 1.5)
        ball.tags.add(`archangel_ball`)
        ball.tags.add(`Owner:${player.username}`)
        ball.spawn()
    }

})



EntityEvents.hurt(event => {
    if (!event.entity.alive) return
    
    if (event.source.immediate == null || event.source.immediate == undefined) return
    if (event.source.immediate.type != 'irons_spellbooks:ball_lightning') return
    if (!event.source.immediate.tags.contains('archangel_ball')) return
    if (event.entity.tags.contains('archangel_ball_target')) return
    let player_username = event.source.immediate.tags.find(tag => tag.startsWith('Owner')).split(':')[1]
    let player = event.server.getPlayer(player_username)
    if (event.entity == player) return
    event.entity.tags.add(`archangel_ball_target`)
    //event.entity.attack(5)
    event.entity.tags.add(`_archangel_${player_username}`)
    event.server.scheduleInTicks(5, e => {
            e.repeating = true
            // Get the crosshair location
            let x_rad = player.pitch * JavaMath.PI / 180;
            let y_rad = player.yaw * JavaMath.PI / 180;
            let dirV2 = {
                x: -Math.sin(y_rad) * Math.cos(x_rad),
                y: -Math.sin(x_rad),
                z: Math.cos(y_rad) * Math.cos(x_rad)
            }
            let crosshair_location = {
                x: player.x + dirV2.x * 8,
                y: player.y + dirV2.y * 8,
                z: player.z + dirV2.z * 8
            }

            let box = AABB.of(player.x+30, player.y+30, player.z+30, player.x-30, player.y-30, player.z-30)
            let dim = event.level
            let entitiesWithin = dim.getEntitiesWithin(box)
            entitiesWithin.forEach(ent => {
                if (!ent.alive) return
                if (!ent.tags.contains(`_archangel_${player_username}`)) return
                // move the entity to the crosshair location
                ent.addMotion((crosshair_location.x * -1) - ent.x, (crosshair_location.y * -1) - ent.y, (crosshair_location.z * -1) - ent.z)
            })
        })

})
 * 
 */

ItemEvents.pickedUp(`kubejs:archangel_wand`, event => {
    event.player.persistentData.putInt('archangel', 0)
})
    
ItemEvents.rightClicked('kubejs:archangel_wand', event => {
    
    if (event.player.mainHandItem == event.item) return
    let player = event.player
    if (player.persistentData.archangel == 1) {
        player.persistentData.archangel = 0
        return
    } else if (player.persistentData.archangel == 0) {
        player.persistentData.archangel = 1
    }
    let x_rad = player.pitch * JavaMath.PI / 180;
    let y_rad = player.yaw * JavaMath.PI / 180;
    let diV = {
        x: -Math.sin(y_rad) * Math.cos(x_rad),
        y: -Math.sin(x_rad),
        z: Math.cos(y_rad) * Math.cos(x_rad)
    }
    // get the crosshair location
    let cross_location = {
        x: player.x + diV.x * 8,
        y: player.y+1.5 + diV.y * 8,
        z: player.z + diV.z * 8
    }
    let box = AABB.of(player.x+15, player.y+15, player.z+15, player.x-15, player.y-15, player.z-15)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    entitiesWithin.forEach(ent => {
        if (ent != player) {
            if (ent.alive) {
                if (ent.pickable) {
                    ent.teleportTo(cross_location.x, cross_location.y, cross_location.z)
                }
            }
        }
    })
    Utils.server.scheduleInTicks(2, e => {
        if (player.persistentData.archangel == 0 || player.magicData.mana < 1) {
            player.persistentData.archangel = 0
            e.repeating = false
            return
        } else if (player.persistentData.archangel == 1) {
            e.repeating = true
        }
            let x_rad = player.pitch * JavaMath.PI / 180;
            let y_rad = player.yaw * JavaMath.PI / 180;
            let dirV = {
                x: -Math.sin(y_rad) * Math.cos(x_rad),
                y: -Math.sin(x_rad),
                z: Math.cos(y_rad) * Math.cos(x_rad)
            }
            // get the crosshair location
            let crosshair_location = {
                x: player.x + dirV.x * 8,
                y: player.y+1.5 + dirV.y * 8,
                z: player.z + dirV.z * 8
            }
            let mod = 0.2
            let box = AABB.of(player.x+15, player.y+15, player.z+15, player.x-15, player.y-15, player.z-15)
            let dim = event.level
            let entitiesWithin = dim.getEntitiesWithin(box)
            entitiesWithin.forEach(ent => {
                if (ent != player) { 
                    if (ent != undefined) {
                            if (ent.pickable) {
                                ent.addMotion((crosshair_location.x - ent.x)*mod, (crosshair_location.y - ent.y)*mod, (crosshair_location.z - ent.z)*mod)
                            }
                    // pull entities towards the crosshair location
                    
                    
                    }
                }
            })
        })
})

ItemEvents.firstLeftClicked('minecraft:air', event => {
    if (event.player.offHandItem != 'kubejs:archangel_wand') return
    if (event.player.persistentData.archangel == 0) return
    if (event.player.magicData.mana < 5) return
    if (event.player.magicData.casting) return
    let dim = event.level.dimension
    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${event.player.username} ball_lightning 3`)
    event.player.magicData.setMana(event.player.magicData.mana - 15)

})

//_+_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_+_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_+_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_+_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
//_____________________________________________________________________________________________________________________
// Enslaved Celestial Hammer
ItemEvents.pickedUp(`kubejs:enslaved_celestial_hammer`, event => {
    event.player.persistentData.putInt('enslaved_celestial', 0)
})
    
ItemEvents.rightClicked('kubejs:enslaved_celestial_hammer', event => {
    if (event.player.mainHandItem == event.item) return
    let player = event.player
    if (player.persistentData.enslaved_celestial == 1) {
        player.persistentData.enslaved_celestial = 0
        return
    } else if (player.persistentData.enslaved_celestial == 0) {
        player.persistentData.enslaved_celestial = 1
    }
    let x_rad = player.pitch * JavaMath.PI / 180;
    let y_rad = player.yaw * JavaMath.PI / 180;
    let diV = {
        x: -Math.sin(y_rad) * Math.cos(x_rad),
        y: -Math.sin(x_rad),
        z: Math.cos(y_rad) * Math.cos(x_rad)
    }
    // get the crosshair location
    let cross_location = {
        x: player.x + diV.x * 8,
        y: player.y+1.5 + diV.y * 8,
        z: player.z + diV.z * 8
    }
    let box = AABB.of(player.x+30, player.y+30, player.z+30, player.x-30, player.y-30, player.z-30)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    entitiesWithin.forEach(ent => {
        if (ent != player) {
            if (ent.alive) {
                ent.teleportTo(cross_location.x, cross_location.y, cross_location.z)
            }
        }
    })
    Utils.server.scheduleInTicks(2, e => {
        if (player.persistentData.enslaved_celestial == 0 || player.magicData.mana < 2) {
            player.persistentData.enslaved_celestial = 0
            e.repeating = false
            return
        } else if (player.persistentData.enslaved_celestial == 1) {
            e.repeating = true
        }
            let x_rad = player.pitch * JavaMath.PI / 180;
            let y_rad = player.yaw * JavaMath.PI / 180;
            let dirV = {
                x: -Math.sin(y_rad) * Math.cos(x_rad),
                y: -Math.sin(x_rad),
                z: Math.cos(y_rad) * Math.cos(x_rad)
            }
            // get the crosshair location
            let crosshair_location = {
                x: player.x + dirV.x * 8,
                y: player.y+1.5 + dirV.y * 8,
                z: player.z + dirV.z * 8
            }
            let mod = 0.2
            let box = AABB.of(player.x+30, player.y+30, player.z+30, player.x-30, player.y-30, player.z-30)
            let dim = event.level
            let entitiesWithin = dim.getEntitiesWithin(box)
            player.magicData.setMana(player.magicData.mana - 2)
            entitiesWithin.forEach(ent => {
                if (ent != player) { 
                    if (ent != undefined) {
                    // pull entities towards the crosshair location
                    ent.tags.add('enslaved_celestial_target')
                    ent.addMotion((crosshair_location.x - ent.x)*mod, (crosshair_location.y - ent.y)*mod, (crosshair_location.z - ent.z)*mod)
                    
                    }
                }
            })
        })
})

ItemEvents.firstLeftClicked('minecraft:air', event => {
    if (event.player.offHandItem != 'kubejs:enslaved_celestial_hammer') return
    if (event.player.persistentData.enslaved_celestial == 0) return
    if (event.player.magicData.mana < 2) return
    if (event.player.magicData.casting) return
    let dim = event.level.dimension
    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${event.player.username} ray_of_frost`)
    
})

EntityEvents.hurt(event => {
    if (!event.source.player) return
    let spell = isSpellDamageSource(event.source)
    if (!spell) return
    let player = event.source.player
    if (player.magicData.castingSpellId != 'irons_spellbooks:ray_of_frost') return
    if (!event.entity.tags.contains('enslaved_celestial_target')) return
    player.magicData.setMana(0)
    Utils.server.runCommandSilent(`/summon alexscaves:nuclear_bomb ${event.entity.x} ${event.entity.y+30} ${event.entity.z} {Motion:[0.0,-5.0,0.0]}`)
})


// Nebulous Flux
let trail_names = [
    'nebulous_flux_purple',
    'nebulous_flux_teal',
    'nebulous_flux_orange',
]


ItemEvents.firstLeftClicked(event => {
    if (!event.item.toString().includes('crossbow')) return
    if (detectCurios(event.player, 'kubejs:nebulous_flux') == false) return
    if (event.player.cooldowns.isOnCooldown('minecraft:crossbow')) return
    if (event.item.nbt.get('Charged').toString() != '1b') return
    let player = event.player
    let crossbowOffset = 0.5; // This value may need to be adjusted
    let heightOffset = -0.2; // Adjusted value for slight lowering
    // Get the amount of arrows in the player's inventory
    let rand_arrows = 0
    let arrows = event.player.inventory.countItem('minecraft:arrow')
    if (arrows < 1) return
    if (arrows > 4) {
        rand_arrows = Utils.random.nextInt(2, 4)
    } else {
        rand_arrows = Utils.random.nextInt(2, arrows)
    }

    // loop through rand_arrows
    for (let i = 0; i < rand_arrows; i++) {
        let rand_delay = Utils.random.nextInt(1, 3)
        Utils.server.scheduleInTicks(i+rand_delay, () => {
            let arrow = event.level.createEntity('minecraft:arrow');
            arrow.tags.add(`Owner:${event.player.username}`);            
    
            let x_rad = event.player.pitch * JavaMath.PI / 180;
            let y_rad = event.player.yaw * JavaMath.PI / 180;
            let dirV = {
                x: -Math.sin(y_rad) * Math.cos(x_rad),
                y: -Math.sin(x_rad),
                z: Math.cos(y_rad) * Math.cos(x_rad)}
            let rand_velocity = Utils.random.nextInt(4, 10)
            arrow.addMotion(dirV.x * rand_velocity, dirV.y * rand_velocity, dirV.z * rand_velocity)
    
            let crossbowPos = {
                x: player.x - Math.sin(y_rad) * crossbowOffset,
                y: player.y + player.getEyeHeight() + heightOffset,
                z: player.z + Math.cos(y_rad) * crossbowOffset};
    
            arrow.setPosition(crossbowPos.x, crossbowPos.y, crossbowPos.z);
            let rand_lightning = Utils.random.nextInt(1, 40)
            if (rand_lightning == 1) {
                arrow.addTag('lightning_arrow')
                //Utils.server.tell('Lightning Arrow')
            }
            let rand_poison = Utils.random.nextInt(1, 20)
            if (rand_poison == 1) {
                arrow.addTag('poison_arrow')
                //Utils.server.tell('Poison Arrow')
            }
            let rand_slow = Utils.random.nextInt(1, 20)
            if (rand_slow == 1) {
                arrow.addTag('slow_arrow')
                //Utils.server.tell('Slow Arrow')
            }
            let rand_explosive = Utils.random.nextInt(1, 20)
            if (rand_explosive == 1) {
                arrow.addTag('explosive_arrow')
                //Utils.server.tell('Explosive Arrow')
            }
            let rand_launch = Utils.random.nextInt(1, 20)
            if (rand_launch == 1) {
                arrow.addTag('launch_arrow')
                //Utils.server.tell('Launch Arrow')
            }
            let rand_stun = Utils.random.nextInt(1, 20)
            if (rand_stun == 1) {
                arrow.addTag('stun_arrow')
                //Utils.server.tell('Stun Arrow')
            }
            arrow.spawn();
            // get random trail name from trail_names array
            let rand_trail = trail_names[Utils.random.nextInt(0, trail_names.length)]
            //Utils.server.runCommandSilent(`/photon fx photon:${rand_trail} entity ${arrow.uuid}`)
            arrow.playSound('minecraft:item.crossbow.shoot', 1, 1)
            if (!event.player.creative) {
                let slot = event.player.inventory.findSlotMatchingItem('minecraft:arrow')
                event.player.inventory.extractItem(slot, 1, false)
            }
            Utils.server.scheduleInTicks(100, () => {
                arrow.kill()
            })
        })
    }
    event.player.cooldowns.addCooldown('minecraft:crossbow', 5)
})

// rewrite the above code to use a for loop instead of nested if statements. Loop between 2 and 4 times

EntityEvents.hurt(event => {
    if (event.source.immediate === null) return
    let imm = event.source.immediate
    if (!imm.tags.contains('lightning_arrow') && !imm.tags.contains('poison_arrow') && !imm.tags.contains('slow_arrow') && !imm.tags.contains('explosive_arrow') && !imm.tags.contains('launch_arrow') && !imm.tags.contains('stun_arrow')) return
    if (event.source.immediate.tags.contains('lightning_arrow')) {
        event.level.spawnLightning(event.entity.x, event.entity.y, event.entity.z, false)
    } else if (event.source.immediate.tags.contains('poison_arrow')) {
        applyEffect(event.entity, 'minecells:bleeding', 200, 1)
    } else if (event.source.immediate.tags.contains('slow_arrow')) {
        applyEffect(event.entity, 'minecraft:slowness', 200, 1)
    } else if (event.source.immediate.tags.contains('explosive_arrow')) {
        if (event.entity.player) {
            Utils.server.runCommandSilent(`/summon minecraft:tnt ${event.entity.x} ${event.entity.y} ${event.entity.z} {Fuse:40}`)
        } else {
            Utils.server.runCommandSilent(`/summon minecraft:fireball ${event.entity.x} ${event.entity.y+4} ${event.entity.z} {ExplosionPower:2, Motion: [0.0,-4.0,0.0], Fire:1}`)
        }
    } else if (event.source.immediate.tags.contains('launch_arrow')) {
        if (event.entity.player) {
            event.entity.addMotion(0, 2, 0)
        } else {
            event.entity.addMotion(0, 3, 0)
        }
    } else if (event.source.immediate.tags.contains('stun_arrow')) {
        applyEffect(event.entity, 'alexscaves:stunned', 200, 1)
    }
    Utils.server.runCommandSilent(`/damage ${event.entity.uuid} ${event.damage} minecraft:arrow by ${event.source.actual}`)
    event.entity.attack(4)
    event.cancel()
})


/**
 * 
 * Corrupted Gemstone
 */
EntityEvents.hurt(event => {
    if (!event.entity.alive) return
    let player = null
    if (event.source.player) {
        player = event.source.player
    }
    let box = AABB.of(event.entity.x+5, event.entity.y+3, event.entity.z+5, event.entity.x-5, event.entity.y-3, event.entity.z-5)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)

    // use a filter to see if theres a corrupted shard entity
    let corrupted_gemstone = entitiesWithin.filter(entity => entity.type == 'kubejs:entity.corrupted_gemstone')
    if (corrupted_gemstone.length == 0) {
        return
    } else {
        applyEffect(event.entity, 'minecraft:slowness', 100, 0)
        applyEffect(event.entity, 'minecraft:weakness', 100, 0)
    }
})

let corrupted_gemstone_counter =new WeakMap()
ItemEvents.firstLeftClicked('kubejs:corrupted_gemstone', event => {
    let player = event.player;
    if (player.cooldowns.isOnCooldown('kubejs:corrupted_gemstone')) return
        let arrow = event.level.createEntity('kubejs:entity.corrupted_gemstone');
        arrow.tags.add(`Owner:${event.player.username}`);
        
        // Set the arrow's initial position to be at the player's location
        arrow.setPosition(event.player.x, event.player.y + 1, event.player.z);
        let x_rad = event.player.pitch * JavaMath.PI / 180;
        let y_rad = event.player.yaw * JavaMath.PI / 180;
    
        let dirV = {
            x: -Math.sin(y_rad) * Math.cos(x_rad),
            y: -Math.sin(x_rad),
            z: Math.cos(y_rad) * Math.cos(x_rad)
        }
        arrow.addMotion(dirV.x * 8, dirV.y * 8, dirV.z * 8)
    
        // Spawn the arrow in the world
        arrow.spawn();
        arrow.playSound('alexscaves:extinction_spear_throw', 1, 1)
        if (corrupted_gemstone_counter[event.player.username] == undefined) {
            corrupted_gemstone_counter[event.player.username] = 1
        } else {
            corrupted_gemstone_counter[event.player.username] += 1
        }
        if (corrupted_gemstone_counter[event.player.username] == 3) {
            player.cooldowns.addCooldown('kubejs:corrupted_gemstone', 3600)
            corrupted_gemstone_counter[event.player.username] = 0
        }
})
// Cultists Gauntlet
ItemEvents.entityInteracted('kubejs:cultists_gauntlet', event => {
    if (event.target.tags.contains('boss')) return
    //if (event.player.mainHandItem == event.item) return
    if (!event.player.persistentData.get('cultists_gauntlet')) {
        event.player.persistentData.putInt('cultists_gauntlet', 0)
        event.player.persistentData.putInt('cultists_gauntlet_count', 0)
    }
    let player = event.player
    player.swing()
    if (player.persistentData.cultists_gauntlet == 1) {
        player.persistentData.cultists_gauntlet = 0
        return
    } else if (player.persistentData.cultists_gauntlet == 0) {
        player.persistentData.cultists_gauntlet = 1
    }
    let x_rad = player.pitch * JavaMath.PI / 180;
    let y_rad = player.yaw * JavaMath.PI / 180;
    let dirV = {
        x: -Math.sin(y_rad) * Math.cos(x_rad),
        y: -Math.sin(x_rad),
        z: Math.cos(y_rad) * Math.cos(x_rad)
    }
    // get the crosshair location
    let crosshair_location = {
        x: player.x + dirV.x * 2.2,
        y: player.y+1.6 + dirV.y * 2.2,
        z: player.z + dirV.z * 2.2
    }

    let ent = event.target
    ent.teleportTo(crosshair_location.x, crosshair_location.y, crosshair_location.z)
    ent.playSound('irons_spellbooks:cast.void_tentacles.start', 10, 2)
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle blue_skies:black_flame ${ent.x} ${ent.y+1} ${ent.z} 0.5 0.5 0.5 0.05 50`)
    Utils.server.scheduleInTicks(1, e => {
        if (player.persistentData.cultists_gauntlet == 0) {
            player.persistentData.cultists_gauntlet = 0
            e.repeating = false
            ent.tags.remove('cultists_gauntlet_target')
            return
        } else if (player.persistentData.cultists_gauntlet == 1) {
            e.repeating = true
            player.persistentData.cultists_gauntlet_count += 1
            if (player.persistentData.cultists_gauntlet_count > 10) {
                player.persistentData.cultists_gauntlet_count = 0
                player.magicData.setMana(player.magicData.mana-5)
            }
        }
        let x_rad = player.pitch * JavaMath.PI / 180;
        let y_rad = player.yaw * JavaMath.PI / 180;
        let dirV = {
            x: -Math.sin(y_rad) * Math.cos(x_rad),
            y: -Math.sin(x_rad),
            z: Math.cos(y_rad) * Math.cos(x_rad)
        }
        // get the crosshair location
        let crosshair_location = {
            x: player.x + dirV.x * 2.2,
            y: player.y+1.6 + dirV.y * 2.2,
            z: player.z + dirV.z * 2.2
        }
        let mod = 0.15
        ent.addMotion((crosshair_location.x - ent.x)*mod, (crosshair_location.y - ent.y)*mod, (crosshair_location.z - ent.z)*mod)
        ent.tags.add('cultists_gauntlet_target')
        
    })
})

EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (event.entity == null) return
    if (!event.entity.tags.contains('cultists_gauntlet_target')) return
    let player = event.source.player
    if (player.persistentData.cultists_gauntlet != 1) return
    player.persistentData.cultists_gauntlet = 0
    let entity = event.entity
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle irons_spellbooks:spark 5 0.09 0.09 ${entity.x} ${entity.y+1} ${entity.z} 0.5 0.5 0.5 0.1 80`)
    entity.tags.remove('cultists_gauntlet_target')
    let x_rad = player.pitch * JavaMath.PI / 180;
    let y_rad = player.yaw * JavaMath.PI / 180;
    let dirV = {
        x: -Math.sin(y_rad) * Math.cos(x_rad),
        y: -Math.sin(x_rad),
        z: Math.cos(y_rad) * Math.cos(x_rad)
    }
    entity.playSound('blocky_siege:crusher_slam', 10, 2)
    entity.addMotion(dirV.x*7, dirV.y*7, dirV.z*7)


    


})



















