/**
 * Inferno Items:
 * 
 * - Inferno:
 *  - Gain a speed effect and a fire trail effect from runiclib
 * 
 * - Blood Inferno:
 *  - Let the player fly with the blazing dash effect. No effect when hitting enemies
 * 
 * - Electric Inferno:
 *  - Blood sweet_inferno but faster flying and a lightning strike effect when hitting enemies
 * 
 * - Eldritch Inferno: 
 *  - Electric sweet_inferno but with a fireball effect when hitting enemies. Give the fireball a trail effect
 *  - Give the explosion an effect as well
 * 
 * 
 */


// Inferno

/**
 * ItemEvents.rightClicked('kubejs:sweet_inferno', event => {
    event.player.potionEffects.add('minecraft:speed', 600, 3, false, true)
    event.player.potionEffects.add('runiclib:burning_thorns', 600, 2, false, true)
    event.player.potionEffects.add('runiclib:lava_walking', 600, 2, false, true)
    //event.player.cooldowns.addCooldown(event.item, 3840) //3840 ticks = 3 minutes
})
 * 
 */

let imprisoned_embers_counter =new WeakMap()
ItemEvents.rightClicked('kubejs:imprisoned_embers', event => {
    let player = event.player;
    if (event.player.shiftKeyDown) {
        if (imprisoned_embers_counter[event.player.username] == undefined) {
            imprisoned_embers_counter[event.player.username] = 1
            Utils.server.runCommandSilent(`execute as ${player.username} run playsound rats:item.rats.ratlantean_flame.shoot ambient @s ${player.x} ${player.y} ${player.z} 10 1`)
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle minecraft:flame ${player.x} ${player.y} ${player.z} 1 1 1 0.5 200`)
        } else if (imprisoned_embers_counter[event.player.username] < 5) {
            imprisoned_embers_counter[event.player.username] += 1
            Utils.server.runCommandSilent(`execute as ${player.username} run playsound rats:item.rats.ratlantean_flame.shoot ambient @s ${player.x} ${player.y} ${player.z} 10 1`)
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle minecraft:flame ${player.x} ${player.y} ${player.z} 1 1 1 0.5 200`)
        } else if (imprisoned_embers_counter[event.player.username] >= 5) {
            imprisoned_embers_counter[event.player.username] = 5
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle blue_skies:blue_flame ${player.x} ${player.y} ${player.z} 1 1 1 0.5 200`)
            Utils.server.runCommandSilent(`execute as ${player.username} run playsound blocky_siege:massive_charge_up ambient @s ${player.x} ${player.y} ${player.z} 10 2`)
        }
    } else {
        
        let explosionpower = imprisoned_embers_counter[event.player.username]
        if (explosionpower == undefined) {
            explosionpower = 1
        }
        if (explosionpower == 0) {
            explosionpower = 1
        }
        // loop through explosion power
        for (let i = 0; i < explosionpower; i++) {
            event.server.scheduleInTicks(4 * i, () => {
                let dim = event.level.dimension
    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${player.username} burning_dash`)
            })
        }
        imprisoned_embers_counter[event.player.username] = 0
        event.player.cooldowns.addCooldown('kubejs:imprisoned_embers', 1200)
    }
})







ItemEvents.rightClicked('kubejs:bloody_inferno', event => {
    let player = event.player
    //if (!player.persistentData.get('kubejs_class:disciple')) return
    player.tags.add('blood_active')
    player.persistentData.putInt('blood_counter', 7)
    player.cooldowns.addCooldown(event.item, 3840) //3840 ticks = 3 minutes
    event.server.scheduleInTicks(400, () => {
        player.tags.remove('blood_active')
        player.tags.remove('blood_activate')
        // add slow falling
        player.potionEffects.add('minecraft:slow_falling', 200, 0, true, true)
    
    })
})

PlayerEvents.tick(event => {
    if (!event.player.tags.contains('blood_active')) return
    if (event.player.magicData.casting) return
    if (event.player.shiftKeyDown) {
        event.player.tags.add('blood_activate')
        if (event.player.persistentData.blood_counter > 0) {
            event.player.persistentData.blood_counter -= 1
        } else {
            let dim = event.level.dimension
    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${event.player.username} burning_dash`)
            event.player.persistentData.blood_counter = 7
        }
    } else {
        event.player.tags.remove('blood_activate')
    }

})

EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.tags.contains('blood_activate')) return
    // spawn lightning
    applyEffect(event.entity, 'minecells:bleeding', 200, 0)
})








//_______________________________________________________________________________________________________________________


// electric Inferno
// Obtain by standing on a lightning rod and getting hit with lightning while holding bloody inferno
EntityEvents.hurt(event => {
    if (!event.entity.player) return
    let player = event.entity
    if (player.blockStateOn.block.id != 'minecraft:lightning_rod') return
    // detect if the source of damage is a lightning bolt
    if (!event.source.toString().includes('lightningBolt')) return
    let blood = player.inventory.countItem('kubejs:bloody_inferno')
    if (blood < 1) return
    let slot = player.inventory.findSlotMatchingItem('kubejs:bloody_inferno')
    player.inventory.extractItem(slot, 1, false)
    player.give('kubejs:electric_inferno')
})




ItemEvents.rightClicked('kubejs:electric_inferno', event => {
    let player = event.player
    //if (!player.persistentData.get('kubejs_class:disciple')) return
    player.tags.add('electric_active')
    player.persistentData.putInt('electric_counter', 4)
    player.cooldowns.addCooldown(event.item, 3840) //3840 ticks = 3 minutes
    event.server.scheduleInTicks(600, () => {
        player.tags.remove('electric_active')
        player.tags.remove('electric_activate')
        // add slow falling
        player.potionEffects.add('minecraft:slow_falling', 20, 0, true, true)
        player.potionEffects.add('irons_spellbooks:angel_wings', 200, 0, true, true)
    })
})

PlayerEvents.tick(event => {
    if (!event.player.tags.contains('electric_active')) return
    if (event.player.magicData.casting) return
    if (event.player.shiftKeyDown) {
        event.player.tags.add('electric_activate')
        if (event.player.persistentData.electric_counter > 0) {
            event.player.persistentData.electric_counter -= 1
        } else {
            let dim = event.level.dimension
    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${event.player.username} burning_dash`)
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle alexscaves:blue_hazmat_breathe ${event.player.x} ${event.player.y} ${event.player.z} 2 2 2 5 300`)
            event.player.persistentData.electric_counter = 4
        }
    } else {
        event.player.tags.remove('electric_activate')
    }

})

EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.tags.contains('electric_activate')) return
    // spawn lightning
    event.level.spawnLightning(event.entity.x, event.entity.y, event.entity.z, false)
})



//_______________________________________________________________________________________________________________________

// Eldritch Inferno
ItemEvents.rightClicked('kubejs:eldritch_inferno', event => {
    let player = event.player
    player.tags.add('eldritch_active')
    player.persistentData.putInt('eldritch_counter', 3)
    player.cooldowns.addCooldown(event.item, 3840) //3840 ticks = 3 minutes
    event.server.scheduleInTicks(200, () => {
        player.tags.remove('eldritch_active')
        player.tags.remove('eldritch_activate')
        player.tags.add('eldritch_cooldown')
        // add slow falling
        player.potionEffects.add('irons_spellbooks:angel_wings', 99999, 0, true, true)
    })
})

PlayerEvents.tick(event => {
    if (!event.player.tags.contains('eldritch_cooldown')) return
    if (event.player.blockStateOn.air) return 
    Utils.server.runCommandSilent(`/effect clear ${event.player.username} irons_spellbooks:angel_wings`)
    event.player.tags.remove('eldritch_cooldown')
})



PlayerEvents.tick(event => {
    if (!event.player.tags.contains('eldritch_active')) return
    if (event.player.magicData.casting) return
    if (event.player.shiftKeyDown) {
        event.player.tags.add('eldritch_activate')
        if (event.player.persistentData.eldritch_counter > 0) {
            event.player.persistentData.eldritch_counter -= 1
        } else {
            let dim = event.level.dimension
    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${event.player.username} burning_dash`)
            Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle alexscaves:hazmat_breathe ${event.player.x} ${event.player.y} ${event.player.z} 2 2 2 5 800`)
            event.player.persistentData.eldritch_counter = 3
        }
    } else {
        event.player.tags.remove('eldritch_activate')
    }
})



EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.tags.contains('eldritch_activate')) return
    //spawn a fireball above the enemy that is moving down towards the enemy
    let fireball = event.level.createEntity('minecraft:fireball');
    fireball.x = event.entity.x
    fireball.y = event.entity.y + 3
    fireball.z = event.entity.z
    fireball.addMotion(0, -2, 0)
    fireball.tags.add(`eldritch_fireball:${player.username}`)
    fireball.mergeNbt({
        ExplosionPower: 3
    })
    fireball.spawn()
})

EntityEvents.hurt(event => {
    if (!event.entity.player) return
    let player = event.entity
    if (!player.tags.contains('eldritch_activate')) return
    event.cancel()
})

//_______________________________________________________________________________________________________________________

PlayerEvents.respawned(event => {
        event.player.tags.remove('electric_activate')
        event.player.tags.remove('electric_active')

        event.player.tags.remove('blood_active')
        event.player.tags.remove('blood_activate')

        event.player.tags.remove('inferno_active')
        event.player.tags.remove('inferno_activate')

        event.player.tags.remove('eldritch_active')
        event.player.tags.remove('eldritch_activate')
    
})

