
ItemEvents.rightClicked('kubejs:imprisoned_star', event => {
    event.player.tags.add('imprisoned_star')
    Utils.server.scheduleInTicks(3600, () => {
        event.player.tags.remove('imprisoned_star')
    })
    event.player.potionEffects.add('mowziesmobs:suns_blessing', 3600, 0)
    //event.player.cooldowns.addCooldown(event.item, 15600)
})

PlayerEvents.tick(event => {
    if (!event.player.tags.contains('imprisoned_star')) return
    if (event.player.potionEffects.isActive('mowziesmobs:suns_blessing')) return
    event.player.potionEffects.add('mowziesmobs:suns_blessing', 400, 0)
})

EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (event.source.immediate == null) return
    if (event.source.immediate.type == 'mowziesmobs:solar_beam') {
        event.entity.attack(4)
        event.level.spawnLightning(event.entity.x, event.entity.y, event.entity.z, false)
    } else if (event.source.immediate.type == 'mowziesmobs:super_nova') {
        event.entity.attack(40)
        let fireball = event.level.createEntity('minecraft:fireball');
        fireball.setPosition(player.x, player.y+2, player.z)
        fireball.addMotion(0, -1, 0)
        fireball.mergeNbt({
            ExplosionPower: 10
        })
        fireball.spawn()
        Utils.server.scheduleInTicks(20, () => {
            player.kill()
        })
    } else if (event.source.immediate.type == 'mowziesmobs:sunstrike') {
        event.entity.attack(15)
    }
})

PlayerEvents.respawned(event => {
    if (event.player.tags.contains('imprisoned_star')) {
        event.player.tags.remove('imprisoned_star')
    }
})

/**
 * Sun damage immediate types:
 *  - Beam: solar_beam
 *  - huge blast: super nova
 *  - sun blast: sunstrike
 */