






ItemEvents.rightClicked('kubejs:heart_of_darkness', event => {
    event.player.tags.add('heart_of_darkness')
    event.player.potionEffects.add('minecraft:blindness', 600, 0, false, true)
    event.player.potionEffects.add('minecraft:speed', 600, 3, false, true)
    event.player.potionEffects.add('minecraft:haste', 600, 2, false, true)
    event.player.potionEffects.add('minecraft:strength', 600, 2, false, true)
    Utils.server.runCommandSilent(`/sanity set ${event.player.username} 0`)
    event.server.scheduleInTicks(600, () => {
        event.player.tags.remove('heart_of_darkness')
        Utils.server.runCommandSilent(`/sanity set ${event.player.username} 100`)
    })
})



PlayerEvents.tick(event => {
    if (!event.player.tags.contains('heart_of_darkness')) return
    let box = AABB.of(event.player.x+15, event.player.y+5, event.player.z+15, event.player.x-15, event.player.y-5, event.player.z-15)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    entitiesWithin.forEach(ent => {
        if (ent != event.player) {
            if (!ent.tags.contains('heart_of_darkness_target')) {
                ent.tags.add('heart_of_darkness_target')
                applyEffect(ent, 'minecraft:glowing', 60, 0)
                Utils.server.scheduleInTicks(60, () => {
                    ent.tags.remove('heart_of_darkness_target')
                })
            }

        }
    })
})