ItemEvents.firstLeftClicked('kubejs:echoing_void', event => {
    let player = event.player;
    if (player.cooldowns.isOnCooldown('kubejs:echoing_void')) return
        if (event.server.persistentData.get('minecraft:warden_dead')) {
            player.cooldowns.addCooldown('kubejs:echoing_void', 600)
        } else {
            player.cooldowns.addCooldown('kubejs:echoing_void', 999999)
        }
        
        let arrow = event.level.createEntity('kubejs:entity.echoing_void');
        arrow.tags.add(`Owner:${event.player.username}`);
        arrow.tags.add('echoing_void')
        
        // Set the arrow's initial position to be at the player's location
        arrow.setPosition(event.player.x, event.player.y + 1, event.player.z);
        let x_rad = event.player.pitch * JavaMath.PI / 180;
        let y_rad = event.player.yaw * JavaMath.PI / 180;
    
        let dirV = {
            x: -Math.sin(y_rad) * Math.cos(x_rad),
            y: -Math.sin(x_rad),
            z: Math.cos(y_rad) * Math.cos(x_rad)
        }
        arrow.addMotion(dirV.x * 8, dirV.y * 8, dirV.z * 8)
        arrow.mergeNbt({
            ActiveEffects: [
                {
                    Id: 24,
                    Amplifier: 1,
                    Duration: 999999999
                }
            ]
        })
        // Spawn the arrow in the world
        arrow.spawn();
        arrow.playSound(`alexscaves:forsaken_screech`, 1, 2)
        Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle cataclysm:soul_lava ${player.x} ${player.y} ${player.z} 0.5 0.5 0.5 4 40`)
        
})

EntityEvents.spawned('kubejs:entity.echoing_void', event => {
    event.server.scheduleInTicks(10, () => {
        let fireball = event.level.createEntity('minecraft:fireball');
        fireball.tags.add('echoing_void')
        fireball.setPosition(event.entity.x, event.entity.y, event.entity.z);
        event.entity.kill()
        fireball.addMotion(0, -5, 0);
        fireball.mergeNbt({ExplosionPower: 4, Fire: 0})
        fireball.spawn();
        Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle bosses_of_mass_destruction:soul_flame ${fireball.x} ${fireball.y+1} ${fireball.z} 1 1 1 4 500`)
        
    })
})