/**
 * Dragons Wisdom:
 *  - Right click to gain levitation and angel wings for 30 seconds
 *  - While flying, hold shift to shoot a fireball in the direction you are looking
 *  - While the effect is active,right click to gain a huge boost in levitation
 * 
 */



ItemEvents.rightClicked('kubejs:dragons_wisdom', event => {
    let player = event.player
    if (!event.player.tags.contains('dragons_wisdom')) {
        event.player.tags.add('dragons_wisdom')
        player.potionEffects.add('minecraft:levitation', 30, 60)
        event.player.potionEffects.add('irons_spellbooks:angel_wings', 600)
        Utils.server.scheduleInTicks(600, () => {
            event.player.tags.remove('dragons_wisdom')
        })
    } else {
        player.potionEffects.add('minecraft:levitation', 5, 60)
    }
    
})


let dragons_wisdom_counter =new WeakMap()
PlayerEvents.tick(event => {
    if (!event.player.tags.contains('dragons_wisdom')) return
    if (!event.player.isFallFlying()) return
    if (!event.player.shiftKeyDown) return
    if (dragons_wisdom_counter[event.player.username] == undefined) {
        dragons_wisdom_counter[event.player.username] = 8
    } else {
        dragons_wisdom_counter[event.player.username] -= 1
    }
    if (dragons_wisdom_counter[event.player.username] > 0) return
    let player = event.player
    dragons_wisdom_counter[event.player.username] = 8
    let fireball = event.level.createEntity('minecraft:fireball');


    let x_rad = event.player.pitch * JavaMath.PI / 180;
    let y_rad = event.player.yaw * JavaMath.PI / 180;
    let dirV = {
        x: -Math.sin(y_rad) * Math.cos(x_rad),
        y: -Math.sin(x_rad),
        z: Math.cos(y_rad) * Math.cos(x_rad)}

    fireball.addMotion(dirV.x * 8, dirV.y * 8, dirV.z * 8)

    let fireballPos = {
        x: player.x - Math.sin(y_rad),
        y: player.y,
        z: player.z + Math.cos(y_rad)};

    fireball.setPosition(fireballPos.x, fireballPos.y, fireballPos.z);
    fireball.mergeNbt({
        ExplosionPower: 2
    })
    
    fireball.spawn()
    fireball.playSound('cataclysm:flamethrower')
})

PlayerEvents.respawned(event => {
    event.player.tags.remove('dragons_wisdom')
})