//_______________________________________________________________________________________________________________________
// Essence of Light to give surrounding entities the Guided effect 10 seconds and cast Guiding Bolt if sneaking

/**
 * 
 * 
 * ItemEvents.pickedUp(`kubejs:essence_of_light`, event => {
    if (event.player.persistentData.get('eol_init')) return
    event.player.persistentData.putBoolean('eol_init', true)
    event.player.persistentData.putInt('eol_counter', 2)
})


ItemEvents.rightClicked('kubejs:essence_of_light', event => {
    let player = event.player
    let player_username = player.username
   // if (!player.persistentData.get('kubejs_class:guardian')) return
    player.tags.add('essence_of_light')
    player.persistentData.eol_counter = 2
    player.cooldowns.addCooldown(event.item, 1200)
    Utils.server.scheduleInTicks(200, () => {
        player.tags.remove('essence_of_light')
    })
})


PlayerEvents.tick(event => {
    if (!event.player.tags.contains('essence_of_light')) return
    let player = event.player
    let player_username = player.username
    if (!player.persistentData.get('kubejs_class:guardian')) return
    if (player.shiftKeyDown) {
        if (player.persistentData.eol_counter > 0) {
            player.persistentData.eol_counter -= 1
        } else {
            let dim = event.level.dimension
    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${player_username} guiding_bolt`)
            player.persistentData.eol_counter = 2
        }
    }
    let box = AABB.of(player.x+10, player.y+10, player.z+10, player.x-10, player.y-10, player.z-10)
    let dim = player.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    entitiesWithin.forEach(ent => {
        if (ent != player) {
            if (ent.tags.contains('tamed_beast')) return
            ent.potionEffects.add('irons_spellbooks:guided', 30)
        }
    })

})

//_______________________________________________________________________________________________________________________
// Cinders


ItemEvents.rightClicked('kubejs:essence_of_cinders', event => {
    let player = event.player
    let box = AABB.of(player.x+20, player.y+3, player.z+20, player.x-20, player.y-3, player.z-20)
    let dim = event.level
    let ent_counter = 0
    let entitiesWithin = dim.getEntitiesWithin(box)
    entitiesWithin.forEach(ent => {
        if (!ent.pickable) return
        if (ent.tags.contains('tamed_beast')) return
        if (ent == player) return
        ent_counter++
        event.player.cooldowns.addCooldown(event.item, 300*ent_counter)
        event.server.scheduleInTicks(5*ent_counter, () => {
            let strike = event.level.createEntity('mowziesmobs:sunstrike')
            strike.setPosition(ent.x, ent.y, ent.z)
            strike.spawn()
            Utils.server.scheduleInTicks(33, () => {
                let fireball = event.level.createEntity('irons_spellbooks:fireball')
                let explosion = event.level.createEntity('minecraft:fireball')
                explosion.setPosition(ent.x, ent.y+4, ent.z)
                fireball.setPosition(ent.x, ent.y+3, ent.z)
                fireball.mergeNbt({
                    ExplosionRadius:10,
                    Damage:10
                })
                explosion.mergeNbt({
                    ExplosionPower:1
                })
                explosion.spawn()
                explosion.setMotion(0, -1, 0)
                fireball.spawn()
                fireball.setMotion(0, -2, 0)
            })
            Utils.server.scheduleInTicks(45, () => {
                strike.kill()
            })
            Utils.server.scheduleInTicks(1, e => {
                if (strike.alive) {
                    e.repeating = true
                    strike.teleportTo(ent.x, ent.y, ent.z)
                    
                }
            })
        })

    })

})

//_______________________________________________________________________________________________________________________
// Essence of Storms

ItemEvents.pickedUp(`kubejs:essence_of_storms`, event => {
    event.player.persistentData.putInt('essence_of_storms', 0)
})
    
ItemEvents.rightClicked('kubejs:essence_of_storms', event => {
    let player = event.player
    if (player.magicData.mana < 25) return
    if (player.persistentData.essence_of_storms == 1) {
        player.persistentData.essence_of_storms = 0
        return
    } else if (player.persistentData.essence_of_storms == 0) {
        player.persistentData.essence_of_storms = 1
    }
    let x_rad = player.pitch * JavaMath.PI / 180;
    let y_rad = player.yaw * JavaMath.PI / 180;
    let diV = {
        x: -Math.sin(y_rad) * Math.cos(x_rad),
        y: -Math.sin(x_rad),
        z: Math.cos(y_rad) * Math.cos(x_rad)
    }
    // get the crosshair location
    let cross_location = {
        x: player.x + diV.x * 8,
        y: player.y+1.5 + diV.y * 8,
        z: player.z + diV.z * 8
    }
    let box = AABB.of(player.x+10, player.y+10, player.z+10, player.x-10, player.y-10, player.z-10)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    entitiesWithin.forEach(ent => {
        if (ent != player) {
            if (ent.alive) {
                ent.teleportTo(cross_location.x, cross_location.y, cross_location.z)
            }
        }
    })
    let dimension = event.level.dimension
    Utils.server.runCommandSilent(`/execute in ${dimension} run cast ${player.username} ascension`)
    Utils.server.scheduleInTicks(20, () => {
        player.potionEffects.add('minecraft:levitation', 60, 255)
    })
    Utils.server.scheduleInTicks(2, e => {
        if (player.persistentData.essence_of_storms == 0 || player.magicData.mana < 10) {
            player.persistentData.essence_of_storms = 0
            e.repeating = false
            return
        } else if (player.persistentData.essence_of_storms == 1) {
            e.repeating = true
        }
            let x_rad = player.pitch * JavaMath.PI / 180;
            let y_rad = player.yaw * JavaMath.PI / 180;
            let dirV = {
                x: -Math.sin(y_rad) * Math.cos(x_rad),
                y: -Math.sin(x_rad),
                z: Math.cos(y_rad) * Math.cos(x_rad)
            }
            // get the crosshair location
            let crosshair_location = {
                x: player.x + dirV.x * 8,
                y: player.y+1.5 + dirV.y * 8,
                z: player.z + dirV.z * 8
            }
            let mod = 0.2
            let box = AABB.of(player.x+10, player.y+10, player.z+10, player.x-10, player.y-10, player.z-10)
            let dim = event.level
            let entitiesWithin = dim.getEntitiesWithin(box)
            player.magicData.setMana(player.magicData.mana - 1)
            entitiesWithin.forEach(ent => {
                if (ent != player) { 
                    if (ent != undefined) {
                    // pull entities towards the crosshair location
                    ent.tags.add('essence_of_storms_target')
                    ent.addMotion((crosshair_location.x - ent.x)*mod, (crosshair_location.y - ent.y)*mod, (crosshair_location.z - ent.z)*mod)
                    
                    }
                }
            })
        })
})

ItemEvents.firstLeftClicked('kubejs:essence_of_storms', event => {
    if (event.player.persistentData.essence_of_storms == 0) return
    if (event.player.magicData.mana < 3) return
    let box = AABB.of(event.player.x+10, event.player.y+10, event.player.z+10, event.player.x-10, event.player.y-10, event.player.z-10)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box).filter(entity => entity.tags.contains('essence_of_storms_target'))
    let dimension = event.level.dimension
    Utils.server.runCommandSilent(`/execute in ${dimension} run cast ${event.player.username} chain_lightning 2`)
    event.player.magicData.setMana(event.player.magicData.mana - 20)
})

 * 
 * 
 * 
 * 
 * 
 */


