//_______________________________________________________________________________________________________________________
// Essence of Life

/**
 * 
 * PlayerEvents.loggedIn(event => {
    // Give the player the blood oath persistent data
    if (event.player.persistentData.get('blood_oath')) return
    event.player.persistentData.putInt('blood_oath', 0)
})


ItemEvents.rightClicked('kubejs:essence_of_life', event => {
    if (event.player.persistentData.blood_oath == 1) return
    event.item.count -= 1
    // 5 minute cooldown
    event.player.cooldowns.addCooldown(event.item, 6000)
    event.player.persistentData.blood_oath += 1
})


EntityEvents.hurt(event => {
    if (!event.entity.player) return
    let player = event.entity
    let x = player.x
    let y = player.y
    let z = player.z
    let player_username = player.username

    if (player.persistentData.blood_oath != 1) return
    if (event.damage < player.health) return

    ///Utils.server.runCommandSilent(`/playsound blocky_siege:soul_screams master ${player_username} ${x} ${y} ${z} 10`)
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle alexsmobs:skulk_boom ${x} ${y+1} ${z} 0 0 0 0.1 1`)
    
    let box = AABB.of(x+20, y+20, z+20, x-20, y-20, z-20)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    // Play the sound
    player.runCommandSilent(`/playsound minecraft:entity.enderman.teleport player ${player_username} ${x} ${y} ${z} 1`)
    
    entitiesWithin.forEach(ent => {
        if (ent.tags.contains('tamed_beast')) return
        if (!ent.player) {
            ent.mergeNbt({ActiveEffects:[{Id:25,Duration:3,Amplifier:60}]})

            event.server.scheduleInTicks(6, () => {
                     player.runCommandSilent(`/playsound blocky_siege:mortar_shell_impact player ${player_username} ${x} ${y} ${z} 0.2`)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
                     player.push(ent)
            })
        }
    })
    player.persistentData.putInt('blood_oath', 0)
    player.health = player.maxHealth
})
 * 
 * 
 */




//_______________________________________________________________________________________________________________________

// Twisted Rot
// Summons 4 tamed rats with the Beast Mount upgrade
/**
 * 
 * ItemEvents.rightClicked('kubejs:twisted_rot', event => {
    if (event.player.cooldowns.isOnCooldown(event.item)) return
    let player = event.player
    let rat1 = event.level.createEntity('rats:tamed_rat')
    rat1.mergeNbt({
        Owner: player.username,
        Command: 2,
        Items: [{
            Slot: 3, 
            Count: 1,
            id: 'rats:rat_upgrade_beast_mount'
        }]
    })
    rat1.x = player.x
    rat1.y = player.y
    rat1.z = player.z
    rat1.maxHealth = 100
    rat1.potionEffects.add('minecraft:strength', 999999, 2)
    rat1.spawn()
    rat1.tags.add('tamed_beast')
    rat1.tags.add('Owner:' + player.username)

    let rat2 = event.level.createEntity('rats:tamed_rat')
    rat2.mergeNbt({
        Owner: player.username,
        Command: 2,
        Items: [{
            Slot: 3, 
            Count: 1,
            id: 'rats:rat_upgrade_beast_mount'
        }]
    })
    rat2.x = player.x
    rat2.y = player.y
    rat2.z = player.z
    rat2.maxHealth = 100
    rat2.potionEffects.add('minecraft:strength', 999999, 2)
    rat2.spawn()
    rat2.tags.add('tamed_beast')
    rat2.tags.add('Owner:' + player.username)

    let rat3 = event.level.createEntity('rats:tamed_rat')
    rat3.mergeNbt({
        Owner: player.username,
        Command: 2,
        Items: [{
            Slot: 3, 
            Count: 1,
            id: 'rats:rat_upgrade_beast_mount'
        }]
    })
    rat3.x = player.x
    rat3.y = player.y
    rat3.z = player.z
    rat3.maxHealth = 100
    rat3.potionEffects.add('minecraft:strength', 999999, 2)
    rat3.spawn()
    rat3.tags.add('tamed_beast')
    rat3.tags.add('Owner:' + player.username)


    let rat4 = event.level.createEntity('rats:tamed_rat')
    rat4.mergeNbt({
        Owner: player.username,
        Command: 2,
        Items: [{
            Slot: 3, 
            Count: 1,
            id: 'rats:rat_upgrade_beast_mount'
        }]
    })
    rat4.x = player.x
    rat4.y = player.y
    rat4.z = player.z
    rat4.maxHealth = 100
    rat4.potionEffects.add('minecraft:strength', 999999, 2)
    rat4.spawn()
    player.cooldowns.addCooldown(event.item, 6000)
    rat4.tags.add('tamed_beast')
    rat4.tags.add('Owner:' + player.username)
})

 * 
 */

//_______________________________________________________________________________________________________________________________________________________________________________________________
// Heart of the Guardian
// Summon tigers that attack nearby enemies

ItemEvents.rightClicked('kubejs:heart_of_the_guardian', event => {
    if (event.player.cooldowns.isOnCooldown(event.item)) return
    let player = event.player
    player.tags.add('heart_of_the_guardian')
    Utils.server.scheduleInTicks(3600, () => {
        player.tags.remove('heart_of_the_guardian')
    })
    player.cooldowns.addCooldown(event.item, 7200)
    player.potionEffects.add('alexsmobs:tigers_blessing', 3600, 0)
    let tiger_1 = event.level.createEntity('alexsmobs:tiger')
    tiger_1.setPosition(player.x, player.y, player.z)
    tiger_1.spawn()
    let tiger_2 = event.level.createEntity('alexsmobs:tiger')
    tiger_2.setPosition(player.x, player.y, player.z)
    tiger_2.spawn()
    let tiger_3 = event.level.createEntity('alexsmobs:tiger')
    tiger_3.setPosition(player.x, player.y, player.z)
    tiger_3.spawn()
    let tiger_4 = event.level.createEntity('alexsmobs:tiger')
    tiger_4.setPosition(player.x, player.y, player.z)
    tiger_4.spawn()
    let tiger_5 = event.level.createEntity('alexsmobs:tiger')
    tiger_5.setPosition(player.x, player.y, player.z)
    tiger_5.spawn()
    let tiger_6 = event.level.createEntity('alexsmobs:tiger')
    tiger_6.setPosition(player.x, player.y, player.z)
    tiger_6.spawn()
    /**
     *     let tiger_7 = event.level.createEntity('alexsmobs:tiger')
    tiger_7.setPosition(player.x, player.y, player.z)
    tiger_7.spawn()
    let tiger_8 = event.level.createEntity('alexsmobs:tiger')
    tiger_8.setPosition(player.x, player.y, player.z)
    tiger_8.spawn()
    let tiger_9 = event.level.createEntity('alexsmobs:tiger')
    tiger_9.setPosition(player.x, player.y, player.z)
    tiger_9.spawn()
    let tiger_10 = event.level.createEntity('alexsmobs:tiger')
    tiger_10.setPosition(player.x, player.y, player.z)
    tiger_10.spawn()
     * 
     */

    Utils.server.scheduleInTicks(2400, () => {
        player.tags.remove('heart_of_the_guardian')
        player.potionEffects.clear()
        tiger_1.setPos(tiger_1.x, tiger_1.y+255, tiger_1.z)
        Utils.server.scheduleInTicks(5, () => {
            tiger_1.kill()
        })
        tiger_2.setPos(tiger_2.x, tiger_2.y+255, tiger_2.z)
        Utils.server.scheduleInTicks(5, () => {
            tiger_2.kill()
        })
        tiger_3.setPos(tiger_3.x, tiger_3.y+255, tiger_3.z)
        Utils.server.scheduleInTicks(5, () => {
            tiger_3.kill()
        })
        tiger_4.setPos(tiger_4.x, tiger_4.y+255, tiger_4.z)
        Utils.server.scheduleInTicks(5, () => {
            tiger_4.kill()
        })
        tiger_5.setPos(tiger_5.x, tiger_5.y+255, tiger_5.z)
        Utils.server.scheduleInTicks(5, () => {
            tiger_5.kill()
        })
        tiger_6.setPos(tiger_6.x, tiger_6.y+255, tiger_6.z)
        Utils.server.scheduleInTicks(5, () => {
            tiger_6.kill()
        })
        /**
         *         tiger_7.setPos(tiger_7.x, tiger_7.y+255, tiger_7.z)
        Utils.server.scheduleInTicks(5, () => {
            tiger_7.kill()
        })
        tiger_8.setPos(tiger_8.x, tiger_8.y+255, tiger_8.z)
        Utils.server.scheduleInTicks(5, () => {
            tiger_8.kill()
        })
        tiger_9.setPos(tiger_9.x, tiger_9.y+255, tiger_9.z)
        Utils.server.scheduleInTicks(5, () => {
            tiger_9.kill()
        })
        tiger_10.setPos(tiger_10.x, tiger_10.y+255, tiger_10.z)
        Utils.server.scheduleInTicks(5, () => {
            tiger_10.kill()
        })
         * 
         */

    })
})

EntityEvents.death('player', event => {
    if (event.entity.tags.contains('heart_of_the_guardian')) {
        let box = AABB.of(event.entity.x+40, event.entity.y+40, event.entity.z+40, event.entity.x-40, event.entity.y-40, event.entity.z-40)
        let dim = event.level
        let entitiesWithin = dim.getEntitiesWithin(box).filter(ent => ent.type === 'alexsmobs:tiger')
        entitiesWithin.forEach(ent => {
            ent.setPos(ent.x, ent.y+255, ent.z)
            Utils.server.scheduleInTicks(5, () => {
                ent.kill()
            })
        })
    }
})

EntityEvents.death('alexsmobs:tiger', event => {
    let box = AABB.of(event.entity.x+40, event.entity.y+40, event.entity.z+40, event.entity.x-40, event.entity.y-40, event.entity.z-40)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    entitiesWithin.forEach(ent => {
        if (ent.player) {
            let player = ent.player
            if (player.tags.contains('heart_of_the_guardian')) {
                let tiger_1 = event.level.createEntity('alexsmobs:tiger')
                tiger_1.setPosition(player.x, player.y, player.z)
                tiger_1.spawn()
            }
        }
    })
})


EntityEvents.hurt('alexsmobs:tiger', event => {
    if (!event.source.player) return
    if (!event.source.player.tags.contains('heart_of_the_guardian')) return
    event.cancel()
})

EntityEvents.hurt('player', event => {
    if (event.source == null) return
    if (event.source.actual == null) return
    if (event.source.actual == undefined) return
    if (event.player.tags.contains('heart_of_the_guardian')) {
        let box = AABB.of(event.player.x+20, event.player.y+20, event.player.z+20, event.player.x-20, event.player.y-20, event.player.z-20)
        let dim = event.level
        let entitiesWithin = dim.getEntitiesWithin(box).filter(ent => ent.type === 'alexsmobs:tiger')
        entitiesWithin.forEach(ent => {
            ent.setTarget(event.source.actual)
        })
    }
})

EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (!event.source.player.tags.contains('heart_of_the_guardian')) return
    if (event.source.actual == null) return
    if (event.source.actual == undefined) return
    let box = AABB.of(event.source.actual.x+20, event.source.actual.y+20, event.source.actual.z+20, event.source.actual.x-20, event.source.actual.y-20, event.source.actual.z-20)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box).filter(ent => ent.type === 'alexsmobs:tiger')
    entitiesWithin.forEach(ent => {
        ent.setTarget(event.entity)
    })
})




PlayerEvents.tick(event => {
    if (!event.player.tags.contains('heart_of_the_guardian')) return
    if (event.player.potionEffects.isActive('alexsmobs:fear')) {
        Utils.server.runCommandSilent(`/effect clear ${event.player.username} alexsmobs:fear`)
    }
    if (!event.player.potionEffects.isActive('alexsmobs:tigers_blessing')) {
        event.player.potionEffects.add('alexsmobs:tigers_blessing', 1200, 0)
    }
    
})

EntityEvents.hurt(event => {
    if (event.source == null) return
    if (event.source.directEntity == null) return
    if (event.source.directEntity.type != 'alexsmobs:tiger') return
    let box = AABB.of(event.entity.x+40, event.entity.y+40, event.entity.z+40, event.entity.x-40, event.entity.y-40, event.entity.z-40)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    entitiesWithin.forEach(ent => {
        if (ent.player) {
            let player = ent.player
            if (player.tags.contains('heart_of_the_guardian')) {
                player.health += player.maxHealth*0.20
            }
        }
    })
})
//_______________________________________________________________________________________________________________________________________________________________________________________________

/**
 * EntityEvents.hurt('player', event => {
    if (event.source == null) return
    let attacker = event.source.actual
    let player = event.entity
    createBlunderer(attacker, player)
    createBlunderer(attacker, player)
    createBlunderer(attacker, player)
})

function createBlunderer(attacker, player) {
    let blund = player.level.createEntity(`scguns:blunderer`)
    blund.setPosition(player.x, player.y, player.z)
    blund.spawn()
    blund.setTarget(attacker)
    Utils.server.scheduleInTicks(10, e => {
        if (attacker.alive) {
            
            blund.setTarget(attacker)
            e.repeating = true
        } else {
            blund.kill()
            e.repeating = false
        }
    }) 
}
 * 
 */
