//_______________________________________________________________________________________________________________________
// Sorrow: the more enemies you have around you, the more damage you deal

/**
 * 
 * 
 * ItemEvents.rightClicked('kubejs:essence_of_sorrow', event => {
    let box = AABB.of(event.player.x+20, event.player.y+20, event.player.z+20, event.player.x-20, event.player.y-20, event.player.z-20)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box).filter(entity => entity.isMonster())
    let len = entitiesWithin.length
    event.player.potionEffects.add('runiclib:lesser_strength', 1200, len)
    event.player.tags.add('sorrow')
    event.player.cooldowns.addCooldown(event.item, 4800) // 4800 ticks = 3 minutes
    Utils.server.scheduleInTicks(1200, () => {
        event.player.tags.remove('sorrow')
    })
})

PlayerEvents.respawned(event => {
    event.player.tags.remove('sorrow')
})


// Pull enemies towards you slightly when you hit them

EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.tags.contains('sorrow')) return
    let entity = event.entity
    let dir = {
        x: player.getX() - entity.getX(),
        z: player.getZ() - entity.getZ()
      };
    let dirLength = Math.sqrt(dir.x * dir.x + dir.z * dir.z);
    if (dirLength > 0) {
        entity.addMotion((dir.x / dirLength) * 1.3, 2, (dir.z / dirLength) * 1.3);

      }  
})





//_______________________________________________________________________________________________________________________
// Essence of Giants

ItemEvents.rightClicked('kubejs:essence_of_giants', event => {
    let player = event.player
    let player_username = player.username
    let player_x = player.x
    let player_y = player.y
    let player_z = player.z
    Utils.server.runCommandSilent(`/scale delay set pehkui:height 20 ${player_username}`)
    Utils.server.runCommandSilent(`/scale delay set pehkui:width 20 ${player_username}`)
    Utils.server.runCommandSilent(`/scale delay set pehkui:base 3 ${player_username}`)
    Utils.server.runCommandSilent(`/scale set pehkui:base 2 ${player_username}`)
    player.potionEffects.add('minecraft:strength', 1200, 1)
    player.potionEffects.add('minecraft:haste', 1200, 1)
    Utils.server.runCommandSilent(`/playsound irons_spellbooks:cast.generic.nature master ${player_username} ${player_x} ${player_y} ${player_z} 100`)
    player.cooldowns.addCooldown(event.item, 4800)
    Utils.server.scheduleInTicks(1200, () => {
        Utils.server.runCommandSilent(`/scale reset ${player_username}`)
    })
})


//_______________________________________________________________________________________________________________________
//Essence of the void
/**
 * rework:
 * - Spawn a black hole
 * - Pull all the enemies into it
 * - Drop a lit tnt on the black hole
 * - Kill the black hole
 * 


// Summon a black hole when shooting an entity with an arrow while insane. 
ItemEvents.rightClicked('kubejs:essence_of_the_void', event => {
    //if (!event.player.persistentData.get('kubejs_class:mystic')) return
    //if (!event.player.tags.contains('insane')) return
    let player = event.player
    player.tags.add('mystic_blackhole')
    player.magicData.setMana(player.magicData.getMana()-75)
    player.addItemCooldown(event.item, 12000)

})

EntityEvents.hurt(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.persistentData.get('kubejs_class:mystic')) return
    if (!player.tags.contains('mystic_blackhole')) return
    //if (!player.tags.contains('insane')) return
    if (!event.source.immediate.type.includes('thrown')) return
    let entity = event.entity
    let x = entity.x
    let y = entity.y
    let z = entity.z
    let blackhole = event.level.createEntity('irons_spellbooks:black_hole')
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle apotheosis:enchant_sculk ${x} ${y+3} ${z} 0 0 0 20 5000`)
    Utils.server.scheduleInTicks(40, () => {
        blackhole.x = x
        blackhole.y = y-4
        blackhole.z = z
        blackhole.spawn()
        player.tags.remove('mystic_blackhole')
        event.server.scheduleInTicks(200, () => {
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            event.level.spawnLightning(x, y, z, false)
            Utils.server.runCommandSilent(`/summon minecraft:tnt ${x} ${y} ${z} {Fuse:0,Fire:1}`)
            Utils.server.runCommandSilent(`/summon minecraft:tnt ${x} ${y} ${z} {Fuse:0,Fire:1}`)
            Utils.server.runCommandSilent(`/summon minecraft:tnt ${x} ${y} ${z} {Fuse:0,Fire:1}`)
        })
        event.server.scheduleInTicks(300, () => {
            blackhole.kill()
        })
        
    })
})
 * 
 * 
 */

//_______________________________________________________________________________________________________________________
// New Widows Blood. 
 // For 60 seconds, all mobs within 20 blocks of the player will be attacked every 1 second. The player will heal for 3 times the amount of damage they took.

 ItemEvents.rightClicked('kubejs:widows_blood', event => {
    let box = AABB.of(event.player.x+20, event.player.y+10, event.player.z+20, event.player.x-20, event.player.y-10, event.player.z-20)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    let player = event.player
    entitiesWithin.forEach(ent => {
        if (ent.isMonster()) {
            Utils.server.runCommandSilent(`/photon fx photon:widows_blood entity ${ent.uuid}`)
            event.server.scheduleRepeatingInTicks(10, () => {
                if (ent.maxHealth < 20*player.persistentData.order_level) {
                    if (ent.alive) {
                        Utils.server.runCommandSilent(`/damage ${ent.uuid} 3 minecraft:player by ${player.username}`)
                        player.heal(3)
                    } 
                }
            })
        }
    })
})




/**
 * 
 * _______________________________________________________________________________________________________________________________________________________
 * Effigy of the Undying:
 *  - Make it a curios item
 *  - When the player almost dies they are given a 30 second window to kill the enemy that almost killed them
 *  - If the player fails to kill the enemy they die
 *  - If they succeed they are given a 3 life shield
 * 
 */
/**
 * 
 * PlayerEvents.loggedIn(event => {
    if (event.player.persistentData.get('eotu_res')) return
    event.player.persistentData.putInt('eotu_res', 0)
    event.player.persistentData.putString('eotu_enemy', '')
})



EntityEvents.hurt(event => {
    if (!event.entity.player) return
    let player_u = event.entity.uuid
    let player = event.level.getPlayerByUUID(player_u)
    if (player == null) return
    if (event.damage < player.health) return
    if (event.source.actual == null) return
    if (event.source.actual == undefined) return
    if (player.cooldowns.isOnCooldown('kubejs:effigy_of_the_undying')) return
    let curios = player.nbt
    let undying_effigy = curios.toString().contains("kubejs:effigy_of_the_undying")
    if (!undying_effigy) return
    if (player.persistentData.eotu_res > 0) return
    player.cooldowns.addCooldown('kubejs:effigy_of_the_undying', 3840)
    let player_username = player.username
    // detect if the damage done is more than the player's health
    if (event.damage < player.health) return
    if (player.tags.contains('eotu')) return
    player.tags.add('eotu_save')
    player.health = player.maxHealth
    
    let uuid = event.source.actual.uuid.toString()
    player.persistentData.eotu_enemy = uuid
    event.source.actual.potionEffects.add('minecraft:glowing', 600, 0)
    // turn the player insane
    Utils.server.runCommandSilent(`/sanity set ${player_username} 0`)
    player.tags.add('insane')
    player.tags.add('eotu')
    let player_x = player.x
    let player_y = player.y
    let player_z = player.z
    let box = AABB.of(player_x+20, player_y+10, player_z+20, player_x-20, player_y-10, player_z-20)
    let dim = event.level
    let entitiesWithin = dim.getEntitiesWithin(box)
    entitiesWithin.forEach(ent => {
        if (ent != player) {
            ent.potionEffects.add('alexscaves:stunned', 60, 0)
            ent.potionEffects.add('minecraft:slowness', 60, 0)
        }
    })
    // Give the player 30 seconds to kill the enemy
    Utils.server.scheduleInTicks(600, () => {
        if (player.tags.contains('eotu')) {
            player.tags.remove('insane')
            player.tags.remove('eotu')
            Utils.server.runCommandSilent(`/sanity set ${player_username} 100`)
            player.kill()
            player.persistentData.eotu_enemy = ''

        }
    })
})

EntityEvents.death(event => {
    if (!event.entity.player) return
    if (!event.entity.tags.contains('eotu_save')) return
    event.entity.tags.remove('eotu_save')
    event.entity.health = event.entity.maxHealth
    event.cancel()
})

EntityEvents.death(event => {
    if (!event.source.player) return
    let player = event.source.player
    if (!player.tags.contains('eotu')) return
    let uuid = event.entity.uuid.toString()
    if (player.persistentData.eotu_enemy != uuid) return
    player.tags.remove('insane')
    player.tags.remove('eotu')
    Utils.server.runCommandSilent(`/sanity set ${player.username} 100`)
    player.persistentData.eotu_res = 3
    player.paint({
        eotu_1: {
            type: 'rectangle',
            x: -12,
            y: 16, 
            w: 10, 
            h: 10, 
            draw: 'ingame',
            visible: 'true',
            alignX: 'center', 
            alignY: 'center',
            texture: `kubejs:textures/item/legendary_items/effigy_of_the_undying.png`
        },
        eotu_2: {
            type: 'rectangle',
            x: 0,
            y: 16, 
            w: 10, 
            h: 10, 
            draw: 'ingame',
            visible: 'true',
            alignX: 'center', 
            alignY: 'center',
            texture: `kubejs:textures/item/legendary_items/effigy_of_the_undying.png`
        },
        eotu_3: {
            type: 'rectangle',
            x: 12,
            y: 16, 
            w: 10, 
            h: 10, 
            draw: 'ingame',
            visible: 'true',
            alignX: 'center', 
            alignY: 'center',
            texture: `kubejs:textures/item/legendary_items/effigy_of_the_undying.png`
        }
    })
    Utils.server.scheduleInTicks(100, () => {
        player.paint({
            eotu_1: {
                visible: 'false',
            },
            eotu_2: {
                visible: 'false',
            },
            eotu_3: {
                visible: 'false',
            }
        })
    })
})


EntityEvents.hurt(event => {
    if (!event.entity.player) return
    let player = event.entity
    if (player.persistentData.eotu_res < 1) return
    if (event.damage < player.health) return
    player.health = player.maxHealth
    player.persistentData.eotu_res -= 1
    if (player.persistentData.eotu_res == 2) {
        player.paint({
            eotu_1: {
                visible: 'true',
            },
            eotu_2: {
                visible: 'true',
            },
        })
        Utils.server.scheduleInTicks(100, () => {
            player.paint({
                eotu_1: {
                    visible: 'false',
                },
                eotu_2: {
                    visible: 'false',
                },
            })
        })
    } else if (player.persistentData.eotu_res == 1) {
        player.paint({
            eotu_2: {
                visible: 'true',
            },
        })
        Utils.server.scheduleInTicks(100, () => {
            player.paint({
                eotu_2: {
                    visible: 'false',
                },
            })
        })
    }
})

PlayerEvents.respawned(event => {
    event.player.tags.remove('eotu')
    event.player.tags.remove('insane')
    
})
 */

