

let wayfinders = {
    'primordial_wayfinder': 'primordial_caves',
    'abyssal_wayfinder': 'abyssal_depths',
    'toxic_wayfinder': 'toxic_caves',
    'forlorn_wayfinder': 'forlorn_hollows',
    'magnetic_wayfinder': 'magnetic_caves',
}


ItemEvents.rightClicked('alexscaves:cave_map', event => {
    let offhand = event.player.offHandItem.toString()
    Object.keys(wayfinders).forEach(wayfinder => {
        if (!event.item.nbt.toString().includes(wayfinders[wayfinder])) return
        if (offhand.includes(wayfinder)) {
            event.player.tell('Searching...')
        } else {
            // Remove the underscore and capitalize the first letter of each word
            let wayfinder_name = wayfinder.replace(/_/g, ' ').replace(/\b\w/g, l => l.toUpperCase())
            let cave = wayfinders[wayfinder].replace(/_/g, ' ').replace(/\b\w/g, l => l.toUpperCase())
            event.player.tell(`You need a ${wayfinder_name} to find The ${cave}`)
            event.cancel()
        }
    })
})



ItemEvents.rightClicked('kubejs:primordial_wayfinder', event => {
    if (!event.player.isCreative()) return
    if (!event.player.shiftKeyDown) return
    event.player.give(Item.of('alexscaves:cave_map', '{BiomeTargetResourceKey:"alexscaves:primordial_caves"}'))
})

ItemEvents.rightClicked('kubejs:abyssal_wayfinder', event => {
    if (!event.player.isCreative()) return
    if (!event.player.shiftKeyDown) return
    event.player.give(Item.of('alexscaves:cave_map', '{BiomeTargetResourceKey:"alexscaves:abyssal_chasm"}'))
})

ItemEvents.rightClicked('kubejs:toxic_wayfinder', event => {
    if (!event.player.isCreative()) return
    if (!event.player.shiftKeyDown) return
    event.player.give(Item.of('alexscaves:cave_map', '{BiomeTargetResourceKey:"alexscaves:toxic_caves"}'))
})

ItemEvents.rightClicked('kubejs:forlorn_wayfinder', event => {
    if (!event.player.isCreative()) return
    if (!event.player.shiftKeyDown) return
    event.player.give(Item.of('alexscaves:cave_map', '{BiomeTargetResourceKey:"alexscaves:forlorn_hollows"}'))
})
ItemEvents.rightClicked('kubejs:magnetic_wayfinder', event => {
    if (!event.player.isCreative()) return
    if (!event.player.shiftKeyDown) return
    event.player.give(Item.of('alexscaves:cave_map', '{BiomeTargetResourceKey:"alexscaves:magnetic_caves"}'))
})