



ItemEvents.rightClicked('kubejs:home_waystone', event => {
  if (!event.player.shiftKeyDown) {
    let dim = event.level.dimension
    let x = parseInt(event.player.x)
    let y = parseInt(event.player.y)
    let z = parseInt(event.player.z)
    Utils.server.runCommandSilent(`/execute in ${dim} run cast ${event.player.username} recall`)
    Utils.server.runCommandSilent(`/ftbquests change_progress ${event.player.username} complete 597349C63FF8C3E3`)
    event.player.tags.add('recall_waystone')
    let player = event.player
    Utils.server.scheduleInTicks(120, () => {
        if (!event.player.tags.contains('recall_cast')) return
        player.tags.remove('recall_cast')
        player.cooldowns.addCooldown('kubejs:home_waystone', 1200)
        player.persistentData.putInt('recall_x', x)
        player.persistentData.putInt('recall_y', y)
        player.persistentData.putInt('recall_z', z)
        player.persistentData.putString('recall_dim', dim)
    })
  } else {
    let handler = Java.loadClass('snownee.skillslots.SkillSlotsHandler').of(event.player)
    handler.setItem(1, 'kubejs:home_waystone')
    handler.setItem(3, 'kubejs:journey_waystone')
    Utils.server.runCommandSilent(`/execute in ${event.player.level.dimension} run playsound sdmshoprework:buy_sound ambient ${event.player.username} ${event.player.x} ${event.player.y} ${event.player.z} 2 1.1`)
    event.item.count -=1
  }
  

})


PlayerEvents.spellOnCast(event => {
    if (!event.spellId.includes('recall')) return
    if (!event.player.tags.contains('recall_waystone')) return
    event.player.tags.add('recall_cast')
    event.player.tags.remove('recall_waystone')
})


ItemEvents.rightClicked('kubejs:journey_waystone', event => {
  if (!event.player.shiftKeyDown) {
    if (!event.player.persistentData.get('recall_x')) return
    if (!event.player.persistentData.get('recall_y')) return
    if (!event.player.persistentData.get('recall_z')) return
    let player = event.player
    let x = event.player.persistentData.getInt('recall_x')
    let y = event.player.persistentData.getInt('recall_y')
    let z = event.player.persistentData.getInt('recall_z')
    let dim = event.player.persistentData.getString('recall_dim')
    Utils.server.runCommandSilent(`/ftbquests change_progress ${event.player.username} complete 3B513FB67E60F20B`)
    Utils.server.runCommandSilent(`/execute in ${dim} run playsound bosses_of_mass_destruction:lich_teleport player ${player.username} ${x} ${y} ${z} 1 0.9`)
    Utils.server.runCommandSilent(`/execute in ${dim} run tp ${player.username} ${x} ${y} ${z}`)
    Utils.server.scheduleInTicks(2, () => {
      Utils.server.runCommandSilent(`/execute in ${dim} run playsound roe_sfx:spell_charge ambient ${player.username} ${x} ${y} ${z} 0.75 0.85`)
      Utils.server.runCommandSilent(`/execute in ${dim} run particle traveloptics:abyss_spike ${player.x} ${player.y} ${player.z} 0.5 1 0.5 0.1 100`)
    })
    event.player.persistentData.remove('recall_x')
    event.player.persistentData.remove('recall_y')
    event.player.persistentData.remove('recall_z')
    event.player.persistentData.remove('recall_dim')
    event.player.cooldowns.addCooldown('kubejs:journey_waystone', 1200)
  } else {
    let handler = Java.loadClass('snownee.skillslots.SkillSlotsHandler').of(event.player)
    handler.setItem(1, 'kubejs:home_waystone')
    handler.setItem(3, 'kubejs:journey_waystone')
    Utils.server.runCommandSilent(`/execute in ${event.player.level.dimension} run playsound sdmshoprework:buy_sound ambient ${event.player.username} ${event.player.x} ${event.player.y} ${event.player.z} 2 1.1`)
    event.item.count -= 1
  }


})









// ─────────────────────────────────────────────────────────────
// Player Waystone – select player (left‑click) and request TP (right‑click)
// Item: kubejs:player_waystone
// ─────────────────────────────────────────────────────────────

// In‑memory map: targetUUID -> { requesterUUID, ts }
if (!global.playerWaystoneRequests) global.playerWaystoneRequests = new Map()

function getOtherPlayersAlphabetical(server, excludeUUID) {
  // Returns a list of online players excluding the given UUID, sorted by username
  let list = server.players.filter(p => p.uuid !== excludeUUID)
  list.sort((a, b) => a.username.toLowerCase().localeCompare(b.username.toLowerCase()))
  return list
}

// Cycle selection with left‑click while holding the item
ItemEvents.firstLeftClicked('kubejs:player_waystone', event => {
  let player = event.player
  let server = player.server
  let others = getOtherPlayersAlphabetical(server, player.uuid)
  if (others.length === 0) {
    player.tell(Text.red('No other players online to select.'))
    return
  }

  // Advance index and store selection
  let idx = player.persistentData.get('player_waystone_index')
    ? player.persistentData.getInt('player_waystone_index')
    : -1
  idx = (idx + 1) % others.length
  let selected = others[idx]

  player.persistentData.putInt('player_waystone_index', idx)
  player.persistentData.putString('player_waystone_target_uuid', selected.uuid)
  player.persistentData.putString('player_waystone_target_name', selected.username)

  player.tell(Text.gray('Player Waystone target: ').append(Text.aqua(selected.username)))
})

// Send request with right‑click
ItemEvents.rightClicked('kubejs:player_waystone', event => {
  let player = event.player
  let server = player.server

  // Build candidates, exclude self
  let others = getOtherPlayersAlphabetical(server, player.uuid)
  if (others.length === 0) {
    player.tell(Text.red('No other players online to request.'))
    return
  }

  // Determine selected target
  let targetUUID = player.persistentData.getString('player_waystone_target_uuid') || ''
  let target = targetUUID ? player.level.getPlayerByUUID(targetUUID) : null
  if (!target) {
    // Default to first alphabetically if no stored selection or target offline
    let idx = 0
    let fallback = others[idx]
    target = fallback
    player.persistentData.putInt('player_waystone_index', idx)
    player.persistentData.putString('player_waystone_target_uuid', fallback.uuid)
    player.persistentData.putString('player_waystone_target_name', fallback.username)
  }

  if (!target) {
    player.tell(Text.red('Selected player is offline.'))
    return
  }
  if (target.uuid === player.uuid) {
    player.tell(Text.red('Select another player – cannot target yourself.'))
    return
  }


  // Prevent multiple pending requests to the same target
  //let searchTag = ent.tags.find(tag => tag.startsWith('Owner')).split(':')[1]
  let search = target.tags.find(tag => tag.startsWith('tp_req_username:'))
  let searchTag = ''
  if (search) {
    searchTag = search.split(":")[1]
  }
  if (searchTag) {
    player.tell(Text.red('That player already has a pending teleport request.'))
    return
  }
  player.tags.add(`tp_target_username:${target.username}`)
  target.tags.add(`tp_req_username:${player.username}`)

  // Spend the item now to prevent the drop‑then‑accept exploit
  if (!player.creative) {
    event.item.count -= 1
  }

  global.playerWaystoneRequests.set(target.uuid, {
    requesterUUID: player.uuid,
    ts: Date.now()
  })


  // Clickable message to target
  target.tell(
    Text.gold(`${player.username} wants to teleport to you. `)
      .append(
        Text.green('[ACCEPT]').bold(false).clickRunCommand(`/kjs custom_command accept_teleport_request`).hover('Teleport them to you')
      )
      .append(Text.white(' '))
      .append(
        Text.red('[DENY]').bold(false).clickRunCommand(`/kjs custom_command deny_teleport_request`).hover('Deny and refund the item')
      )
  )
  player.tell(Text.gray(`Sent a teleport request to ${target.username}.`))
  
})


let tpRequests = new WeakMap()

EntityEvents.death('player', event => {
  let tpreq = event.entity.tags.find(tag => tag.startsWith('tp_req_username:'))
  event.entity.tags.remove(tpreq)

  let tptarg = event.entity.tags.find(tag => tag.startsWith('tp_target_username:'))
  event.entity.tags.remove(tptarg)
})

ServerEvents.customCommand('accept_teleport_request', event => {
    let valid = true
    let requestertag = event.player.tags.find(name => name.startsWith("tp_req_username:"))
    let requester = null
    if (!requestertag) {
      valid = false
    } else {
      //tell(requestertag)
      requester = event.server.getPlayer(requestertag.split(':')[1])
      //tell(requester)
      if (!requester) valid = false
    }
  if (!valid) {
    event.player.tell(`§cInvalid TP request or no player found`)
  } else {
    Utils.server.runCommandSilent(`/execute as ${requester.username} run tp ${event.player.username} @s ${event.player.x} ${event.player.y} ${event.player.z}`)
    global.playerWaystoneRequests.delete(requester.uuid)
  }
  if (!requester) return 
  event.player.tags.remove('tp_req_username:'+requester.username)
  requester.tags.remove(`tp_target_username:${event.player.username}`)
})

ServerEvents.customCommand('deny_teleport_request', event => {
  let valid = true
  let requestertag = event.player.tags.find(name => name.startsWith("tp_req_username:"))
  let requester = null
  if (!requestertag) {
    valid = false
  } else {
    requester = event.server.getPlayer(requestertag.split(':')[1])
    if (!requester) valid = false
  }
    if (valid) {
      requester.tell(Text.red(`${event.player.username} denied your teleport request.`))
      requester.give('kubejs:player_waystone')
    } else {
      event.player.tell(`§cInvalid TP request or no player found`)
    }
  event.player.tags.remove('tp_req_username:'+requester.username)
  requester.tags.remove(`tp_target_username:${event.player.username}`)
  global.playerWaystoneRequests.delete(requester.uuid)
}) 


// Register /player_waystone accept|deny <requester>
ServerEvents.commandRegistry(ev => {
  let { commands: C, arguments: A } = ev
  let uuidArg = A.UUID.create(ev)

  ev.register(
    C.literal('player_waystone')
      .then(
        C.literal('accept')
          .then(
            C.argument('requester', uuidArg).executes(ctx => {
              let target = ctx.source.playerOrException
              let reqUUID = uuidArg.getUuid(ctx, 'requester').toString()
              let rec = global.playerWaystoneRequests.get(target.uuid)
              if (!rec || rec.requesterUUID !== reqUUID) {
                target.tell(Text.red('No matching teleport request found.'))
                return 0
              }
              let requester = target.level.getPlayerByUUID(reqUUID)
              if (!requester) {
                target.tell(Text.red('Requester went offline.'))
                global.playerWaystoneRequests.delete(target.uuid)
                return 0
              }

              let x = parseInt(target.x)
              let y = parseInt(target.y)
              let z = parseInt(target.z)
              let dim = target.level.dimension
              Utils.server.runCommandSilent(`/execute as ${requester.username} run tp ${target.username} @s ${x} ${y} ${z}`)

              requester.tell(Text.green(`Teleported to ${target.username}.`))
              target.tell(Text.green(`${requester.username} teleported to you.`))
              global.playerWaystoneRequests.delete(target.uuid)
              return 1
            })
          )
      )
      .then(
        C.literal('deny')
          .then(
            C.argument('requester', uuidArg).executes(ctx => {
              let target = ctx.source.playerOrException
              let reqUUID = uuidArg.getUuid(ctx, 'requester').toString()
              let rec = global.playerWaystoneRequests.get(target.uuid)
              if (!rec || rec.requesterUUID !== reqUUID) {
                target.tell(Text.red('No matching teleport request found.'))
                return 0
              }
              let requester = target.level.getPlayerByUUID(reqUUID)
              if (requester) {
                requester.tell(Text.red(`${target.username} denied your teleport request.`))
                requester.give('kubejs:player_waystone')
              }
              target.tell(Text.gray('Teleport request denied.'))
              global.playerWaystoneRequests.delete(target.uuid)
              return 1
            })
          )
      )
  )
})
