// Helper: play drink sound
function playDrinkSound(player) {
    let dim = player.level.dimension
    Utils.server.runCommandSilent(`/execute in ${dim} run playsound minecraft:entity.generic.drink ambient ${player.username} ${player.x} ${player.y} ${player.z} 1 0.9`)
}

// Helper: apply potion effect, cooldown, and Volatile Mix gamble
function handlePotionUse(event, effect, duration, amplifier, questId, tagKey) {
    let player = event.player
    let hasVolatile = skillTotemCheck(player, 'volatile_mix')   // true ⇢ gamble

    /* ───────────────────────────────────────────────
       Volatile Mix:
       50 % → double duration & amp
       50 % → no effect at all
       (Either way the cooldown and sound still apply)
    ─────────────────────────────────────────────── */
    let applyEffect = true
    let dur  = duration
    let amp  = amplifier

    if (hasVolatile) {
        if (Math.random() < 0.5) {           // lucky roll
            dur *= 2
            amp *= 2
            Utils.server.runCommandSilent(`/immersivemessages sendcustom ${player.username} {anchor:'CENTER_CENTER', size: 0.80,y:15} 2 Potion effects §adoubled§7`)
        } else {                             // unlucky roll
            applyEffect = false
            Utils.server.runCommandSilent(`/immersivemessages sendcustom ${player.username} {anchor:'CENTER_CENTER', size: 0.80,y:15} 2 Potion effects §ccanceled§7`)
        }
    }

    // Player only
    if (applyEffect) {
        player.potionEffects.add(effect, dur, amp)
    }
    let skill_totems = Object.keys(useItem_applyEffect)
    skill_totems.forEach(totem => {
        let totemCheck = skillTotemCheck(player, totem)
        if (totemCheck) {
            let level = totemCheck
            applyEffectFromItem(player, event.item.id, useItem_applyEffect[totem], level)
        }
    })
    let cd = 1200 // 1 minute cooldown

    // If player has the parched skill, apply the effect to nearby allies
    if (player.persistentData.get('parched')) {
        let level = player.persistentData.parched
        let radius = 5 * level
        let allies = player.level.entities.filter(p => p.distanceToEntity(player) <= radius && isAlly(player, p) && p != player)
        allies.forEach(ent => {
            applyEffect(ent, effect, dur, amp)
        })

        cd = 1000 - ((player.persistentData.parched - 1) * 100)
        
        if (level >= 5) {
            skill_totems.forEach(totem => {
                let totemCheck = skillTotemCheck(player, totem)
                if (totemCheck) {
                    let skilllevel = totemCheck
                    applyEffectFromItem(ent, event.item.id, useItem_applyEffect[totem], skilllevel)
                }
            })
        }
        
    }

    player.cooldowns.addCooldown(event.item, cd)
    playDrinkSound(player)

    // Quest/first-use progress stays the same
    if (questId && tagKey && !player.persistentData.get(tagKey)) {
        player.persistentData.putBoolean(tagKey, true)
        Utils.server.runCommandSilent(`/ftbquests change_progress ${player.username} complete ${questId}`)
    }
}


// Potion right-clicks
let potionData = {
    'kubejs:lesser_health_elixir': { effect: 'minecraft:regeneration', duration: 100, amp: 1, quest: '4184AE3BF13B7F11', tag: 'lesser_health_elixir_used' },
    'kubejs:greater_health_elixir': { effect: 'minecraft:regeneration', duration: 150, amp: 2 },
    'kubejs:exalted_health_elixir': { effect: 'minecraft:regeneration', duration: 200, amp: 3 },
    'kubejs:lesser_mana_elixir': { effect: 'irons_spellbooks:instant_mana', duration: 1, amp: 0, quest: '759E0420B790E4FF', tag: 'lesser_mana_elixir_used' },
    'kubejs:greater_mana_elixir': { effect: 'irons_spellbooks:instant_mana', duration: 1, amp: 1 },
    'kubejs:exalted_mana_elixir': { effect: 'irons_spellbooks:instant_mana', duration: 1, amp: 2 },
}

for (let [id, d] of Object.entries(potionData)) {
    // Destructure now so each listener gets its *own* letants
    let { effect, duration, amp, quest, tag } = d

    ItemEvents.rightClicked(id, event => {
        handlePotionUse(event, effect, duration, amp, quest, tag)
        event.cancel()
    })

    BlockEvents.rightClicked(event => {
        if (event.player.handSlots[0].id.includes('elixir')) {
            let potion_id = event.player.handSlots[0].id
            let potion = potionData[potion_id]
            handlePotionUse(event, potion.effect, potion.duration, potion.amp, potion.quest, potion.tag)
            event.cancel()
        }
    })

    ItemEvents.entityInteracted(id, event => {
        handlePotionUse(event, effect, duration, amp, quest, tag)
        event.cancel()
    })
}


// One handler for all elixir pickups
PlayerEvents.inventoryChanged(event => {
  let itemId = event.item?.id
  if (!itemId) return

  // Map each elixir to its slot, clear id, and quest
  let rules = {
    'kubejs:greater_health_elixir': {
      slot: 0,
      set: 'kubejs:greater_health_elixir',
      clear: 'kubejs:greater_health_elixir',
      quest: '441E6AB1E1B375EF',
      // don't overwrite if slot already has greater OR exalted health elixir
      guard(cur) { return cur === 'kubejs:greater_health_elixir' || cur === 'kubejs:exalted_health_elixir' }
    },
    'kubejs:exalted_health_elixir': {
      slot: 0,
      set: 'kubejs:exalted_health_elixir',
      clear: 'kubejs:exalted_health_elixir',
      quest: '65A1C8F2B9CB33EB',
      // don't overwrite if already exalted health
      guard(cur) { return cur === 'kubejs:exalted_health_elixir' }
    },
    'kubejs:greater_mana_elixir': {
      slot: 2,
      set: 'kubejs:greater_mana_elixir',
      clear: 'kubejs:greater_mana_elixir',
      quest: '38D4DFA8C89A4E4A',
      // don't overwrite if slot already has greater OR exalted mana elixir
      guard(cur) { return cur === 'kubejs:greater_mana_elixir' || cur === 'kubejs:exalted_mana_elixir' }
    },
    'kubejs:exalted_mana_elixir': {
      slot: 2,
      set: 'kubejs:exalted_mana_elixir',
      clear: 'kubejs:exalted_mana_elixir',
      quest: '2AA52DFE317ABFCA',
      // don't overwrite if already exalted mana
      guard(cur) { return cur === 'kubejs:exalted_mana_elixir' }
    }
  }

  let rule = rules[itemId]
  if (!rule) return

  let handler = Java.loadClass('snownee.skillslots.SkillSlotsHandler').of(event.player)
  let currentId = handler.skills.get(rule.slot).item.id

  // Respect your original guard behavior
  if (rule.guard(currentId)) return

  handler.setItem(rule.slot, rule.set)
  Utils.server.runCommandSilent(`/clear ${event.player.username} ${rule.clear}`)
  Utils.server.runCommandSilent(`/ftbquests change_progress ${event.player.username} complete ${rule.quest}`)
})
