let self_horns = {
    admire: { //
        effects: ['runiclib:restoration'],
        duration: 450,
        amplifier: 1,
        cooldown: 4800,
    },
    feel: { //
        effects: ['minecraft:resistance', 'minecraft:strength', 'minecraft:haste'],
        duration: 900,
        amplifier: 1,
        cooldown: 4800,
    },
}
let aoe_horns = {
    sing: { //
        effects: ['minecraft:regeneration', 'minecraft:speed'],
        duration: 900,
        amplifier: 1,
        cooldown: 4800,
        ismonster: false,
    },
    seek: {
        effects: ['minecraft:glowing', 'minecraft:slowness'],
        duration: 900,
        amplifier: 0,
        cooldown: 4800,
        ismonster: true,
        
    },
    yearn: {
        effects: ['minecraft:absorption', 'minecraft:night_vision'],
        duration: 900,
        amplifier: 1,
        cooldown: 4800,
        ismonster: false,
    },
    ponder: { //
        effects: ['irons_spellbooks:true_invisibility'],
        duration: 900,
        amplifier: 0,
        cooldown: 4800,
        ismonster: true,
    },
}

let command_horns = {
        dream: `sanity set @p 0`, //
        //call: `/summon iceandfire:amphithere ${x} ${y} ${z} {Owner:${username}}`,
}

Object.entries(self_horns).forEach(([key, value]) => {
    ItemEvents.rightClicked('minecraft:goat_horn', event => {
        if (!event.player.persistentData.get(key)) return
        if (!event.item.nbt.toString().includes(key)) return
        event.server.scheduleInTicks(5, () => {
            event.player.cooldowns.addCooldown(event.item, 4800)
        })
        value.effects.forEach(effect => {
            event.player.potionEffects.add(effect, value.duration, value.amplifier)
        })
        
    })
})

Object.entries(aoe_horns).forEach(([key, value]) => {
    ItemEvents.rightClicked('minecraft:goat_horn', event => {
        if (!event.player.persistentData.get(key)) return
        if (!event.item.nbt.toString().includes(key)) return
        let player = event.player
        event.server.scheduleInTicks(5, () => {
            event.player.cooldowns.addCooldown(event.item, 4800)
        })
        let box = AABB.of(player.x+20, player.y+20, player.z+20, player.x-20, player.y-20, player.z-20)
        let dim = event.level
        let entitiesWithin = dim.getEntitiesWithin(box).filter(e => e.isAlive())
        entitiesWithin.forEach(entity => {
            if (entity.isMonster() == value.ismonster) {
                value.effects.forEach(effect => {
                    applyEffect(entity, effect, value.duration, value.amplifier)
                })
            }
        })
        
    })
})



Object.entries(command_horns).forEach(([key, value]) => {
    ItemEvents.rightClicked('minecraft:goat_horn', event => {
        //player needs to have dream persistent data or mindshatter persistent data
        if (!event.player.persistentData.get(key) && !event.player.persistentData.get('mindshatter')) return
        if (!event.item.nbt.toString().includes(key)) return
        if (!event.player.potionEffects.isActive('kubejs:insanity')) {
            event.server.scheduleInTicks(5, () => {
                event.player.cooldowns.addCooldown(event.item, 600)
                goInsane(event.player)
            })
        } else {
            event.server.scheduleInTicks(1, () => {
                event.player.cooldowns.addCooldown(event.item, 300)
                removeInsanity(event.player)
            })
        }
    })

})

PlayerEvents.respawned(event => {
    event.server.runCommandSilent(`/execute at ${event.player.username} run sanity set @p 100`)
    event.player.tags.remove('insane')
})
            

