EntityEvents.hurt('player', event => {
    let p = event.entity
    let player = event.server.getPlayer(p)
    let curio = detectCurios(player, 'kubejs:effigy_of_the_undying')
    if (!curio) return;
    Utils.server.scheduleInTicks(20, () => {
        if (!needsRevive(player)) return;
        revivePlayer(player, true); // revive without effects
        player.setHealth(parseFloat(player.maxHealth/4).toFixed(2))
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound minecraft:entity.wither.ambient ambient ${player.username} ${player.x} ${player.y} ${player.z} 1 0.75`)
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound minecraft:item.shield.break ambient ${player.username} ${player.x} ${player.y} ${player.z} 1 0.75`)
        let gravewalkerCheck = skillTotemCheck(player, 'gravewalker')
        if (gravewalkerCheck) {
            let gravewalkerLevel = gravewalkerCheck
            let chance = Math.random(); 
            if (chance > 0.20*gravewalkerLevel) {
                removeCurio(player, 'kubejs:effigy_of_the_undying')
            }
        } else {
            removeCurio(player, 'kubejs:effigy_of_the_undying')
        }

        let revenantCheck = skillTotemCheck(player, 'revenant')
        if (revenantCheck) {
            let level = revenantCheck
            let duration = 100 * level
            applyEffect(player, 'irons_spellbooks:true_invisibility', duration, 0, 'revenant_invis', player)
            applyEffect(player, 'minecraft:speed', duration, 1, 'revenant_speed', player)
        }
        
        let divinityCheck = skillTotemCheck(player, 'divinity')
        if (divinityCheck) {
            player.setHealth(player.maxHealth) // restore health based on level
            let otherPlayers = player.level.players.filter(p => p.username !== player.username);
            otherPlayers.forEach(otherPlayer => {
                if (needsRevive(otherPlayer)) {
                    revivePlayer(otherPlayer, true); 
                    otherPlayer.setHealth(parseFloat(otherPlayer.maxHealth/4).toFixed(2))
                }
            });
        }

    })
})