/**
 * Blood Bucket
 *  - Shift Right click a villager with the Mutant Enderman heart to it float in front of you
 *  - Right click the villager to deal damage to it
 * - After 5 right clicks, you will receive a blood bucket

ItemEvents.entityInteracted(event => {
    if (event.target.type != 'minecraft:villager') return
    if (event.player.inventory.count('minecraft:bucket') < 0) return
    if (!event.target.tags.contains('enderman_heart_target')) return
    event.target.attack(event.target.maxHealth/5)
    if (blood_bucket_map[event.player.username] == undefined) {
        blood_bucket_map[event.player.username] = 1
    } else {
        blood_bucket_map[event.player.username] += 1
    }
    event.target.playSound('alexsmobs:fly_hurt', 1, 2)
    //Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle biomesoplenty:falling_blood ${event.target.x} ${event.target.y} ${event.target.z} 0.2 0.2 0.2 4 100 force`)
    Utils.server.runCommandSilent(`/photon fx photon:ripper_indicator entity ${event.target.uuid}`)
    if (blood_bucket_map[event.player.username] < 6) return
    blood_bucket_map[event.player.username] = 0
    event.player.giveInHand('kubejs:blood_bucket')
})


ItemEvents.pickedUp('kubejs:mutant_enderman_heart', event => {
    event.player.persistentData.putInt('enderman_heart', 0)
})

ItemEvents.entityInteracted('kubejs:mutant_enderman_heart', event => {
    if (event.target.type != 'minecraft:villager') return
    if (event.player.mainHandItem == event.item) return
    let player = event.player
    if (player.persistentData.enderman_heart == 1) {
        player.persistentData.enderman_heart = 0
        return
    } else if (player.persistentData.enderman_heart == 0) {
        player.persistentData.enderman_heart = 1
    }
    let ent = event.target
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle blue_skies:black_flame ${ent.x} ${ent.y+1} ${ent.z} 0.5 0.5 0.5 0.05 50`)
    Utils.server.scheduleInTicks(2, e => {
        if (player.persistentData.enderman_heart == 0) {
            player.persistentData.enderman_heart = 0
            e.repeating = false
            ent.tags.remove('enderman_heart_target')
            return
        } else if (player.persistentData.enderman_heart == 1) {
            e.repeating = true
        }
        let x_rad = player.pitch * JavaMath.PI / 180;
        let y_rad = player.yaw * JavaMath.PI / 180;
        let dirV = {
            x: -Math.sin(y_rad) * Math.cos(x_rad),
            y: -Math.sin(x_rad),
            z: Math.cos(y_rad) * Math.cos(x_rad)
        }
        // get the crosshair location
        let crosshair_location = {
            x: player.x + dirV.x * 2.5,
            y: player.y+1.6 + dirV.y * 2.5,
            z: player.z + dirV.z * 2.5
        }
        let mod = 0.15
        ent.addMotion((crosshair_location.x - ent.x)*mod, (crosshair_location.y - ent.y)*mod, (crosshair_location.z - ent.z)*mod)
        ent.tags.add('enderman_heart_target')
        
    })
})
 */

/**
 * let blood_bucket_map =new WeakMap()


ItemEvents.entityInteracted(`minecraft:bucket`, event => {
    if (event.target.type != 'minecraft:villager') return
    if (event.target.health == 0) return
    let max = 3
    event.target.attack(event.target.maxHealth/max)
    if (!event.target.isBaby()) {
        if (blood_bucket_map[event.player.username] == undefined) {
            blood_bucket_map[event.player.username] = 1
        } else {
            blood_bucket_map[event.player.username] += 1
        }
    } else {
        if (blood_bucket_map[event.player.username] == undefined) {
            blood_bucket_map[event.player.username] = max+1
            event.target.kill()
        } else {
            blood_bucket_map[event.player.username] += max+1
            event.target.kill()
        }
    }

    
    //Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle biomesoplenty:falling_blood ${event.target.x} ${event.target.y} ${event.target.z} 0.2 0.2 0.2 4 100 force`)
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle irons_spellbooks:blood ${event.target.x} ${event.target.y} ${event.target.z} 0.3 0.3 0.3 0.5 50 force @a`)
    //Utils.server.runCommandSilent(`/photon fx photon:ripper_indicator entity ${event.target.uuid}`)
    if (blood_bucket_map[event.player.username] <= max+1) return
    blood_bucket_map[event.player.username] = 0

})
 * 
 * 
 */





ItemEvents.entityInteracted(`minecraft:bucket`, event => {
    if (event.target.type != 'minecraft:villager') return
    event.target.playSound('alexsmobs:fly_hurt', 1, 2)
    event.target.kill()
    event.item.count -= 1
    event.player.giveInHand('kubejs:blood_bucket')
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run particle irons_spellbooks:blood ${event.target.x} ${event.target.y} ${event.target.z} 0.3 0.3 0.3 0.5 100 force @a`)
    let box = AABB.of(
        event.player.x + 30, event.player.y + 3, event.player.z + 30, 
        event.player.x - 30, event.player.y - 3, event.player.z - 30
    )

})

