




//___________________________________________________________________________________________________________________________________________________


// If a player has the effect, hitting a mob will choose a random effect from the array and apply it to the attacked mob
const playerHasEffect_hit_mobGetsEffect = {
    'cloaked_blade': { // Curio
        player_effect: 'cofh_core:true_invisibility',
        mob_effect: 'runiclib:venom',
        chance: 0.30, // 30% chance to apply the effect
        ticks: 60
    },
    'frost_wraith': {
        player_effect: 'cofh_core:true_invisibility',
        mob_effect: 'cofh_core:chilled',
        chance: 0.30, // 30% chance to apply the effect
        ticks: 60

    },
    'lucky_hex': {
        player_effect: 'minecraft:luck',
        mob_effect: 'kubejs:hexed',
        chance: 0.15, // 30% chance to apply the effect
        ticks: 60
    },
    'phantom_vengeance': {
        player_effect: 'cofh_core:true_invisibility',
        mob_effect: 'minecells:bleeding',
        chance: 0.30,
        ticks: 60
    }

}

Object.keys(playerHasEffect_hit_mobGetsEffect).forEach(curio => {
    EntityEvents.hurt(event => {
        if (!event.source.player) return
        if (!event.source.player.potionEffects.isActive(playerHasEffect_hit_mobGetsEffect[curio].player_effect)) return
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return
        let level = totemNBT
        let odds = playerHasEffect_hit_mobGetsEffect[curio].chance * level
        if (Math.random() > odds) return // if the random number is greater than the odds, do not apply the effect
        let ticks = playerHasEffect_hit_mobGetsEffect[curio].ticks * level
        applyEffect(event.entity, playerHasEffect_hit_mobGetsEffect[curio].mob_effect, ticks, 0, '', '', true)
    })
})



// If a mob has the effect, hitting them will choose a random effect from the array and apply it to the same mob with the defined chance
const mobHasEffect_hitChance_mobGetsEffect = {
    'sanguine': {
        mob_effect1: 'minecells:bleeding',
        mob_effect2: 'kubejs:marked_for_death',
        chance: 0.15,
        ticks: 60
    }, 
    'plague_of_rust': {
        mob_effect1: 'fromtheshadows:plague',
        mob_effect2: 'irons_spellbooks:rend',
        chance: 0.25,
        ticks: 60
    },
    'wounding_strike': {
        mob_effect1: 'irons_spellbooks:rend',
        mob_effect2: 'minecells:bleeding',
        chance: 0.15,
        ticks: 60
    },
    'pathogenic_hex': {
        mob_effect1: 'kubejs:hexed',
        mob_effect2: 'runiclib:venom',
        chance: 0.20,
        ticks: 60
    },
    'biting_cold': {
        mob_effect1: 'cofh_core:chilled',
        mob_effect2: 'minecraft:slowness',
        chance: 0.20,
        ticks: 80
    }
}

Object.keys(mobHasEffect_hitChance_mobGetsEffect).forEach(curio => {
    EntityEvents.hurt(event => {
        if (!event.source.player) return
        if (!event.entity.potionEffects.isActive(mobHasEffect_hitChance_mobGetsEffect[curio].mob_effect1)) return
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return
        let level = totemNBT
        if (mobHasEffect_hitChance_mobGetsEffect[curio].chance * level < Math.random()) return
        if (event.entity.deadOrDying) return
        let ticks = mobHasEffect_hitChance_mobGetsEffect[curio].ticks * level
        applyEffect(event.entity, mobHasEffect_hitChance_mobGetsEffect[curio].mob_effect2, ticks, 0, '', '', true)

    })
})



// Killing a mob with the effect will make it so you apply the 2nd effect to the next number of hits
const mobDies_playerGetsHitEffect = {
    // Ex.) With the bloodhunt curio, if you kill a mob with slowness, you will apply bleeding to the next 5 hits
    'bloodhunt': {
        mob_effect: 'minecraft:slowness',
        player_hit_effects: 'minecells:bleeding',
        hits: 3,
        method: 'melee'
    },
    'hexblood': {
        mob_effect: 'runiclib:venom',
        player_hit_effects: 'kubejs:hexed',
        hits: 3,
        method: 'spell'
    },
    'reapers_call': {
        mob_effect: 'cofh_core:chilled',
        player_hit_effects: 'kubejs:marked_for_death',
        hits: 1,
        method: 'melee'
    },
    'spell_break': {
        mob_effect: 'kubejs:hexed',
        player_hit_effects: 'irons_spellbooks:rend',
        hits: 3,
        method: 'spell'
    }
}

Object.keys(mobDies_playerGetsHitEffect).forEach(curio => {
    EntityEvents.death(event => {
        if (!event.source.player) return
        if (isAlly(event.source.player, event.entity)) return
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return
        let level = totemNBT
        if (!event.entity.potionEffects.isActive(mobDies_playerGetsHitEffect[curio].mob_effect)) return
        if (mobDies_playerGetsHitEffect[curio].method == 'melee') {
            if (event.source.indirect) return
        } else if (mobDies_playerGetsHitEffect[curio].method == 'spell') {
            let spell = isSpellDamageSource(event.source)
            if (!spell) return
        } else if (mobDies_playerGetsHitEffect[curio].method == 'ranged') {
            let proj_check = physicalProjectileCheck(event.source)
            if (!proj_check) return
        }
        event.source.player.persistentData.putInt(`${mobDies_playerGetsHitEffect[curio]}_hits`, parseInt(Number(mobDies_playerGetsHitEffect[curio].hits) * Number(level)))
    })

    EntityEvents.hurt(event => {
        if (!event.source.player) return
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return
        let player = event.source.player
        if (!player.persistentData.get(`${mobDies_playerGetsHitEffect[curio]}_hits`)) return
        if (player.persistentData.getInt(`${mobDies_playerGetsHitEffect[curio]}_hits`) <= 0) return
        if (event.entity.isDeadOrDying()) return
        applyEffect(event.entity, mobDies_playerGetsHitEffect[curio].player_hit_effects, 100, 1, '', '', true)
    })
})

// Killing a mob with the effect will make it so you apply the 2nd effect to a random mob within a certain radius
const killMob_spreadToRandom = {
    'synapse': {
        mob_effect: ['minecells:stunned', 'alexscaves:stunned'],
        spreadEffect: 'minecells:stunned',
        duration: 60, // in ticks
        method: 'ranged', 
        entity_count: 1
    },
    'aftershock': {
        mob_effect: ['minecells:stunned', 'alexscaves:stunned'],
        spreadEffect: 'irons_spellbooks:rend',
        duration: 60,
        method: 'melee',
        entity_count: 1
    },
    'witchglass': {
        mob_effect: ['kubejs:hexed'],
        spreadEffect: 'runiclib:venom',
        duration: 60,
        method: 'spell',
        entity_count: 1
    },
    'hexchain': {
        mob_effect: ['kubejs:hexed'],
        spreadEffect: 'kubejs:hexed',
        duration: 60,
        method: 'spell',
        entity_count: 2
    },
}


Object.keys(killMob_spreadToRandom).forEach(curio => {
    EntityEvents.death(event => {
        if (!event.source.player) return
        if (isAlly(event.source.player, event.entity)) return
        if (killMob_spreadToRandom[curio].method) {
            let method = determineMethod(event.source)
            if (method != killMob_spreadToRandom[curio].method) return
        }
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return
        let level = totemNBT
        let valid = false
        killMob_spreadToRandom[curio].mob_effect.forEach(effect => {
            if (event.entity.potionEffects.isActive(effect)) {
                valid = true
            }
        })
        if (!valid) return
        let box = AABB.of(event.entity.x+10, event.entity.y+3, event.entity.z+10, event.entity.x-10, event.entity.y-3, event.entity.z-10)
        // make sure its only monsters
        let entitiesWithin = event.level.getEntitiesWithin(box).filter(ent => ent.isMonster() && !ent.isDeadOrDying())
        // get a random entity from the list
        if (entitiesWithin.length == 0) return
        for (let i = 1; i < killMob_spreadToRandom[curio].entity_count*level; i++) {
            let randomEntity = entitiesWithin[Math.floor(Math.random() * entitiesWithin.length)]
            let duration = killMob_spreadToRandom[curio].duration * level
            applyEffect(randomEntity, killMob_spreadToRandom[curio].spreadEffect, duration, level-1, `${curio}`)
            // remove the entity from the list so we don't hit the same one twice
            entitiesWithin = entitiesWithin.filter(ent => ent.uuid != randomEntity.uuid)
        }
    })
})


const killMob_runCommand = {
    'mana_bloom': {
        mob_effect: 'kubejs:hexed',
        command: 'mana add @s 25',
        method: 'spell',
        chance: 0.30
    },
    'soul_tithe': {
        mob_effect: 'kubejs:hexed',
        command: 'mana add @s 15',
        method: 'melee',
        chance: 0.30
    }
}

Object.keys(killMob_runCommand).forEach(curio => {
    EntityEvents.death(event => {
        if (!event.source.player) return
        if (isAlly(event.source.player, event.entity)) return
        if (killMob_runCommand[curio].method) {
            if (killMob_runCommand[curio].method == 'spell') {
                let spell = isSpellDamageSource(event.source)
                if (!spell) return
            } else if (killMob_runCommand[curio].method == 'ranged') {
                let proj_check = physicalProjectileCheck(event.source)
                if (!proj_check) return
            } else if (killMob_runCommand[curio].method == 'melee') {
                if (event.source.indirect) return
            }
        }
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return
        let level = totemNBT
        let odds = killMob_runCommand[curio].chance * level
        if (Math.random() > odds) return // if the random number is greater than the odds, do not run the command
        if (!event.entity.potionEffects.isActive(killMob_runCommand[curio].mob_effect)) return
        event.source.player.runCommandSilent(`/execute as ${event.source.player.username} run `+killMob_runCommand[curio].command)
    })
})   



EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (!event.source.indirect) return // only run if the source is a player
    if (event.source.immediate == null) return
    let proj_check = arrowCheck(event.source)
    if (!proj_check) return // only run if the source is an arrow
    let totemNBT = skillTotemCheck(event.source.player, 'spectral_splinter')
    if (!totemNBT) return
    let level = totemNBT
    //tell(`Level: ${level}`)
    let chance = 0.15 * level // 25% chance to split the arrow
    //tell(`Chance: ${chance}`)
    if (Math.random() > chance) return // if the random number is greater than the chance, do not split the arrow
    let proj = event.source.immediate
    handleProjectileSplit(proj, 2, 'xtraarrows:flint_vexing_arrow', 1, 10, 1)
})



const applyStacks_hit_consumeEffect = {
    'death_grip': {
        stackEffect: 'cofh_core:chilled',
        max_stacks: 5,
        percent_per_stack: 0.05,
        applyEffect: 'mowziesmobs:frozen',
        durationPerStack: 40,
        mana_cost: 10,
        method: 'ranged'
    }
}

Object.keys(applyStacks_hit_consumeEffect).forEach(curio => {
    EntityEvents.hurt(event => {
        if (!event.source.player) return
        let check = determineMethod(event.source)
        if (!check) return
        if (check != applyStacks_hit_consumeEffect[curio].method) return
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return
        let level = totemNBT
        let player = event.source.player
        let entity = event.entity
        if (!event.entity.potionEffects.isActive(applyStacks_hit_consumeEffect[curio].stackEffect)) return
        let current_stack = entity.potionEffects.getActive(applyStacks_hit_consumeEffect[curio].stackEffect).amplifier
        let max_stacks = applyStacks_hit_consumeEffect[curio].max_stacks
        let new_stack = current_stack + 1
        if (new_stack > max_stacks) new_stack = max_stacks
        let stack_effect = applyStacks_hit_consumeEffect[curio].stackEffect
        let duration = current_stack * applyStacks_hit_consumeEffect[curio].durationPerStack
        applyStackingEffect(entity, stack_effect, duration, new_stack, `${curio}_stacks`)
        //Utils.server.runCommandSilent(`/effect give ${entity.uuid} ${stack_effect} ${duration} ${new_stack} true`)
        let mana_cost = applyStacks_hit_consumeEffect[curio].mana_cost
        changeMana(player, (mana_cost*-1))
        let odds = applyStacks_hit_consumeEffect[curio].percent_per_stack * level * new_stack
        if (Math.random() > odds) return // if the random number is greater than the odds, do not apply the effect
        let apply_effect = applyStacks_hit_consumeEffect[curio].applyEffect
        applyEffect(entity, apply_effect, duration, new_stack, `${curio}_consume`, null)
        Utils.server.runCommandSilent(`/effect clear ${entity.uuid} ${stack_effect}`) // clear the stack effect after applying the new one
    })
})



const consumeStacksOnHit_applyAoe = {
    'grim_reaper': {
        stackEffect: 'kubejs:hexed',
        percent_per_stack: 0.07,
        applyEffect: 'kubejs:marked_for_death',
        radius: 10,
        duration_per_stack: 80, // duration in ticks
    }
}



Object.keys(consumeStacksOnHit_applyAoe).forEach(curio => {
    EntityEvents.hurt(event => {
        if (!event.source.player) return
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return
        let level = totemNBT
        let player = event.source.player
        let entity = event.entity
        if (!entity.potionEffects.isActive(consumeStacksOnHit_applyAoe[curio].stackEffect)) return // if the stack effect is not active, do not run
        let current_stack = entity.potionEffects.getActive(consumeStacksOnHit_applyAoe[curio].stackEffect).amplifier
        let odds = consumeStacksOnHit_applyAoe[curio].percent_per_stack * current_stack * level
        if (Math.random() > odds) return // if the random number is greater than the odds, do not apply the effect
        let apply_effect = consumeStacksOnHit_applyAoe[curio].applyEffect
        let radius = consumeStacksOnHit_applyAoe[curio].radius
        let duration = consumeStacksOnHit_applyAoe[curio].duration_per_stack * current_stack
        let box = AABB.of(entity.x+radius, entity.y+radius, entity.z+radius, entity.x-radius, entity.y-radius, entity.z-radius)
        let entitiesWithin = event.level.getEntitiesWithin(box).filter(ent => ent.isMonster() && !ent.isDeadOrDying())
        entitiesWithin.forEach(ent => {
            applyEffect(ent, apply_effect, duration, level-1, `${curio}_aoe`)
            //Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle born_in_chaos_v1:ritual ${ent.x} ${ent.y + 1} ${ent.z} 0.5 0.5 0.5 0.1 100`)
            Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound minecraft:entity.wither.spawn ambient ${player.username} ${ent.x} ${ent.y} ${ent.z} 1 1.5`)
        })
    })
})



function determineMethod(source) {
    if (source.indirect) {
        if (physicalProjectileCheck(source)) return 'ranged';
        if (isSpellDamageSource(source)) return 'spell';
    } else {
        return 'melee';
    }
    return null;
}


function changeMana(player, amount) {
    player.magicData.setMana(player.magicData.getMana() + amount)
}




const giveOrExtendPlayerEffectsOnKill = {
    'ancestral_strength': {
        effects: ['minecraft:strength'],
        effectType: 'all',
        duration: 40,
        method: 'melee',
        chance: 0.20
    },
    'final_gasp': {
        effects: ['runiclib:venom', 'minecells:bleeding', 'cofh_core:chilled'],
        effectType: 'random',
        duration: 15*20,
        chance: 0.05,
    }

}


Object.keys(giveOrExtendPlayerEffectsOnKill).forEach(curio => {
    EntityEvents.death(event => {
        if (!event.source.player) return
        if (isAlly(event.source.player, event.entity)) return
        giveOrExtendPlayerEffectsOnKill[curio].effects.forEach(effect => {
            if (!event.source.player.potionEffects.isActive(effect)) return // if the effect is not active, do not run
        })
        if (giveOrExtendPlayerEffectsOnKill[curio].method) {
            let method = determineMethod(event.source)
            if (method != giveOrExtendPlayerEffectsOnKill[curio].method) return
        }

        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return
        let level = totemNBT
        let player = event.source.player
        let effects = giveOrExtendPlayerEffectsOnKill[curio].effects
        if (Math.random() > giveOrExtendPlayerEffectsOnKill[curio].chance) return // chance to apply the effect
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound alexscaves:abyssmarine_glow_on ambient ${player.username} ${player.x} ${player.y+1} ${player.z} 1 1.5`)
        if (giveOrExtendPlayerEffectsOnKill[curio].effectType === 'random') {
            let randomEffect = effects[Math.floor(Math.random() * effects.length)]
            let duration = giveOrExtendPlayerEffectsOnKill[curio].duration * level
            applyEffect(player, randomEffect, duration, level-1, `${curio}`)
        } else if (giveOrExtendPlayerEffectsOnKill[curio].effectType === 'all') {
            effects.forEach(effect => {
                applyEffect(player, effect, giveOrExtendPlayerEffectsOnKill[curio].duration * level, level-1, `${curio}`)
            })
        }
    })
})


/**
 * Reapplies an effect to a player, extending its duration or amplifier. Can also just add the effect if it is not already active.
 * @param {*} targetEntity Entity to modify the effect on
 * @param {*} effect Potion Effect ID
 * @param {*} modifyType1 'duration' or 'amplifier' to modify the first value
 * @param {*} value1 The value to modify by (e.g., duration in ticks or amplifier level)
 * @returns 
 */








/**
 * 
 */
function modifyEffect(targetEntity, effect, modifyType1, value1, modifyType2, value2) {
    if (targetEntity.potionEffects.isActive(effect)) {
        let currentEffect = targetEntity.potionEffects.getActive(effect);
        switch (modifyType1) {
            case 'duration':
                let newDuration = currentEffect.getDuration() + value1;
                if (newDuration < 0) newDuration = 0; // Prevent negative duration
                let currentAmplifier = currentEffect.getAmplifier();
                applyEffect(targetEntity, effect, newDuration, currentAmplifier, 'modifyEffect', null, false)
                break;
            case 'amplifier':
                let newAmplifier = currentEffect.getAmplifier() + value1;
                let dur = currentEffect.getDuration();
                Utils.server.runCommandSilent(`/effect clear ${targetEntity.uuid} ${effect}`) // clear the effect before reapplying it
                applyEffect(targetEntity, effect, dur, newAmplifier)
                break;
            default:
                console.log(`Invalid modifyType1: ${modifyType1}. Use 'duration' or 'amplifier'.`);
                return;
        }
        switch (modifyType2) {
            case 'duration':
                let newDuration2 = currentEffect.getDuration() + value2;
                if (newDuration2 < 0) newDuration2 = 0; // Prevent negative duration
                let amp2 = currentEffect.getAmplifier();
                applyEffect(targetEntity, effect, newDuration2, amp2)
                break;
            case 'amplifier':
                let newAmplifier2 = currentEffect.getAmplifier() + value2;
                let dur2 = currentEffect.getDuration();
                Utils.server.runCommandSilent(`/effect clear ${targetEntity.uuid} ${effect}`) // clear the effect before reapplying it
                applyEffect(targetEntity, effect, dur2, newAmplifier2)
                break;
            default:
                console.log(`Invalid modifyType2: ${modifyType2}. Use 'duration' or 'amplifier'.`);
                return;
        }
    } else {
        let duration = 0
        let amplifier = 0
        if (modifyType1 === 'duration') {
            duration = value1
            amplifier = value2
        } else if (modifyType1 === 'amplifier') {
            duration = value2
            amplifier = value1
        }
        if (targetEntity.player) {
            applyEffect(targetEntity, effect, duration, amplifier, 'modifyEffect', null);
        } else {
            let durationInSeconds = Math.floor(duration / 20); // Convert ticks to seconds
            Utils.server.runCommandSilent(`/effect give ${targetEntity.uuid} ${effect} ${durationInSeconds} ${amplifier} true`);
        }
        
    }
}



const playerHasEffect_playerGetsEffect = {
    'bloodshroud': {
        currentEffect: 'minecells:bleeding',
        applyEffects: ['cofh_core:true_invisibility', 'irons_spellbooks:true_invisibility', 'minecraft:speed'],
        consumeOnAttack: true, // if true, all effects will be removed when you attack a mob
    },
    'phantom_step': {
        currentEffect: 'kubejs:dashing',
        applyEffects: ['cofh_core:true_invisibility', 'irons_spellbooks:true_invisibility', 'minecraft:speed'],
        consumeOnAttack: true, // if true, all effects will be removed when you attack a mob
        duration: 60 // in ticks
    },
    'frozen_lightning': {
        currentEffect: 'kubejs:permafrost_charge',
        applyEffects: ['kubejs:shock_charge'],
        consumeOnAttack: false, // if true, all effects will be removed when you attack a mob
    },
    'momentum': {
        currentEffect: 'kubejs:dashing',
        applyEffects: ['minecraft:haste', 'minecraft:strength'],
        duration: 60, // in ticks
    }
}


const playerHasEffect_consumeNearbyMonsterEffect_applyEffect = {
    'scouring_winds': {
        player_effect: 'kubejs:dashing',
        monster_effect: 'kubejs:hexed',
        applyEffect: 'minecraft:speed',
        duration: 100, // in ticks
        radius: 15, // radius to find monsters with the effect
    }
}




global.PlayerEffects.onAdded(function ({ player, effectId, amplifier, duration }) {
    if (!player) return
    Object.keys(playerHasEffect_playerGetsEffect).forEach(curio => {
        if (effectId != playerHasEffect_playerGetsEffect[curio].currentEffect) return
        let totemNBT = skillTotemCheck(player, `${curio}`)
        if (!totemNBT) return
        let level = totemNBT
        let dur = 60
        if (playerHasEffect_playerGetsEffect[curio].duration) {
            dur = playerHasEffect_playerGetsEffect[curio].duration * level
        } else {
            dur = duration
        }
        
        playerHasEffect_playerGetsEffect[curio].applyEffects.forEach(effect => {
            if (player.potionEffects.isActive(effect)) return // if the effect is already active, do not apply it again
            applyEffect(player, effect, dur, level, `${curio}_player_effect`, null)
        })
})

    Object.keys(playerHasEffect_consumeNearbyMonsterEffect_applyEffect).forEach(curio => {
        if (!player.potionEffects.isActive(playerHasEffect_consumeNearbyMonsterEffect_applyEffect[curio].player_effect)) return
        let totemNBT = skillTotemCheck(player, `${curio}`)
        if (!totemNBT) return
        let radius = playerHasEffect_consumeNearbyMonsterEffect_applyEffect[curio].radius
        let box = AABB.of(player.x+radius, player.y+3, player.z+radius, player.x-radius, player.y-3, player.z-radius)
        let entitiesWithin = player.level.getEntitiesWithin(box).filter(ent => ent.isMonster() && !ent.isDeadOrDying() && ent.potionEffects.isActive(playerHasEffect_consumeNearbyMonsterEffect_applyEffect[curio].monster_effect))
        if (entitiesWithin.length == 0) return // if there are no entities within the radius, do not apply the effect
        entitiesWithin.forEach(ent => {
            if (player.potionEffects.isActive(playerHasEffect_consumeNearbyMonsterEffect_applyEffect[curio].applyEffect)) return // if the player already has the effect, do not apply it again
            applyEffect(player, playerHasEffect_consumeNearbyMonsterEffect_applyEffect[curio].applyEffect, playerHasEffect_consumeNearbyMonsterEffect_applyEffect[curio].duration, 1, `${curio}_player_effect`, player)
            Utils.server.runCommandSilent(`/effect clear ${ent.uuid} ${playerHasEffect_consumeNearbyMonsterEffect_applyEffect[curio].monster_effect}`) // clear the monster effect after applying the player effect
        })
    })
})

EntityEvents.hurt(event => {
    if (!event.source.player) return
    Object.keys(playerHasEffect_playerGetsEffect).forEach(curio => {
        if (!event.source.player.potionEffects.isActive(playerHasEffect_playerGetsEffect[curio].currentEffect)) return
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return
        if (!playerHasEffect_playerGetsEffect[curio].consumeOnAttack) return // if consumeOnAttack is false, do not remove the effects
        let player = event.source.player
        playerHasEffect_playerGetsEffect[curio].applyEffects.forEach(effect => {
            if (player.potionEffects.isActive(effect)) {
                Utils.server.runCommandSilent(`/effect clear ${player.uuid} ${effect}`) // clear the effect
            }
        })
    })
})

      






const mobDies_extendPlayerEffect = {
    'frost_surge': {
        mob_effect: 'cofh_core:chilled',
        player_effects: ['minecraft:speed'],
        duration: 60, // in ticks
        chance: 0.20, // 20% chance to apply the effect
    },
    'gravemark': {
        mob_effect: 'minecraft:slowness',
        player_effects: ['projectile_damage:impact'],
        duration: 100, // in ticks
        method: 'ranged', // can be 'melee', 'ranged', or 'spell'
        chance: 0.20 // 60% chance to apply the effect
    },
}

Object.keys(mobDies_extendPlayerEffect).forEach(curio => {
    EntityEvents.death(event => {
        if (!event.source.player) return
        if (isAlly(event.source.player, event.entity)) return
        if (mobDies_extendPlayerEffect[curio].method) {
            let method = determineMethod(event.source)
            if (method != mobDies_extendPlayerEffect[curio].method) return
        }
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return
        let level = totemNBT
        if (mobDies_extendPlayerEffect[curio].chance) {
            let odds = mobDies_extendPlayerEffect[curio].chance
            if (Math.random() > odds * level) return // if the random number is greater than the odds, do not apply the effect
        }
        if (!event.entity.potionEffects.isActive(mobDies_extendPlayerEffect[curio].mob_effect)) return
        let player = event.source.player
        mobDies_extendPlayerEffect[curio].player_effects.forEach(effect => {
            applyEffect(player, effect, mobDies_extendPlayerEffect[curio].duration)
        })
    })
})



const effectOnBlock = {
    'stoneform': {
        effects: ['minecraft:resistance'],
        applyTo: 'defender', // can be 'attacker' or 'defender'
        type: 'duration', // can be 'duration' or 'amplifier'
        duration: 100, // in ticks
        chance: 0.15, // 25% chance to apply the effect
        shield_required: false,
    },
    'coward': {
        effects: ['minecraft:speed', 'minecraft:weakness'],
        applyTo: 'defender', // can be 'attacker' or 'defender'
        type: 'duration', // can be 'duration' or 'amplifier'
        duration: 200, // in ticks
        chance: 1.0, // 100% chance to apply the effect
        shield_required: false, // if true, the player must be blocking with a shield
    },
}

Object.keys(effectOnBlock).forEach(curio => {
    EntityEvents.hurt('player', event => {
        if (event.source == null) return // if the source is null, do not run
        if (event.source.actual == null) return // if the source is not a player, do not run
        if (!event.entity.blockUsingShield) return // only run if the player is blocking with a shield
        let totemNBT = skillTotemCheck(event.entity, `${curio}`)
        if (!totemNBT) return // only run if the player has the curio
        let level = totemNBT
        let chance = effectOnBlock[curio].chance * level
        if (Math.random() > chance) return // if the random number is greater than the chance, do not apply the effect
        let player = event.entity
        let attacker = event.source.actual
        let target = effectOnBlock[curio].applyTo; // can be 'attacker' or 'defender'
        effectOnBlock[curio].effects.forEach(effect => {
            if (target == 'defender') {
                applyEffect(player, effect, effectOnBlock[curio].duration, 1, `${curio}_player_effect`, player)
            } else if (target == 'attacker') {
                applyEffect(attacker, effect, effectOnBlock[curio].duration, 1, `${curio}_attacker_effect`, attacker)
            }
        })
    })
})


const stackingEffectOnAttack = {
    'slipstream': {
        effect: 'minecraft:speed',
        max_stacks: 3,
        method: 'ranged', 
        duration: 80, // in ticks
        hitsRemove: true, // if true, the stacks will be removed if you are hit
    },

    'giants_blood': {
        effect: 'runiclib:lesser_strength',
        max_stacks: 5,
        method: 'melee',
        duration: 60, // in ticks
        hitsRemove: false, // if true, the stacks will be removed if you are hit
    },
    'spellweaver': {
        effect: 'irons_spellbooks:echoing_strikes',
        max_stacks: 3,
        method: 'spell',
        duration: 80,
        hitsRemove: true
    }
}

Object.keys(stackingEffectOnAttack).forEach(curio => {
    EntityEvents.hurt(event => {
        if (!event.source.player) return
        if (stackingEffectOnAttack[curio].method) {
            let method = determineMethod(event.source)
            if (method != stackingEffectOnAttack[curio].method) return
        }
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return
        let level = totemNBT
        let player = event.source.player
        if (!player.potionEffects.isActive(stackingEffectOnAttack[curio].effect)) return
        let current_stack = player.potionEffects.getActive(stackingEffectOnAttack[curio].effect).amplifier
        if (!current_stack) current_stack = 0
        let max_stacks = stackingEffectOnAttack[curio].max_stacks
        let new_stack = current_stack + 1
        if (new_stack > max_stacks) new_stack = max_stacks
        let effect = stackingEffectOnAttack[curio].effect
        let duration = stackingEffectOnAttack[curio].duration * level
        applyStackingEffect(player, effect, duration, new_stack, `${curio}_stacks`)
    })

    EntityEvents.hurt('player', event => {
        let totemNBT = skillTotemCheck(event.entity, `${curio}`)
        if (!totemNBT) return
        if (!stackingEffectOnAttack[curio].hitsRemove) return // if hitsRemove is false, do not remove the stacks
        let player = event.entity
        Utils.server.runCommandSilent(`/effect clear ${player.uuid} ${stackingEffectOnAttack[curio].effect}`) // clear the effect
    })
})




const consumeStacksOnKill_applyAoe = {
    'poisonous_rot': {
        stackEffect: 'runiclib:venom',
        percent_per_stack: 0.10,
        applyEffects: ['fromtheshadows:plague', 'runiclib:venom'],
        radius: 15,
        duration_per_stack: 40, // duration in ticks
    },
    'bloody_shards': {
        stackEffect: 'mowziesmobs:frozen',
        percent_per_stack: 0.20,
        applyEffects: ['minecells:bleeding'],
        radius: 10,
        duration_per_stack: 80, // duration in ticks
    },
    'temporal_chains': {
        stackEffect: 'minecells:stunned',
        percent_per_stack: 0.15,
        applyEffects: ['minecraft:slowness'],
        radius: 15,
        duration_per_stack: 60, // duration in ticks
    },

}

Object.keys(consumeStacksOnKill_applyAoe).forEach(curio => {
    EntityEvents.death(event => {
        if (!event.source.player) return
        if (isAlly(event.source.player, event.entity)) return
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return
        let level = totemNBT
        let player = event.source.player
        let entity = event.entity
        if (!event.entity.potionEffects.isActive(consumeStacksOnKill_applyAoe[curio].stackEffect)) return
        //tell(`Entity: ${entity}, Player: ${player} Curio: ${curio} Level: ${level}`)
        let current_stack = entity.potionEffects.getActive(consumeStacksOnKill_applyAoe[curio].stackEffect).amplifier
        let odds = consumeStacksOnKill_applyAoe[curio].percent_per_stack * current_stack * level
        let effects = consumeStacksOnKill_applyAoe[curio].applyEffects
        let radius = consumeStacksOnKill_applyAoe[curio].radius
        let duration = consumeStacksOnKill_applyAoe[curio].duration_per_stack * current_stack * level

        let box = AABB.of(entity.x+radius, entity.y+radius, entity.z+radius, entity.x-radius, entity.y-radius, entity.z-radius)
        let entitiesWithin = event.level.getEntitiesWithin(box).filter(ent => ent.isMonster() && !ent.isDeadOrDying())
        entitiesWithin.forEach(ent => {
            if (Math.random() > odds) return // if the random number is greater than the odds, do not apply the effect
            effects.forEach(effect => {
                applyEffect(ent, effect, duration, level-1, `${curio}_aoe`)
            })
            //Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle born_in_chaos_v1:ritual ${ent.x} ${ent.y + 1} ${ent.z} 0.5 0.5 0.5 0.1 100`)
            Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound minecraft:entity.wither.spawn ambient ${player.username} ${ent.x} ${ent.y} ${ent.z} 1 1.5`)
        })
    })
})





const consumePlayerEffects_onKill_applyAoe = {
    'sacrifice': {
        player_effect: 'irons_spellbooks:charged',
        applyEffects: ['kubejs:hexed'],
        radius: 20,
        duration: 200,
        chance: 0.20
    },
    'esoteric_poison': {
        player_effect: 'irons_spellbooks:charged',
        applyEffects: ['fromtheshadows:plague'],
        radius: 15,
        duration: 200,
        chance: 0.15
    },
    'arcane_vent': {
        player_effect: 'irons_spellbooks:charged',
        applyEffects: ['minecraft:slowness'],
        radius: 12,
        duration: 100,
        chance: 0.25
    }
    

}


Object.keys(consumePlayerEffects_onKill_applyAoe).forEach(curio => {
    EntityEvents.death(event => {
        if (!event.source.player) return
        if (isAlly(event.source.player, event.entity)) return
        if (!event.source.player.potionEffects.isActive(consumePlayerEffects_onKill_applyAoe[curio].player_effect)) return
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return
        let level = totemNBT
        let player = event.source.player
        if (Math.random() > consumePlayerEffects_onKill_applyAoe[curio].chance * level) return // chance to apply the effect
        let radius = consumePlayerEffects_onKill_applyAoe[curio].radius
        let box = AABB.of(event.entity.x+radius, event.entity.y+radius, event.entity.z+radius, event.entity.x-radius, event.entity.y-radius, event.entity.z-radius)
        let entitiesWithin = event.level.getEntitiesWithin(box).filter(ent => ent.isMonster() && !ent.isDeadOrDying())
        let duration = consumePlayerEffects_onKill_applyAoe[curio].duration * level
        if (entitiesWithin.length == 0) return // if there are no entities within the radius, do not apply the effect
        entitiesWithin.forEach(ent => {
            consumePlayerEffects_onKill_applyAoe[curio].applyEffects.forEach(effect => {
                applyEffect(ent, effect, duration, level-1, `${curio}_aoe`)
            })
        })
        Utils.server.runCommandSilent(`/effect clear ${event.source.player.uuid} ${consumePlayerEffects_onKill_applyAoe[curio].player_effect}`) // clear the player effect after applying the new one
    })
})



const killMob_mobsCastSpell = {
    'dripping_maw': {
        mob_effect: 'kubejs:hexed',
        spell: 'fire_breath',
        radius: 15,
        chance: 0.15, 
    },
    'frost_chain': {
        mob_effect: 'cofh_core:chilled',
        spell: 'ray_of_frost',
        radius: 12,
        chance: 0.20
    }
}

Object.keys(killMob_mobsCastSpell).forEach(curio => {
    EntityEvents.death(event => {
        if (!event.source.player) return
        if (isAlly(event.source.player, event.entity)) return
        if (killMob_mobsCastSpell[curio].method) {
            let method = determineMethod(event.source)
            if (method != killMob_mobsCastSpell[curio].method) return
        }
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return
        let skilllevel = totemNBT
        if (!event.entity.potionEffects.isActive(killMob_mobsCastSpell[curio].mob_effect)) return
        if (Math.random() > killMob_mobsCastSpell[curio].chance * skilllevel) return // chance
        let radius = killMob_mobsCastSpell[curio].radius
        let box = AABB.of(event.entity.x+radius, event.entity.y+radius, event.entity.z+radius, event.entity.x-radius, event.entity.y-radius, event.entity.z-radius)
        let entitiesWithin = event.level.getEntitiesWithin(box).filter(ent => ent.isMonster() && !ent.isDeadOrDying() && !ent.player) // filter out players and dead entities
        // Add the initial enemy to the list and tag them
        let count = 0;
        let level = event.entity.potionEffects.getActive(killMob_mobsCastSpell[curio].mob_effect).amplifier
        let enemies = [];
        entitiesWithin.forEach(ent => {
            if (ent.isMonster()) {
                if (count > level*4) return;
                count++;
                enemies.push(ent)
            }
        });
        if (enemies.length == 0) return;
        enemies.forEach((enemy, index) => {
            let nextEnemy = enemies[index + 1];
            if (!nextEnemy) return;
                let spell = killMob_mobsCastSpell[curio].spell;
                let spells = []
                spells.push(spell)
                newCast(enemy, spells, nextEnemy, level, curio)

        })
    })
})



function castAtOtherMobs(event, spell, level, radius, count) {
    let box = AABB.of(event.entity.x+radius, event.entity.y+3, event.entity.z+radius, event.entity.x-radius, event.entity.y-3, event.entity.z-radius)
    let entitiesWithin = event.level.getEntitiesWithin(box).filter(ent => ent.isMonster() && ent.pickable)
    if (entitiesWithin.length == 0) return false// if there are no entities within the radius, do not cast the spell
    let step = 0
    let enemies = [];
    entitiesWithin.forEach(ent => {
        if (ent.isMonster()) {
            if (step > count) return;
            step++;
            enemies.push(ent)
        }
    });

    enemies.forEach((enemy, index) => {
        let nextEnemy = enemies[index + 1];
        let lastEnemy = enemies[index - 1];
        if (!nextEnemy && !lastEnemy) return false
        let spells = []
        spells.push(spell)
        if (nextEnemy) {
            castSpell(enemy, spells, nextEnemy, level, level, 'castAtOtherMobs')
            //newCast(enemy, spells, nextEnemy, level, curio)
        } else {
            castSpell(enemy, spells, lastEnemy, level, level, 'castAtOtherMobs')
            //newCast(enemy, spells, lastEnemy, level, curio)
        }
    })
    return true
}




const negativePlayerEffect_killMob_positivePlayerEffect = {
    'dormant_rage': {
        player_effect: 'minecraft:slowness',
        positive_effect: 'minecraft:strength',
        duration: 80, // in ticks
        chance: 1.0,
        stacking: true, // if true, the effect will stack with existing effects
    },
    'satiate': {
        player_effect: 'minecraft:hunger',
        positive_effect: 'minecraft:saturation',
        duration: 100, // in ticks
        chance: 1.0, // 50% chance to apply the effect
        stacking: false, // if true, the effect will stack with existing effects
    },
    'power_vacuum': {
        player_effect: 'minecraft:weakness',
        positive_effect: 'minecraft:strength',
        duration: 80,
        chance: 1.0,
        stacking: true
    }
}

Object.keys(negativePlayerEffect_killMob_positivePlayerEffect).forEach(curio => {
    EntityEvents.death(event => {
        if (!event.source.player) return
        if (isAlly(event.source.player, event.entity)) return
        if (negativePlayerEffect_killMob_positivePlayerEffect[curio].method) {
            let method = determineMethod(event.source)
            if (method != negativePlayerEffect_killMob_positivePlayerEffect[curio].method) return
        }
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return
        let level = totemNBT
        if (!event.source.player.potionEffects.isActive(negativePlayerEffect_killMob_positivePlayerEffect[curio].player_effect)) return
        if (Math.random() > negativePlayerEffect_killMob_positivePlayerEffect[curio].chance * level) return // chance to apply the effect
        let player = event.source.player
        let positive_effect = negativePlayerEffect_killMob_positivePlayerEffect[curio].positive_effect
        let duration = negativePlayerEffect_killMob_positivePlayerEffect[curio].duration
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound alexscaves:abyssmarine_glow_on ambient ${player.username} ${player.x} ${player.y+1} ${player.z} 1 1.5`)
        if (negativePlayerEffect_killMob_positivePlayerEffect[curio].stacking) {
            applyStackingEffect(player, positive_effect, duration, 1, `${curio}`) // always apply at least 1 stack
        } else {
            applyEffect(player, positive_effect, duration, level-1, `${curio}`);
        }
    })
})
        


EntityEvents.death('player', event => {
    let totemNBT = skillTotemCheck(event.entity, 'kubejs:mana_veil')
    if (!totemNBT) return
    let player = event.entity
    if (player.cooldowns.isOnCooldown('kubejs:mana_veil')) return // if the player is on cooldown, do not apply the effect
    let totalMana = event.entity.magicData.getMana()
    if (totalMana < 200) return // if the player has less than 200 mana, do not apply the effect
    // returned health is 1% for every 40 mana you have
    let returnedHealthPercent = Math.floor(totalMana / 40)
    let returnedHealth = player.maxHealth * (returnedHealthPercent / 100) // calculate the returned health based on the player's max health
    player.heal(returnedHealth) // heal the player for the returned health
    Utils.server.runCommandSilent(`/mana set ${player.username} 0`) // set the player's mana to 0
    player.cooldowns.addCooldown('kubejs:mana_veil', 1200) // add a cooldown of 30 seconds (600 ticks)
})

const playerHasEffect_mobKill_mobsCastSpell = {
    'shock_transfer': {
        player_effect: 'irons_spellbooks:charged',
        spell: 'ball_lightning',
        radius: 15, // radius to find mobs to cast the spell on
        chance: 0.15, // chance to cast the spell
        method: 'spell' // method to check for the spell
    }
}

Object.keys(playerHasEffect_mobKill_mobsCastSpell).forEach(curio => {
    EntityEvents.death(event => {
        if (!event.source.player) return
        if (isAlly(event.source.player, event.entity)) return
        if (!event.source.player.potionEffects.isActive(playerHasEffect_mobKill_mobsCastSpell[curio].player_effect)) return
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return
        let level = totemNBT
        if (playerHasEffect_mobKill_mobsCastSpell[curio].method) {
            let method = determineMethod(event.source)
            if (method != playerHasEffect_mobKill_mobsCastSpell[curio].method) return
        }
        if (Math.random() > playerHasEffect_mobKill_mobsCastSpell[curio].chance * level) return // chance to cast the spell
        let radius = playerHasEffect_mobKill_mobsCastSpell[curio].radius
        let box = AABB.of(event.entity.x+radius, event.entity.y+radius, event.entity.z+radius, event.entity.x-radius, event.entity.y-radius, event.entity.z-radius)
        let entitiesWithin = event.level.getEntitiesWithin(box).filter(ent => ent.isMonster() && !ent.isDeadOrDying())
        if (entitiesWithin.length == 0) return // if there are no entities within the radius, do not cast the spell
        entitiesWithin.forEach(ent => {
            let spell = playerHasEffect_mobKill_mobsCastSpell[curio].spell;
            let spells = []
            spells.push(spell)
            newCast(ent, spells, ent, 1, curio)
        })
        Utils.server.runCommandSilent(`/effect clear ${event.source.player.uuid} ${playerHasEffect_mobKill_mobsCastSpell[curio].player_effect}`) // clear the player effect after casting the spell
    })
})



// 'arcane_bargain' Killing a Hexed mob recharges 5% of your health and 5% of your mana per level of Hexed consumed. However, each level of hexed consumes adds a 10% chance to apply a negative effect to you. 
EntityEvents.death(event => {
    if (!event.source.player) return
    if (isAlly(event.source.player, event.entity)) return
    if (!event.entity.potionEffects.isActive('kubejs:hexed')) return
    let totemNBT = skillTotemCheck(event.source.player, 'arcane_bargain')
    if (!totemNBT) return
    let skilllevel = totemNBT
    let player = event.source.player
    let level = 1+ event.entity.potionEffects.getActive('kubejs:hexed').amplifier
    let mana = player.magicData.getMana()
    let health_recharge = 0.05 * level // 5% health recharge per level of hexed
    let mana_recharge = mana * 0.05 * level
    changeMana(player, mana_recharge) // recharge the player's mana
    player.heal(player.maxHealth * health_recharge) // recharge the player's health

    let hexed_effects = ['kubejs:hexed', 'runiclib:venom', 'minecells:bleeding', 'cofh_core:chilled', 'mowziesmobs:frozen', 'minecells:stunned', 'minecraft:slowness']
    let chance = 0.10 * level * skilllevel // 10% chance per level of hexed to apply the effects
    if (Math.random() > chance) return // 10% chance per level of hexed to apply the effects
    hexed_effects.forEach(effect => {
        applyEffect(player, effect, 100 * level, 1, `${curio}_player_effect`, player) // apply the effects for 5 seconds per level of hexed
    })
})



const leechOnHit_damageBased = {
    'siphoning_steel': {
        type: 'mana', // can be 'health' or 'mana'
        chance: 0.25, // 25% chance to apply the effect
        amount: 0.01, // 1% of the damage dealt will be leeched
        method: 'melee' // can be 'melee', 'ranged', or 'spell'
    }
}

Object.keys(leechOnHit_damageBased).forEach(curio => {
    EntityEvents.hurt(event => {
        if (!event.source.player) return
        if (leechOnHit_damageBased[curio].method) {
            let method = determineMethod(event.source)
            if (method != leechOnHit_damageBased[curio].method) return
        }
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return
        let level = totemNBT
        if (Math.random() > leechOnHit_damageBased[curio].chance * level) return // chance to apply the effect
        let player = event.source.player
        let damage = event.amount // damage dealt to the entity
        let amount = damage * leechOnHit_damageBased[curio].amount // calculate the amount to leech
        if (leechOnHit_damageBased[curio].type == 'mana') {
            changeMana(player, amount) // leech mana from the player
        } else if (leechOnHit_damageBased[curio].type == 'health') {
            player.heal(amount) // leech health from the player
        }
    })
})


const playerEffectOnSpellCast = {
    'arcane_dash': {
        effect: 'minecraft:speed',
        duration: 40, // in ticks
        amplifier: 1,
        stackable: true, // if true, the effect will stack with existing effects,
        max_stacks: 2,
        max_duration: 200, // max duration in ticks
    },
    'runeguard': {
        effect: 'minecraft:resistance',
        duration: 60,
        amplifier: 0,
        stackable: true,
        max_stacks: 2,
        max_duration: 200
    }
}


Object.keys(playerEffectOnSpellCast).forEach(curio => {
    PlayerEvents.spellOnCast(event => {
        let totemNBT = skillTotemCheck(event.player, `${curio}`)
        if (!totemNBT) return // only run if the player has the curio
        let level = totemNBT
        let player = event.player
        let effect = playerEffectOnSpellCast[curio].effect
        let duration = playerEffectOnSpellCast[curio].duration * level
        let amplifier = playerEffectOnSpellCast[curio].amplifier
        if (playerEffectOnSpellCast[curio].stackable) {
            let current_stack = player.potionEffects.getActive(effect)?.amplifier
            if (current_stack === undefined) current_stack = 0
            if (current_stack >= playerEffectOnSpellCast[curio].max_stacks) amplifier = 0

            let current_duration = player.potionEffects.getActive(effect)?.duration
            if (current_duration === undefined) current_duration = 0
            if (current_duration >= playerEffectOnSpellCast[curio].max_duration) duration = 0
            applyStackingEffect(player, effect, duration, amplifier, `${curio}`) // always apply at least 1 stack
        } else {
            applyEffect(player, effect, duration, level-1, `${curio}`);
        }
    })
})

const lowHealthGetEffect = {
    'second_wind': {
        effects: ['minecraft:speed'],
        duration: 80, // in ticks
        amplifier: 'level', // Amplifier 2
        cooldown: 30, // in ticks
        healthThreshold: 0.20 // 20% health threshold
    },
    'last_stand': {
        effects: ['minecraft:strength'],
        duration: 200, // in ticks
        amplifier: 3, //
        cooldown: 1200, // in ticks
        healthThreshold: 0.10 // 25% health threshold
    },
    'iron_will': {
        effects: ['minecraft:resistance'],
        duration: 160,
        amplifier: 2,
        cooldown: 1200,
        healthThreshold: 0.30
    }
}

Object.keys(lowHealthGetEffect).forEach(curio => {
    EntityEvents.hurt('player', event => {
        let player = event.entity
        if (player.cooldowns.isOnCooldown(`${curio}`)) return // if the player is on cooldown, do not apply the effect
        let totemNBT = skillTotemCheck(event.entity, `${curio}`)
        if (!totemNBT) return // only run if the player has the curio
        let level = totemNBT
        let healthThreshold = lowHealthGetEffect[curio].healthThreshold
        if (player.health > player.maxHealth * healthThreshold) return // only run if the player's health is below 25%
        let effects = lowHealthGetEffect[curio].effects
        let duration = lowHealthGetEffect[curio].duration * level
        let amplifier = lowHealthGetEffect[curio].amplifier
        if (amplifier == 'level') amplifier = totemNBT
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound alexscaves:abyssmarine_glow_on ambient ${player.username} ${player.x} ${player.y+1} ${player.z} 1 1.5`)
        effects.forEach(effect => {
            applyEffect(player, effect, duration, amplifier-1, `${curio}`);
        })
        player.cooldowns.addCooldown(`${curio}`, lowHealthGetEffect[curio].cooldown) // add a cooldown for the effect
    })
})



const playerSprints_attacks_applyEffect = {
    'sprint_shot': {
        effect: 'minecraft:speed',
        duration: 20, // in ticks
        amplifier: 1,
        method: 'ranged' // can be 'melee', 'ranged', or 'spell'
    },
}

Object.keys(playerSprints_attacks_applyEffect).forEach(curio => {
    EntityEvents.hurt(event => {
        if (!event.source.player) return
        if (!event.source.player.sprinting) return // only run if the player is sprinting
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return
        let level = totemNBT
        let method = determineMethod(event.source)
        if (method != playerSprints_attacks_applyEffect[curio].method) return // only run if the method matches
        let valid = true
        if (playerSprints_attacks_applyEffect[curio].chance) {
            if (Math.random() > playerSprints_attacks_applyEffect[curio].chance * level) {
                valid = false
            }
        }
        if (!valid) return
        let player = event.source.player
        let duration = playerSprints_attacks_applyEffect[curio].duration * level
        applyStackingEffect(player, playerSprints_attacks_applyEffect[curio].effect, duration, playerSprints_attacks_applyEffect[curio].amplifier, `${curio}`)
    })
})
        
const playerSprints_attacks_speedycasts = {
    'heavy_strike': {
        spell: 'flaming_strike',
        chance: 1.0,
        method: 'melee'
    }, 
    'windrunner': {
        spell: 'gust',
        chance: 0.25,
        method: 'melee'
    },
    'gaias_boon': {
        spell: 'earthquake',
        chance: 0.05,
        method: 'melee'
    },
    'frost_snare': {
        spell: 'frostwave',
        chance: 0.30,
        method: 'melee'
    },
    'stormwalker': {
        spell: 'chain_lightning',
        chance: 0.20,
        method: 'spell'
    },
}

Object.keys(playerSprints_attacks_speedycasts).forEach(curio => {
    EntityEvents.hurt(event => {
        if (!event.source.player) return
        if (!event.source.player.isSprinting()) return // only run if the player is sprinting
        //tell(event.source.player.totalMovementSpeed)
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return
        let level = totemNBT
        let method = determineMethod(event.source)
        if (method != playerSprints_attacks_speedycasts[curio].method) return // only run if the method matches
        if (Math.random() > playerSprints_attacks_speedycasts[curio].chance * level) return // if the random number is greater than the chance, do not cast the spell
        let player = event.source.player
        let spell = playerSprints_attacks_speedycasts[curio].spell
        speedyCast(player, spell, level)
    })
})


const playerCrouches_attacks_speedycasts = {
    'frostbarb': {
        spell: 'icicle',
        chance: 0.25,
        method: 'ranged',
        cooldown: 100
    },
    'raging_inferno': {
        spell: 'scorch',
        chance: 0.30,
        method: 'ranged',
        cooldown: 600
    },
}
Object.keys(playerCrouches_attacks_speedycasts).forEach(curio => {
    EntityEvents.hurt(event => {
        if (!event.source.player) return
        if (!event.source.player.isCrouching()) return // only run if the player is crouching
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return
        let level = totemNBT
        let method = determineMethod(event.source)
        if (method != playerCrouches_attacks_speedycasts[curio].method) return // only run if the method matches
        if (Math.random() > playerCrouches_attacks_speedycasts[curio].chance * level) return // if the random number is greater than the chance, do not cast the spell
        let player = event.source.player
        let spell = playerCrouches_attacks_speedycasts[curio].spell
        speedyCast(player, spell, level)
    })
})







const transferMonsterEffectsOnKill_applyPlayerEffect = {
    'dead_rush': {
        validMonsterEffects: ['kubejs:hexed', 'runiclib:venom', 'minecells:bleeding', 'cofh_core:chilled', 'fromtheshadows:plague'],
        applyEffect: 'minecraft:speed',
        duration: 80, // in ticks
        amplifier: 2,
        chance: 1.0,
    },
    'arcane_rebound': {
        validMonsterEffects: ['cofh_core:chilled', 'minecraft:slowness'],
        applyEffect: 'irons_spellbooks:charged',
        duration: 80,
        amplifier: 1,
        chance: 1.0
  }
}

Object.keys(transferMonsterEffectsOnKill_applyPlayerEffect).forEach(curio => {
    EntityEvents.death(event => {
        if (!event.source.player) return
        if (isAlly(event.source.player, event.entity)) return
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return
        let player = event.source.player
        let validEffects = transferMonsterEffectsOnKill_applyPlayerEffect[curio].validMonsterEffects
        let monsterEffects = event.entity.potionEffects.getActive().filter(effect => validEffects.includes(effect.id))
        if (monsterEffects.length == 0) return // if there are no valid effects, do not apply the effect
        if (Math.random() > transferMonsterEffectsOnKill_applyPlayerEffect[curio].chance) return // chance to apply the effect
        monsterEffects.forEach(effect => {
            let amp = event.entity.potionEffects.getActive(effect).amplifier
            let dur = event.entity.potionEffects.getActive(effect).duration
            applyEffect(player, effect, dur, amp, `${curio}_transferred`); // apply the monster effect to the player
        })
        applyEffect(player, transferMonsterEffectsOnKill_applyPlayerEffect[curio].applyEffect, transferMonsterEffectsOnKill_applyPlayerEffect[curio].duration, transferMonsterEffectsOnKill_applyPlayerEffect[curio].amplifier-1, `${curio}`);
    })
})


const useItem_applyEffect = {
    'stim_shot': {
        items: ['kubejs:lesser_health_elixir', 'kubejs:greater_health_elixir', 'kubejs:exalted_health_elixir'],
        effects: ['minecraft:speed'],
        duration: 100, // in ticks
        amplifier: 2,
        application: 'self',
        scales: true,
        particle: {
            id: 'minecells:protector',
            offset: [0.1, 0.1, 0.1], // offset from the entity position
            speed: 0.1,
            count: 100, // number of particles to spawn
        },
        sound: {
            id: 'irons_spellbooks:cast.generic.holy',
            volume: 1.0,
            pitch: 1.5
        }
    },
    'unbreakable_will': {
        items: ['kubejs:lesser_mana_elixir', 'kubejs:greater_mana_elixir', 'kubejs:exalted_mana_elixir'],
        effects: ['minecraft:resistance'],
        duration: 200, // in ticks
        amplifier: 1,
        application: 'self',
        scales: true,
        particle: {
            id: 'irons_spellbooks:dragon_fire',
            offset: [0.1, 0.1, 0.1], // offset from the entity position
            speed: 0.5,
            count: 200, // number of particles to spawn
        },
        sound: {
            id: 'irons_spellbooks:cast.generic.lightning',
            volume: 1.0,
            pitch: 0.75
        }
    },
    'commanders_concoction': {
        items: ['kubejs:lesser_health_elixir', 'kubejs:greater_health_elixir', 'kubejs:exalted_health_elixir'],
        effects: ['minecraft:strength'],
        duration: 200, // in ticks
        amplifier: 2,
        application: 'allies',
        radius: 15,
        scales: true,
        particle: {
            id: 'born_in_chaos_v1:chaosenergy',
            offset: [0.5, 0.5, 0.5], // offset from the entity position
            speed: 0.25,
            count: 25, // number of particles to spawn
        },
        sound: {
            id: 'alexsmobs:dropbear_hurt',
            volume: 1.0,
            pitch: 1.25
        }
    },
    'windlash_elixir': {
        items: ['kubejs:lesser_mana_elixir', 'kubejs:greater_mana_elixir', 'kubejs:exalted_mana_elixir'],
        effects: ['minecraft:levitation', ],
        duration: 20, // in ticks
        amplifier: 25,
        application: 'enemies',
        radius: 5,
        scales: true,
        particle: {
            id: 'minecells:protector',
            offset: [0.1, 0.1, 0.1], // offset from the entity position
            speed: 0.1,
            count: 100, // number of particles to spawn
        },
        sound: {
            id: 'irons_spellbooks:cast.generic.ender',
            volume: 1.0,
            pitch: 0.5
        }
    },
    'battle_march': {
        items: ['kubejs:lesser_mana_elixir','kubejs:greater_mana_elixir','kubejs:exalted_mana_elixir'],
        effects: ['minecraft:speed'],
        duration: 160,
        amplifier: 1,
        application: 'allies',
        radius: 12,
        scales: true,
        particle: { id: 'minecells:protector', offset: [0.2,0.2,0.2], speed: 0.15, count: 40 },
        sound: { id: 'irons_spellbooks:cast.generic.holy', volume: 1.0, pitch: 1.0 }
    }
}



function applyEffectFromItem(player, item, effectData, level) {
    if (!effectData.items.includes(item)) return // if the item is not in the list, do not apply the effect
    let effects = effectData.effects
    let duration = effectData.duration
    if (effectData.scales) {
        duration = effectData.duration * level
    }
    let amplifier = effectData.amplifier-1
    effects.forEach(effect => {
        if (effectData.application == 'self') {
            applyEffect(player, effect, duration, amplifier, `${item}_use_effect`);
            Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run particle ${effectData.particle.id} ${player.x} ${player.y+1} ${player.z} ${effectData.particle.offset[0]} ${effectData.particle.offset[1]} ${effectData.particle.offset[2]} ${effectData.particle.speed} ${effectData.particle.count}`)
            Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound ${effectData.sound.id} ambient ${player.username} ${player.x} ${player.y+1} ${player.z} ${effectData.sound.volume} ${effectData.sound.pitch}`)
        } else if (effectData.application == 'allies') {
            let radius = effectData.radius || 15 // default radius is 15
            let box = AABB.of(player.x+radius, player.y+radius, player.z+radius, player.x-radius, player.y-radius, player.z-radius)
            let entitiesWithin = player.level.getEntitiesWithin(box).filter(ent => isAlly(player, ent) && !ent.isDeadOrDying())
            entitiesWithin.forEach(ent => {
                applyEffect(ent, effect, duration, amplifier, `${item}_use_effect`);
                Utils.server.runCommandSilent(`/execute in ${ent.level.dimension} run particle ${effectData.particle.id} ${ent.x} ${ent.y+1} ${ent.z} ${effectData.particle.offset[0]} ${effectData.particle.offset[1]} ${effectData.particle.offset[2]} ${effectData.particle.speed} ${effectData.particle.count}`)
                Utils.server.runCommandSilent(`/execute in ${ent.level.dimension} run playsound ${effectData.sound.id} ambient ${ent.username} ${ent.x} ${ent.y+1} ${ent.z} ${effectData.sound.volume} ${effectData.sound.pitch}`)
            })
        } else if (effectData.application == 'enemies') {
            let radius = effectData.radius || 5 // default radius is 5
            let box = AABB.of(player.x+radius, player.y+radius, player.z+radius, player.x-radius, player.y-radius, player.z-radius)
            let entitiesWithin = player.level.getEntitiesWithin(box).filter(ent => ent.isMonster() && !ent.isDeadOrDying() && !ent.tags.contains('boss')) 
            Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound ${effectData.sound.id} ambient ${player.username} ${player.x} ${player.y+1} ${player.z} ${effectData.sound.volume} ${effectData.sound.pitch}`)
            entitiesWithin.forEach(ent => {
                applyEffect(ent, effect, duration, amplifier, `${item}_use_effect`);
                Utils.server.runCommandSilent(`/execute in ${ent.level.dimension} run particle ${effectData.particle.id} ${ent.x} ${ent.y+1} ${ent.z} ${effectData.particle.offset[0]} ${effectData.particle.offset[1]} ${effectData.particle.offset[2]} ${effectData.particle.speed} ${effectData.particle.count}`)
            })
        }
    })
}





const gainEffectWhileMounted = {
    'overdrive': {
        effect: 'minecraft:speed',
        duration: 80, // in ticks
        amplifier: 1, // Amplifier 1
        applyTo: ['self', 'mount']
    },
    'iron_rider': {
        effect: 'minecraft:resistance',
        duration: 80,
        amplifier: 0,
        applyTo: ['self','mount'],
        scales: true
    }
}

PlayerEvents.tick(event => {
    if (event.server.tickCount % 20 != 0) return // run every second
    let player = event.player
    if (player.rootVehicle == null) return // only run if the player is mounted
    Object.keys(gainEffectWhileMounted).forEach(curio => {
        let totemNBT = skillTotemCheck(player, `${curio}`)
        if (!totemNBT) return // only run if the player has the curio
        let level = totemNBT
        let amplifier = gainEffectWhileMounted[curio].amplifier
        if (!player.rootVehicle.tags.contains('tamed_beast')) return // only run if the player is mounted
        let effectData = gainEffectWhileMounted[curio]
        effectData.applyTo.forEach(target => {
            if (target == 'self') {
                if (gainEffectWhileMounted[curio].scales) {
                    amplifier = level - 1
                }
                applyEffect(player, effectData.effect, effectData.duration, amplifier, `${curio}:player_effect`, player) 
            } else if (target == 'mount') {
                let mount = player.rootVehicle
                if (gainEffectWhileMounted[curio].scales) {
                    amplifier = level - 1
                }
                applyEffect(mount, effectData.effect, effectData.duration, amplifier, `${curio}:mount_effect`, player) // apply the effect to the mount
            }
        })
    })
})





const attackEnemyWhileMounted_enemyGetsEffect = {
    'trample': {
        effect: 'minecraft:slowness',
        method: 'melee', 
        duration: 80, // in ticks
        amplifier: 1, // Amplifier 1
        applyTo: ['enemy'], // can be 'self', 'mount', or 'enemy'
    },
    'mangudai': {
        effect: 'minecraft:haste',
        method: 'ranged', 
        duration: 60, // in ticks
        amplifier: 1, // Amplifier 1
        applyTo: ['self'], // can be 'self', 'mount', or 'enemy'
    },
    'lancer': {
        effect: 'minecraft:weakness',
        method: 'melee',
        duration: 80,
        amplifier: 1,
        applyTo: ['enemy','self'] // enemy gets Weakness; self also gets Weakness amp=1 which is fine or change to Haste if you want a split entry
    },

}


EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (!event.source.player.rootVehicle) return // only run if the player is mounted
    let player = event.source.player
    Object.keys(attackEnemyWhileMounted_enemyGetsEffect).forEach(curio => {
        let totemNBT = skillTotemCheck(player, `${curio}`)
        if (!totemNBT) return // only run if the player has the curio
        let level = totemNBT
        if (attackEnemyWhileMounted_enemyGetsEffect[curio].method) {
            let method = determineMethod(event.source)
            if (method != attackEnemyWhileMounted_enemyGetsEffect[curio].method) return
        }
        let effectData = attackEnemyWhileMounted_enemyGetsEffect[curio]
        let duration = effectData.duration * level
        let amplifier = effectData.amplifier - 1
        if (effectData.applyTo.includes('enemy')) {
            let enemy = event.entity
            applyEffect(enemy, effectData.effect, duration, amplifier, 'attackEnemyWhileMounted:enemy_effect', player) // apply the effect to the enemy
        }
        if (effectData.applyTo.includes('self')) {
            applyEffect(player, effectData.effect, duration, amplifier, 'attackEnemyWhileMounted:player_effect', player) // apply the effect to the player
        }
        if (effectData.applyTo.includes('mount')) {
            let mount = player.rootVehicle
            applyEffect(mount, effectData.effect, duration, amplifier, 'attackEnemyWhileMounted:mount_effect', player) // apply the effect to the mount
        }
        
    })
})






const blockingGivesEffects = {
    'immovable_object': {
        effects: {
            'minecraft:resistance': {
                amplifier: 3, // Amplifier 3
                duration: 40, // in ticks
            },
            'minecraft:slowness': {
                duration: 40, // in ticks
                amplifier: 4, // Amplifier 3
            }
        }
    },
}
PlayerEvents.tick(event => {
    if (event.server.tickCount % 10 != 0) return // run every second
    if (!event.player.usingItem) return
    if(!isBlocking(event.player)) return // only run if the player is blocking
    let player = event.player
    Object.keys(blockingGivesEffects).forEach(curio => {
        let totemNBT = skillTotemCheck(player, `${curio}`)
        if (!totemNBT) return // only run if the player has the curio
        let effects = blockingGivesEffects[curio].effects
        Object.keys(effects).forEach(effect => {
            let effectData = effects[effect]
            applyEffect(player, effect, effectData.duration, effectData.amplifier, `${curio}:player_effect`, player) // apply the effect to the player
            if (player.rootVehicle) {
                applyEffect(player.rootVehicle, effect, effectData.duration, effectData.amplifier+1, `${curio}:mount_effect`, player) // apply the effect to the mount
            }
        })
    })
})





const nearMobsWithEffect_applyEffectToPlayer = {
    'open_wounds': {
        monster_effect: 'minecells:bleeding',
        player_effect: 'runiclib:lesser_strength',
        radius: 10, // radius to find monsters with the effect
        points_to_proc: 1,
        points_per_mob: 1, // 1 point per mob with the effect
        duration: 40,
        amplifier: 0, // Amplifier 0
        stacking: true, // if true, the effect will stack with existing effects
        max_amp: 5, // maximum amplifier for the effect
    },

}

PlayerEvents.tick(event => {
    if (event.server.tickCount % 20 != 0) return // run every second
    let player = event.player
    Object.keys(nearMobsWithEffect_applyEffectToPlayer).forEach(curio => {
        let totemNBT = skillTotemCheck(player, `${curio}`)
        if (!totemNBT) return // only run if the player has the curio
        let radius = nearMobsWithEffect_applyEffectToPlayer[curio].radius
        let box = AABB.of(player.x+radius, player.y+3, player.z+radius, player.x-radius, player.y-3, player.z-radius)
        let entitiesWithin = event.level.getEntitiesWithin(box).filter(ent => !isAlly(player, ent) && ent.isMonster() && ent.potionEffects.isActive(nearMobsWithEffect_applyEffectToPlayer[curio].monster_effect))
        let points = entitiesWithin.length * nearMobsWithEffect_applyEffectToPlayer[curio].points_per_mob // calculate the points based on the number of entities within the radius
        if (points < nearMobsWithEffect_applyEffectToPlayer[curio].points_to_proc) return // if there are no entities within the radius, do not apply the effect
        let amp = nearMobsWithEffect_applyEffectToPlayer[curio].amplifier
        if (nearMobsWithEffect_applyEffectToPlayer[curio].stacking) {
            amp = points/nearMobsWithEffect_applyEffectToPlayer[curio].points_to_proc // calculate the amplifier based on the points
        }
        if (amp > nearMobsWithEffect_applyEffectToPlayer[curio].max_amp) amp = nearMobsWithEffect_applyEffectToPlayer[curio].max_amp // cap the amplifier at the maximum value
        applyEffect(player, nearMobsWithEffect_applyEffectToPlayer[curio].player_effect, nearMobsWithEffect_applyEffectToPlayer[curio].duration, amp, `${curio}_player_effect`, player); // apply the effect to the player
    })
})



const entityHasEffect_combatRollAttack_applyEffect = {
    'inertial_reversal': {
        monster_effect: 'minecraft:slowness',
        effect: 'minecraft:speed',
        applyTo: 'player', // can be 'player' or 'enemy'
        duration: 100, // in ticks
        amplifier: 2, // Amplifier 1
        consume: true, // if true, the entitys effect will be consumed after applying the player effect
    },
    'frost_blast': {
        monster_effect: 'cofh_core:chilled',
        effect: 'mowziesmobs:frozen',
        applyTo: 'enemy', // can be 'player' or 'enemy'
        duration: 100, // in ticks
        amplifier: 1, // Amplifier 1
        consume: true, // if true, the entitys effect will be consumed after applying the player effect
    },
    'venom_whip': {
        monster_effect: 'runiclib:venom',
        effect: 'minecells:bleeding',
        applyTo: 'enemy',
        duration: 80,
        amplifier: 0,
        consume: false
    }
}

Object.keys(entityHasEffect_combatRollAttack_applyEffect).forEach(curio => {
    EntityEvents.hurt(event => {
        if (!event.source.player) return
        if (!event.source.player.potionEffects.isActive('kubejs:dashing')) return // Ensure the player has the rolling effect active
        if (!event.entity.potionEffects.isActive(entityHasEffect_combatRollAttack_applyEffect[curio].monster_effect)) return // only run if the entity has the effect
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return // only run if the player has the curio
        let level = totemNBT
        let player = event.source.player
        let effect = entityHasEffect_combatRollAttack_applyEffect[curio].effect
        let duration = entityHasEffect_combatRollAttack_applyEffect[curio].duration * level
        let amplifier = entityHasEffect_combatRollAttack_applyEffect[curio].amplifier-1 // Amplifier is 0 based
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound alexscaves:abyssmarine_glow_on ambient ${player.username} ${player.x} ${player.y+1} ${player.z} 1 1.5`)
        if (entityHasEffect_combatRollAttack_applyEffect[curio].applyTo == 'player') {
            applyEffect(player, effect, duration, amplifier, `${curio}:player_effect`, player) // apply the effect to the player
        } else if (entityHasEffect_combatRollAttack_applyEffect[curio].applyTo == 'enemy') {
            applyEffect(event.entity, effect, duration, amplifier, `${curio}:enemy_effect`, player) // apply the effect to the enemy
        }
        if (entityHasEffect_combatRollAttack_applyEffect[curio].consume) {
            Utils.server.runCommandSilent(`/effect clear ${event.entity.uuid} ${entityHasEffect_combatRollAttack_applyEffect[curio].monster_effect}`) // clear the entity's effect after applying the player effect
        }
    })
})





const attackEntity_dropProjectile = {
    'arrow_storm': {
        chance: 0.15, // 25% chance to drop the projectile
        method: 'ranged',
        projectile: 'minecraft:arrow', // the projectile to drop
        count: 4, // number of projectiles to drop
    },
    'conductive_arcane': {
        chance: 0.20, // 50% chance to drop the projectile
        method: 'spell',
        projectile: 'irons_spellbooks:ball_lightning', // the projectile to drop
        count: 2, // number of projectiles to drop
    }
}

EntityEvents.hurt(event => {
    if (!event.source.player) return
    Object.keys(attackEntity_dropProjectile).forEach(curio => {
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return // only run if the player has the curio
        let level = totemNBT
        if (attackEntity_dropProjectile[curio].method) {
            let method = determineMethod(event.source)
            if (method != attackEntity_dropProjectile[curio].method) return
        }
        if (Math.random() > attackEntity_dropProjectile[curio].chance * level) return // chance to drop the projectile
        let player = event.source.player
        let projectile = attackEntity_dropProjectile[curio].projectile
        let count = attackEntity_dropProjectile[curio].count
        handleHomingProjectile(projectile, player, event.entity, count)
    })
})






const blockAttack_speedyCast = {
    'pyroclasm': {
        chance: 0.15, // 25% chance to apply the effect
        spell: 'flaming_strike', // the spell to cast
        level: 3, // the level of the spell to cast
        attackType: 'melee' 
    },
    'voltage': {
        chance: 0.15, // 25% chance to apply the effect
        spell: 'lightning_bolt', // the spell to cast
        level: 2, // the level of the spell to cast
        attackType: 'ranged' 
    },
    'freezing_retreat': {
        chance: 1.0, // 100% chance to apply the effect
        spell: 'frost_step', // the spell to cast
        level: 2, // the level of the spell to cast
        attackType: 'ranged'
    },
    'arcane_barrage': {
        chance: 0.15, // 25% chance to apply the effect
        spell: 'magic_missile', // the spell to cast
        level: 3, // the level of the spell to cast
        attackType: 'melee',
        count: 3 // number of projectiles to cast
    },
    'thunder_riposte': {
        chance: 0.20,
        spell: 'chain_lightning',
        level: 2,
        attackType: 'melee'
    }
}


EntityEvents.hurt('player', event => {
    let player = event.entity
    if (!player.usingItem) return
    if(!isBlocking(player)) return // only run if the player is blocking
    Object.keys(blockAttack_speedyCast).forEach(curio => {
        let totemNBT = skillTotemCheck(player, `${curio}`)
        if (!totemNBT) return // only run if the player has the curio
        let skillLevel = totemNBT
        let method = determineMethod(event.source)
        if (method != blockAttack_speedyCast[curio].attackType) return // only run if the method is melee
        let chance = blockAttack_speedyCast[curio].chance * skillLevel
        if (Math.random() > chance) return // chance to apply the effect
        let spell = blockAttack_speedyCast[curio].spell
        let level = blockAttack_speedyCast[curio].level
        Utils.server.scheduleInTicks(1, () => {
            if (blockAttack_speedyCast[curio].count) {
                for (let i = 0; i < blockAttack_speedyCast[curio].count; i++) {
                    Utils.server.scheduleInTicks(i * 2, () => {
                        speedyCast(player, spell, level)
                    })
                }
            } else {
                speedyCast(player, spell, level)
            }
            
        })
        
    })
})


const effectOnSpellHit = {
    'frostbite': {
        spell: 'irons_spellbooks:ray_of_frost',
        effect: 'mowziesmobs:frozen',
        duration: 60,
        cooldown: 200
    },
    'searing_wound': {
        spell: 'flaming_strike',
        effect: 'minecells:bleeding',
        duration: 60,
        cooldown: 160
    }
}


EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (event.entity.tags.contains('boss')) return
    Object.keys(effectOnSpellHit).forEach(curio => {
        let spellSource = isSpellDamageSource(event.source)
        if (!spellSource) return
        let player = event.source.player
        if (player.cooldowns.isOnCooldown(`kubejs:${curio}`)) return
        if (player.magicData.castingSpellId != effectOnSpellHit[curio].spell) return
        let totemNBT = skillTotemCheck(player, `${curio}`)
        if (!totemNBT) return // only run if the player has the curio
        let level = totemNBT
        let duration = effectOnSpellHit[curio].duration * level
        applyAoeEffectOnEntity(player, event.entity, 3, effectOnSpellHit[curio].effect, duration, 0, 10, true)
        let cd = (effectOnSpellHit[curio].cooldown * 3) - (effectOnSpellHit[curio].cooldown * (level -1))
        player.cooldowns.addCooldown(`kubejs:${curio}`, cd)
    })
})



/**
 * Head Hunter: Enemies under 10% health have a 50% chance to be Culled. Player gains 3% of their max health as healing.
 */
EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (event.entity.health > event.entity.maxHealth / 10) return
    let curios = skillTotemCheck(event.source.player, 'head_hunter')
    if (!curios) return
    let chance = Math.random()
    if (chance > 0.50) return
    let level = curios
    let percent = 0.03 * level
    let player = event.source.player
    player.health += player.maxHealth * percent
    blood_harvest(player, event.entity, event)
})


PlayerEvents.spellOnCast(event => {
    if (event.spellId != 'frost_step') return
    let player = event.player
    let frost_step_curio = skillTotemCheck(player, 'frost_step')
    if (!frost_step_curio) return
    // 50% chance
    let chance = Math.random() * 100
    if (chance > 50) return
    player.cooldowns.removeCooldown('irons_spellbooks:frost_step')
})



// Frost Repulse: 5% chance per level to cast a spell that freezes all nearby enemies for 2 seconds
EntityEvents.hurt(event => {
    if (event.source == null) return
    if (event.source.actual == null) return
    if (!event.source.actual.isMonster()) return
    if (!event.entity.player) return
    let player = event.entity
    let frost_repulse_skill_gem = skillTotemCheck(player, 'frost_repulse')
    if (!frost_repulse_skill_gem) return
    let chance = Math.random() * 100
    if (chance > 5) return
    let dim = event.level.dimension
    Utils.server.runCommandSilent(`/execute in ${dim} run particle irons_spellbooks:snow_dust ${player.x} ${player.y} ${player.z} 0.5 0.5 0.5 0.1 500`)
    let box = AABB.of(player.getX() + 8, player.getY() + 8, player.getZ() + 8, player.getX() - 8, player.getY() - 8, player.getZ() - 8);
    let entitiesWithin = event.level.getEntitiesWithin(box).filter(e => e.isMonster() && !e.tags.contains('boss'))
    entitiesWithin.forEach(e => {
        let uuid = e.uuid
        Utils.server.runCommandSilent(`/effect give ${uuid} mowziesmobs:frozen 2 1 true`)
    });
})


EntityEvents.hurt('player', (event) => {
    if (!event.entity.blocking) return
    if (!event.entity.blockUsingShield) return
    let curio = skillTotemCheck(event.entity, 'bulwark')
    if (!curio) return
    if (event.entity.cooldowns.isOnCooldown('kubejs:bulwark')) return

    let check = physicalProjectileCheck(event.source)
    if (!check) return

    let projectile = event.source.immediate
    if (event.source.immediate == null) return
    let target = event.source.actual

    if (!projectile || !target) return // Ensure both exist

    let x = target.x - projectile.x
    let y = target.y - projectile.y
    let z = target.z - projectile.z

    projectile.setMotion(x * -2.5, (y+1) * -2.5, z * -2.5) // Reverse direction with some scaling
    let player = event.server.getPlayer(event.entity.uuid)
    player.cooldowns.addCooldown('kubejs:bulwark', 10)
})




/**
 * // Blacksmith: Crafted gear has a chance to have apoth affixes
function pickWeightedNumber() {
    let c = Math.pow(0.03, 1 / 6); // c such that c^6 = 0.01
    let r = Math.random(); // uniform random number in [0, 1]
    // Inverse transform sampling:
    let x = Math.log(1 - r * (1 - Math.pow(c, 6))) / Math.log(c);
    // Round to two decimals
    return Math.round(x * 100) / 100;
}

function getRareWeightedValue() {
  // Part 1: Integer from 0 to 6, rarer at higher values
  const intWeights = [40, 25, 15, 10, 6, 3, 1] // weights for 0 → 6
  const totalWeight = intWeights.reduce((a, b) => a + b, 0)
  const intRoll = Math.random() * totalWeight
  let intSum = 0
  let chosenInt = 0
  for (let i = 0; i < intWeights.length; i++) {
    intSum += intWeights[i]
    if (intRoll < intSum) {
      chosenInt = i
      break
    }
  }

  // Part 2: Float from 0.01 to 0.99, skewed lower
  // Use a power curve (square the random number to bias lower)
  const rawFloat = Math.random() ** 2  // Bias toward 0
  const chosenFloat = Math.max(0.01, Math.min(0.99, rawFloat)) // Clamp to [0.01, 0.99]

  // Part 3: Add them
  return chosenInt + chosenFloat
}



ItemEvents.crafted(event => {
    let curio = skillTotemCheck(event.player, 'blacksmith')
    if (!curio) return
    let num = getRareWeightedValue()
    event.player.setAttributeBaseValue('additional_attributes:apothic_crafting', num)
})

ServerEvents.tick(event => {
    if (event.server.tickCount % 60 != 0) return
    let num = getRareWeightedValue()
    for (let player of event.server.players) {
        let curio = skillTotemCheck(player, 'blacksmith')
        if (!curio) {
            player.setAttributeBaseValue('additional_attributes:apothic_crafting', 0)
        } else {
            player.setAttributeBaseValue('additional_attributes:apothic_crafting', num)
        }

    }
})


ServerEvents.tick(event => {
    if (event.server.tickCount % 10 != 0) return
    for (let player of event.server.players) {
        let lava_dancer = skillTotemCheck(player, 'lava_dancer')
        if (lava_dancer) {
            Utils.server.runCommandSilent(`/effect give ${player.username} runiclib:lava_walking 6 0 false`)
            if (player.blockStateOn.block.id == 'minecraft:lava') {
            }
        }

    }
})
 * 
 * 
 * 
 */



  



EntityEvents.hurt('player', (event) => {
    if (!event.source.toString().includes('fall')) return
    if (!event.entity.blocking) return
    let curios = skillTotemCheck(event.entity, 'aegis')
    if (!curios) return
    if (event.entity.pitch < 60) return
    event.cancel()
})



// Shattering Blow: Combat rolling into an enemy stuns them for 3 seconds
EntityEvents.hurt(event => {
    if (event.entity.tags.contains('boss')) return // Do not apply to bosses, they should not be stunned by this effect
    if (!event.source.player) return // Only apply for player sources
    if (!event.source.player.potionEffects.isActive('kubejs:dashing')) return // Ensure the player has the rolling effect active
    let curio = skillTotemCheck(event.source.player, 'shattering_blow') // Check for the shattering blow skill gem in the player's curios
    if (!curio) return
    let level = curio
    let duration = 60 * level // Duration scales with skill gem level
    applyEffect(event.entity, 'minecells:stunned', duration, 0, 'shattering_blow:stun_effect', event.source.player) // Apply the stunned effect to the entity
})



/**
 * 
 * Tunnel Vision: After killing an enemy, a random nearby enemy will be marked. Killing that enemy will grant a small but stackable haste and speed buff
 */






EntityEvents.death(event => {
    if (!event.source.player) return
    if (isAlly(event.source.player, event.entity)) return
    tunnelVisionHandler(event.source.player, event.entity)
})



function tunnelVisionHandler (player, target) {
    let curios = skillTotemCheck(player, 'tunnel_vision')
    if (!curios) return

    if (target.tags.contains('tunnel_vision')) {
        if (!player.persistentData.get('tunnel_vision_level')) {
            player.persistentData.putInt('tunnel_vision_level', 0)
        } else {
            player.persistentData['tunnel_vision_level']+=1
        }
        tunnel_vision_tick.set(player.username, 0)
        Utils.server.runCommandSilent(`/effect give ${player.uuid} minecraft:haste 5 ${player.persistentData['tunnel_vision_level']} true`)
        Utils.server.runCommandSilent(`/effect give ${player.uuid} minecraft:speed 5 ${player.persistentData['tunnel_vision_level']} true`)
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run stopsound ${player.username} * sanitydim:heartbeat`)
        Utils.server.runCommandSilent(`/execute in ${player.level.dimension} run playsound sanitydim:heartbeat ambient ${player.username} ${player.x} ${player.y} ${player.z} 1 1 1`)
    }

    
    let entities = target.level.getEntities().filter(entity => entity.distanceToEntity(player) < 20)
    let nearbyEntities = []
    entities.forEach(entity => {
        if (entity.isMonster() && entity != target) {
            nearbyEntities.push(entity.uuid)
        }
    })
    let randomEntity = nearbyEntities[Math.floor(Math.random()*nearbyEntities.length)]
    if (!randomEntity) return
    let newTarget = target.level.getEntity(randomEntity)
    global.applyGlow(newTarget, 'red', 100)
    //Utils.server.runCommandSilent(`/effect give ${newTarget.uuid} minecraft:glowing 5 0 true`)
    newTarget.tags.add('tunnel_vision')
    Utils.server.scheduleInTicks(100, e => {
        if (!newTarget.alive) return
        newTarget.tags.remove('tunnel_vision')
    })
}




let tunnel_vision_tick = new Map()
PlayerEvents.tick(event => {
    if (event.player.persistentData['tunnel_vision_level'] == 0) return
    let curios = skillTotemCheck(event.player, 'tunnel_vision')
    if (!curios) return

    const name = event.player.username
    let tickCount = tunnel_vision_tick.get(name)
    if (tickCount === undefined) tickCount = 0
    tickCount += 1
    tunnel_vision_tick.set(name, tickCount)

    if (tickCount < 100) return
    tunnel_vision_tick.delete(name)
    event.player.persistentData['tunnel_vision_level'] = 0
})

PlayerEvents.loggedOut(event => {
    tunnel_vision_tick.delete(event.player.username)
})

EntityEvents.death('player', event => {
    tunnel_vision_tick.delete(event.entity.username)
})


// Woods Walker: When an animal is killed, it drops double loot
EntityEvents.death(event => {
    if (!event.entity.animal) return
    if (!event.source.player) return
    if (isAlly(event.source.player, event.entity)) return
    let curio = skillTotemCheck(event.source.player, 'woods_walker')
    if (!curio) return
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run loot spawn ${event.entity.x} ${event.entity.y} ${event.entity.z} kill ${event.entity.uuid}`)
})




const parCoolMove_getEffect = {
    'speed_runner': {
        effect: 'minecraft:speed',
        duration: 20, // in ticks
        amplifier: 1, // Amplifier 1
    }
}

// Speed Runner: Doing ParCool moves grant a speed boost
PlayerEvents.tick(event => {
    if (!event.player.persistentData.getBoolean("parcool:just_stopped")) return
    event.player.persistentData.putBoolean("parcool:just_stopped", false)
    Object.keys(parCoolMove_getEffect).forEach(curio => {
        let totemNBT = skillTotemCheck(event.player, `${curio}`)
        if (!totemNBT) return // only run if the player has the curio
        let level = totemNBT
        let effectData = parCoolMove_getEffect[curio]
        let duration = effectData.duration * level
        applyEffect(event.player, effectData.effect, duration, effectData.amplifier, `${curio}:player_effect`, event.player) // apply the effect to the player
    })
})




/**
 * 
 * EntityEvents.spawned(event => {
    if (!event.entity.type.includes('arrow')) return
    let nbt = event.entity.nbt['Owner']
    Utils.server.players.forEach(p => {
        if (nbt.toString().includes(p.persistentData.player_uuid)) {
            let player = Utils.server.getPlayer(p.username)
            let arrow2 = event.level.createEntity(event.entity.type)
            
            let arrow3 = event.level.createEntity(event.entity.type)
            
            let motionx = event.entity.getMotionX
            let motiony = event.entity.getMotionY
            let motionz = event.entity.getMotionZ
            Utils.server.scheduleInTicks(1, e => {
                arrow2.setPosition(event.entity.x, event.entity.y, event.entity.z)
                arrow2.spawn()
                arrow2.setMotion(motionx, motiony, motionz)

            })
            Utils.server.scheduleInTicks(2, e => {
                arrow3.setPosition(event.entity.x, event.entity.y, event.entity.z)
                arrow3.spawn()
                arrow3.setMotion(motionx, motiony, motionz)
            })
        }
    })
})
 * 
 */


const playerLandsCrit_speedyCasts = {
    'frost_nova': {
        chance: 0.20, // 20% chance to cast the spell
        spell: 'frostwave', // the spell to cast
        spell_level: 1, // the level of the spell to cast,
        method: 'melee' // only trigger on melee crits
    },
    'flame_burst': {
        chance: 0.20, // 20% chance to cast the spell
        spell: 'flaming_strike', // the spell to cast
        spell_level: 1, // the level of the spell to cast,
        method: 'melee' // only trigger on melee crits
    },
}

EntityEvents.hurt(event => {
    if (!event.source.player) return
    if (event.source.class.toString().includes('SpellDamageSource')) return // do not trigger on spell crits
    if (!wasCrit(event.source.player)) return // only run if the player landed a crit
    Object.keys(playerLandsCrit_speedyCasts).forEach(curio => {
        let totemNBT = skillTotemCheck(event.source.player, `${curio}`)
        if (!totemNBT) return // only run if the player has the curio
        let player = event.source.player
        let level = totemNBT
        if (playerLandsCrit_speedyCasts[curio].method) {
            let method = determineMethod(event.source)
            //tell(method)
            if (method != playerLandsCrit_speedyCasts[curio].method) return
        }
        if (Math.random() > playerLandsCrit_speedyCasts[curio].chance * level) return // chance to cast the spell
        let spell = playerLandsCrit_speedyCasts[curio].spell
        let spell_level = playerLandsCrit_speedyCasts[curio].spell_level
        Utils.server.scheduleInTicks(1, () => {
            speedyCast(player, spell, spell_level)
        })
    })
})
