// Priority: 1000


/**
 * Checks all totem types and returns the level of the specified skill if found.
 *
 * @param player  The player to check.
 * @param nbtKey  The NBT key of the skill to look for on the totem Curio.
 * @returns       The skill level (1–3) if found, or false if not present.
 */
function skillTotemCheck(player, nbtKey) {
  let totems = [
    'kubejs:lesser_skill_totem',
    'kubejs:greater_skill_totem',
    'kubejs:exalted_skill_totem'
  ];
  for (let i = 0; i < totems.length; i++) {
    let totemId = totems[i];
    let totemItem = getCurioItem(player, totemId); // assumes you have a helper that fetches the actual ItemStack
    if (totemItem && !totemItem.empty && totemItem.nbt && totemItem.nbt.contains('skill_levels')) {
      let levelsTag = totemItem.nbt.get('skill_levels');
      if (levelsTag.contains(nbtKey)) {
        let lvl = levelsTag.getInt(nbtKey);
        if (!isNaN(lvl)) {
          return Math.max(1, Math.min(3, lvl));
        }
      }
    }
  }
  return false;
}





function totemSkillLevel(totItem, nbtKey) {
  // Default level
  let level = 1;

  if (!totItem || totItem.empty) return level;
  if (!totItem.nbt) return level;

  // skill_levels is a CompoundTag on the item's NBT
  if (!totItem.nbt.contains('skill_levels')) return level;

  let levelsTag = totItem.nbt.get('skill_levels'); // CompoundTag
  if (!levelsTag || !levelsTag.contains(nbtKey)) return level;

  // Clamp between 1 and 3
  level = levelsTag.getInt(nbtKey);
  if (isNaN(level)) return 1;
  return Math.max(1, Math.min(3, level));
}



