
const parcoolItems = {
    'breakfall': {
        itemID: 'kubejs:breakfall',
        skills: ['BreakfallReady', 'Roll', 'Tap'],
    },
    'catleap': {
        itemID: 'kubejs:catleap',
        skills: ['CatLeap'],
    },
    'vertical_wallrun': {
        itemID: 'kubejs:vertical_wallrun',
        skills: ['VerticalWallRun'],
    },
    'horizontal_wallrun': {
        itemID: 'kubejs:horizontal_wallrun',
        skills: ['HorizontalWallRun'],
    },
    'ledgegrab': {
        itemID: 'kubejs:ledgegrab',
        skills: ['ClimbUp', 'ClingToCliff'],
    },
    'crawl': {
        itemID: 'kubejs:crawl',
        skills: ['Crawl'],
    },
    'slide': {
        itemID: 'kubejs:slide',
        skills: ['Slide'],
    },
    'walljump': {
        itemID: 'kubejs:wall_jump',
        skills: ['WallJump', 'WallSlide'],
    }

}


function toggleParcoolSkills(player, itemKey) {
    if (!parcoolItems[itemKey]) {
        console.warn(`No parcool item found for key: ${itemKey}`);
        return;
    }

    if (player.persistentData[itemKey] == false || player.persistentData[itemKey] === undefined) {
        let itemData = parcoolItems[itemKey];

        itemData.skills.forEach(skill => {
            Utils.server.runCommandSilent(`/parcool limitation set individual of ${player.username} possibility ${skill} true`);
        });

        player.tell(`§7${itemKey.charAt(0).toUpperCase() + itemKey.slice(1)} §aActivated`);
        player.persistentData.putBoolean(itemKey, true);
    } else {
        let itemData = parcoolItems[itemKey];

        itemData.skills.forEach(skill => {
            Utils.server.runCommandSilent(`/parcool limitation set individual of ${player.username} possibility ${skill} false`);
        });

        player.tell(`§7${itemKey.charAt(0).toUpperCase() + itemKey.slice(1)} §cDeactivated`);
        player.persistentData.putBoolean(itemKey, false);
    }
}




Object.keys(parcoolItems).forEach(itemKey => {
    ItemEvents.rightClicked(parcoolItems[itemKey].itemID, event => {
        let player = event.player;
        toggleParcoolSkills(player, itemKey);
    });
})