let attribute_gemstones = {
    vanguard: {
      'attributeslib:current_hp_damage': { min: 0.0, max: 0.10, type: 'percent' },
      'attributeslib:fire_damage':       { min: 0.0, max: 10.0, type: 'int' },
      'attributeslib:crit_chance':         { min: 0.05, max: 0.30, type: 'percent' },
      'attributeslib:crit_damage':         { min: 1.5, max: 4.0, type: 'mult' },
      'minecraft:generic.attack_damage':   { min: 1.0, max: 2.0, type: 'mult' },
      'minecraft:generic.armor':           { min: 0.0, max: 12.0, type: 'int' },
      'minecraft:generic.armor_toughness':   { min: 0.0, max: 10.0, type: 'int' },
      'minecraft:generic.attack_speed':    { min: 4.0, max: 6.0, type: 'atp' },
    },
    marksman: {
      'projectile_damage:generic':         { min: 0.0, max: 10.0, type: 'int' },
      'attributeslib:arrow_velocity':      { min: 1.15, max: 2.1, type: 'mult' },
      'attributeslib:draw_speed':          { min: 1.0, max: 3.0, type: 'mult' },
      'attributeslib:cold_damage':         { min: 0.0, max: 10.0, type: 'int' },
      'minecraft:generic.attack_damage':   { min: 1.0, max: 2.0, type: 'mult' },
      'minecraft:generic.armor':           { min: 0.0, max: 12.0, type: 'int' },
      'minecraft:generic.armor_toughness':   { min: 0.0, max: 10.0, type: 'int' },
      'minecraft:generic.attack_speed':    { min: 4.0, max: 6.0, type: 'atp' },
    },
    warlock: {
      'irons_spellbooks:mana_regen':       { min: 1.0, max: 2.0, type: 'mult' },
      'irons_spellbooks:cast_time_reduction': { min: 1.0, max: 2.0, type: 'mult' },
      'irons_spellbooks:cooldown_reduction':  { min: 1.0, max: 2.0, type: 'mult' },
      'irons_spellbooks:spell_power':      { min: 1.0, max: 2.0, type: 'mult' },
      'minecraft:generic.attack_damage':   { min: 1.0, max: 2.0, type: 'mult' },
      'minecraft:generic.armor':           { min: 0.0, max: 12.0, type: 'int' },
      'minecraft:generic.armor_toughness':   { min: 0.0, max: 10.0, type: 'int' },
      'minecraft:generic.attack_speed':    { min: 4.0, max: 6.0, type: 'atp' },
    },
  };
  
  /**
   * Chooses a random attribute from the given type that hasn’t been upgraded 5 times.
   * We store each attribute’s current upgrade step in player.persistentData using the key "<attribute>_step".
   */
  function chooseAttribute(type, player) {
    let attributes = attribute_gemstones[type];
    let validAttributes = [];
    for (let attribute in attributes) {
      // Get the current upgrade step (default 0)
      let currentStep = player.persistentData[attribute + "_step"] || 0;
      if (currentStep < 10) {
        validAttributes.push(attribute);
      }
    }
    if (validAttributes.length === 0) {
      player.tell("All " + type + " attributes are fully upgraded!");
      return null;
    }
    let randomAttribute = validAttributes[Math.floor(Math.random() * validAttributes.length)];
    let step = player.persistentData[randomAttribute + "_step"] || 0;
    //Utils.server.tell(`${randomAttribute} chosen (current step: ${step}).`);
    return randomAttribute;
  }
  
  /**
   * Increases the chosen attribute by a fixed increment.
   */
  function incrementAttribute(player, type, attribute) {
    let attrInfo = attribute_gemstones[type][attribute];
    let constantIncrement = (attrInfo.max - attrInfo.min) / 10;
    let currentStep = player.persistentData[attribute + "_step"] || 0;
    let Attrtype = attrInfo.type;
    let string = ''
    if (currentStep >= 10) {
      //Utils.server.tell(attribute + " is already fully upgraded!");
      return;
    }
    
    let currentBase = player.getAttributeBaseValue(attribute);
    let newBase = currentBase + constantIncrement;
    
    // Update the attribute’s base value.
    player.setAttributeBaseValue(attribute, newBase);
    
    // Update our persistent data “step counter”
    player.persistentData[attribute + "_step"] = currentStep + 1;
    // AttrSplit is used to remove anything before the period in the attribute name
    let attrSplit = attribute.split('.').pop();
    let attrSplit2 = attrSplit.split(':').pop();
    // attrUnderscore is used to replace underscores with spaces in the attribute name.
    let attrUnderscore = attrSplit2.replace(/_/g, " ");
    // attributeName is the final attribute name with the first letter of each word capitalized.
    let attributeName = attrUnderscore.replace(/\b\w/g, c => c.toUpperCase());

    if (Attrtype == 'percent') {
      string = `§b${attributeName}: §c${(currentBase * 100).toFixed(2)}% §f-> §a${(newBase * 100).toFixed(2)}%§r`;
    } else if (Attrtype == 'mult') {
      string = `§b${attributeName}: §c${currentBase.toFixed(2)}x §f-> §a${newBase.toFixed(2)}x§r`;
    } else if (Attrtype == 'int') {
      string = `§b${attributeName}: §c${parseInt(currentBase)} §f-> §a${parseInt(newBase)}§r`;
    } else if (Attrtype == 'atp') {
      string = `§bAttack Speed: §a+15%`;
    }
    Utils.server.runCommandSilent(`/immersivemessages sendcustom ${player.username} {anchor:'CENTER_CENTER', wrap:1, size: 0.80, background:1, slideup:1, slideoutdown:1, y:50} 4 ${string}`);

  }
  
  /**
   * Handler for gemstone use.
   */
  function handleGemstone(event, type) {
    // Use event.player directly.
    let player = event.player;
    let attribute = chooseAttribute(type, player);
    if (attribute == null) return; // no valid attribute to upgrade
    incrementAttribute(player, type, attribute);
  }
  
  // Register event handlers for each gemstone.
  ItemEvents.rightClicked('kubejs:vanguard_gemstone', event => {
    handleGemstone(event, 'vanguard');
    event.item.count -= 1;
    Utils.server.runCommandSilent(`/execute in ${event.player.level.dimension} run playsound irons_spellbooks:cast.generic.evocation ambient ${event.player.username} ${event.player.x} ${event.player.y} ${event.player.z} 1 0.2`)
    Utils.server.runCommandSilent(`/execute in ${event.player.level.dimension} run particle irons_spellbooks:dragon_fire ${event.player.x} ${event.player.y+1} ${event.player.z} 0.5 0.5 0.5 0.1 25`);

  });
  
  ItemEvents.rightClicked('kubejs:marksman_gemstone', event => {
    handleGemstone(event, 'marksman');
    event.item.count -= 1;
    Utils.server.runCommandSilent(`/execute in ${event.player.level.dimension} run playsound irons_spellbooks:cast.generic.evocation ambient ${event.player.username} ${event.player.x} ${event.player.y} ${event.player.z} 1 0.2`)
    Utils.server.runCommandSilent(`/execute in ${event.player.level.dimension} run particle irons_spellbooks:wisp ${event.player.x} ${event.player.y+1} ${event.player.z} 0.5 0.5 0.5 0.1 25`);

  });
  
  ItemEvents.rightClicked('kubejs:warlock_gemstone', event => {
    handleGemstone(event, 'warlock');
    Utils.server.runCommandSilent(`/execute in ${event.player.level.dimension} run playsound irons_spellbooks:cast.generic.evocation ambient ${event.player.username} ${event.player.x} ${event.player.y} ${event.player.z} 1 0.2`)
    Utils.server.runCommandSilent(`/execute in ${event.player.level.dimension} run particle irons_spellbooks:electricity ${event.player.x} ${event.player.y+1} ${event.player.z} 0.5 0.5 0.5 0.1 25`);
    event.item.count -= 1;
  });
  

  /**
   * 
   *   PlayerEvents.respawned(event => {
    let player = event.player;

    // Loop through all attribute types (vanguard, marksman, warlock)
    for (let type in attribute_gemstones) {
        let attributes = attribute_gemstones[type];

        for (let attribute in attributes) {
            let attrInfo = attributes[attribute];
            let currentStep = player.persistentData[attribute + "_step"] || 0;

            if (currentStep > 0) {
                // Calculate the total increase based on how many times the attribute was upgraded
                let totalIncrease = (attrInfo.max - attrInfo.min) / 10 * currentStep;
                let newBase = player.getAttributeBaseValue(attribute) + totalIncrease;

                // Restore the attribute to its upgraded value
                player.setAttributeBaseValue(attribute, newBase);
            } else {
                // Reset the attribute to its default value
                player.setAttributeBaseValue(attribute, attrInfo.min);
            }
        }
    }
});


PlayerEvents.loggedIn(event => {
  let player = event.player;

  // Loop through all attribute types (vanguard, marksman, warlock)
  for (let type in attribute_gemstones) {
      let attributes = attribute_gemstones[type];

      for (let attribute in attributes) {
          let attrInfo = attributes[attribute];
          let currentStep = player.persistentData[attribute + "_step"] || 0;

          if (currentStep > 0) {
              // Calculate the total increase based on how many times the attribute was upgraded
              let totalIncrease = (attrInfo.max - attrInfo.min) / 10 * currentStep;
              let newBase = player.getAttributeBaseValue(attribute) + totalIncrease;

              // Restore the attribute to its upgraded value
              player.setAttributeBaseValue(attribute, newBase);
          }
      }
  }
});

   * 
   * 
   */
