
let gun_tiers = {
    common: [
        'blunderbuss', 
        'handcannon', 
        'repeating_musket', 
        'sawed_off_callwell',
        'pulsar', 
        'm22_waltz', 
        'defender_pistol', 
        'pax', 
        'bruiser',
        'soul_drummer'
        ],
    rare: [
        'cyclone',
        'laser_musket',
        'boomstick',
        'whispers',
        'echoes_2',
        'sculk_resonator',
        'bomb_lance',
        'gyrojet_pistol',
        'carapice',
        'cogloader',
        'shellurker',

    ],
    legendary: [
        'arc_worker',
        'plasgun', 
        'blasphemy', 
        'rocket_rifle',
        'raygun', 
        'gauss_rifle', 
        'inertial', 
        'howler_conversion', 
        'dozier_rl', 
        'astella', 
        'jackhammer', 
        'earths_corpse', 
        'rat_king_and_queen',
        'newborn_cyst',
    ]
}

let ammunition_crate = {
    common: {
        'scguns:compact_copper_round':32,
        'scguns:standard_copper_round':32,
        'scguns:ramrod_round':16,
        'scguns:hog_round':16,
        'scguns:compact_advanced_round':24,
        'scguns:advanced_round':16,
        'scguns:krahg_round':16,
        'scguns:beowulf_round':16,
        'scguns:gibbs_round':16,
        'scguns:shotgun_shell':16,
        'scguns:bearpack_shell':4,
        'scguns:blaze_fuel':8,
        'scguns:shock_cell': 4,
        'scguns:energy_cell': 4,
        'scguns:sculk_cell': 8,
        'scguns:shulkshot': 4,
        'scguns:microjet':4,
        'scguns:rocket':2,
    },
    //double the amount of ammo from common to rare
    rare: {
        'scguns:compact_copper_round':64,
        'scguns:standard_copper_round':64,
        'scguns:ramrod_round':32,
        'scguns:hog_round':32,
        'scguns:compact_advanced_round':48,
        'scguns:advanced_round':32,
        'scguns:krahg_round':32,
        'scguns:beowulf_round':32,
        'scguns:gibbs_round':32,
        'scguns:shotgun_shell':32,
        'scguns:bearpack_shell':8,
        'scguns:blaze_fuel':16,
        'scguns:shock_cell': 8,
        'scguns:energy_cell': 8,
        'scguns:sculk_cell': 16,
        'scguns:shulkshot': 8,
        'scguns:microjet':8,
        'scguns:rocket': 4,
    },
    // Triple the amount of ammo from rare to legendary
    legendary:  {
        'scguns:compact_copper_round': 192,
        'scguns:standard_copper_round': 192,
        'scguns:ramrod_round': 96,
        'scguns:hog_round': 96,
        'scguns:compact_advanced_round': 144,
        'scguns:advanced_round': 96,
        'scguns:krahg_round': 96,
        'scguns:beowulf_round': 96,
        'scguns:gibbs_round': 96,
        'scguns:shotgun_shell': 96,
        'scguns:bearpack_shell': 24,
        'scguns:blaze_fuel': 48,
        'scguns:shock_cell': 24,
        'scguns:energy_cell': 24,
        'scguns:sculk_cell': 48,
        'scguns:shulkshot': 24,
        'scguns:microjet': 24,
        'scguns:rocket': 12,
    },
}


/**
 * // add all guns to the appropriate loot tables
ServerEvents.genericLootTables(event => {
    event.addGeneric('gun_lootbox_common', lootTable => {
        lootTable.addPool(pool => {
            gun_tiers.common.forEach(gun => {
                pool.addItem('scguns:'+gun)
            })
        })
    })
    event.addGeneric('gun_lootbox_rare', lootTable => {
        lootTable.addPool(pool => {
            gun_tiers.rare.forEach(gun => {
                pool.addItem('scguns:'+gun)
            })
        })
    })
    event.addGeneric('gun_lootbox_legendary', lootTable => {
        lootTable.addPool(pool => {
            gun_tiers.legendary.forEach(gun => {
                pool.addItem('scguns:'+gun)
            })
        })
    })
})

ItemEvents.rightClicked('kubejs:common_gun_crate', event => {
    let player_username = event.player.username;
    Utils.server.runCommandSilent(`/execute at ${player_username} run loot spawn ~ ~1 ~ loot minecraft:gun_lootbox_common`);
    event.item.count -= 1;
    Utils.server.scheduleInTicks(100, e => {
        event.player.tags.remove('crate_opened')
    })
})

ItemEvents.rightClicked('kubejs:rare_gun_crate', event => {
    let player_username = event.player.username;
    Utils.server.runCommandSilent(`/execute at ${player_username} run loot spawn ~ ~1 ~ loot minecraft:gun_lootbox_rare`);
    event.item.count -= 1;
    Utils.server.scheduleInTicks(100, e => {
        event.player.tags.remove('crate_opened')
    })
})

ItemEvents.rightClicked('kubejs:legendary_gun_crate', event => {
    let player_username = event.player.username;
    Utils.server.runCommandSilent(`/execute at ${player_username} run loot spawn ~ ~1 ~ loot minecraft:gun_lootbox_legendary`);
    event.item.count -= 1;
    event.player.tags.add('crate_opened')
    Utils.server.scheduleInTicks(100, e => {
        event.player.tags.remove('crate_opened')
    })
})
 * 
 * 
 */




ServerEvents.genericLootTables(event => {
    // Function to create a loot table for a specific rarity
    function createLootTable(rarity, items) {
        event.addGeneric(`kubejs:chests/ammunition_crate_${rarity}`, lootTable => {
            lootTable.addPool(pool => {
                // Loop through each item in the rarity
                Object.keys(items).forEach(item => {
                    pool.addItem(item, 1, items[item]); // Add the item with a weight of 1 and the specified count
                });
                pool.rolls = 1; // Ensure only one item is rolled
            });
        });
    }
    createLootTable('common', {
        'scguns:compact_copper_round': 32,
        'scguns:standard_copper_round': 32,
        'scguns:ramrod_round': 16,
        'scguns:hog_round': 16,
        'scguns:compact_advanced_round': 24,
        'scguns:advanced_round': 16,
        'scguns:krahg_round': 16,
        'scguns:beowulf_round': 16,
        'scguns:gibbs_round': 16,
        'scguns:shotgun_shell': 16,
        'scguns:bearpack_shell': 4,
        'scguns:blaze_fuel': 8,
        'scguns:shock_cell': 4,
        'scguns:energy_cell': 4,
        'scguns:sculk_cell': 8,
        'scguns:shulkshot': 4,
        'scguns:microjet': 4,
        'scguns:rocket': 2,
    });

    createLootTable('rare', {
        'scguns:compact_copper_round': 64,
        'scguns:standard_copper_round': 64,
        'scguns:ramrod_round': 32,
        'scguns:hog_round': 32,
        'scguns:compact_advanced_round': 48,
        'scguns:advanced_round': 32,
        'scguns:krahg_round': 32,
        'scguns:beowulf_round': 32,
        'scguns:gibbs_round': 32,
        'scguns:shotgun_shell': 32,
        'scguns:bearpack_shell': 8,
        'scguns:blaze_fuel': 16,
        'scguns:shock_cell': 8,
        'scguns:energy_cell': 8,
        'scguns:sculk_cell': 16,
        'scguns:shulkshot': 8,
        'scguns:microjet': 8,
        'scguns:rocket': 4,
    });

    createLootTable('legendary', {
        'scguns:compact_copper_round': 192,
        'scguns:standard_copper_round': 192,
        'scguns:ramrod_round': 96,
        'scguns:hog_round': 96,
        'scguns:compact_advanced_round': 144,
        'scguns:advanced_round': 96,
        'scguns:krahg_round': 96,
        'scguns:beowulf_round': 96,
        'scguns:gibbs_round': 96,
        'scguns:shotgun_shell': 96,
        'scguns:bearpack_shell': 24,
        'scguns:blaze_fuel': 48,
        'scguns:shock_cell': 24,
        'scguns:energy_cell': 24,
        'scguns:sculk_cell': 48,
        'scguns:shulkshot': 24,
        'scguns:microjet': 24,
        'scguns:rocket': 12,
    });

})

ItemEvents.rightClicked('kubejs:common_ammo_crate', event => {
    let player_username = event.player.username;
    Utils.server.runCommandSilent(`/execute at ${player_username} run loot spawn ~ ~1 ~ loot kubejs:chests/ammunition_crate_common`);
    event.item.count -= 1;
})

ItemEvents.rightClicked('kubejs:rare_ammo_crate', event => {
    let player_username = event.player.username;
    Utils.server.runCommandSilent(`/execute at ${player_username} run loot spawn ~ ~1 ~ loot kubejs:chests/ammunition_crate_rare`);
    event.item.count -= 1;
})

ItemEvents.rightClicked('kubejs:legendary_ammo_crate', event => {
    let player_username = event.player.username;
    Utils.server.runCommandSilent(`/execute at ${player_username} run loot spawn ~ ~1 ~ loot kubejs:chests/ammunition_crate_legendary`);
    event.item.count -= 1;
})

// If the player picks up a gun while they have the 'crate_opened' tag, give the player a persistentdata boolean called gun+'_earned'



let common_gun_crate_insert = {
    'wrd:stronghold_loot_diamond': 25,
    'wrd:stronghold_loot_gold': 15,
    'wrd:stronghold_loot_iron': 8,
    'wrd:stronghold_loot_redstone': 5,
    'wrd:stronghold_loot_normal': 5,
    'wrd:treasure_chest_loot': 5,
    'wrd:chests/purpur_chest': 10,
    'wrd:fierytomb': 20,
    'wrd:chests/endpalacelootable': 15,
    'idas:chests/ancient_mines/minesbasic': 5,
    'idas:chests/castle/castle': 10,
    'idas:chests/castle/castle_throne': 30,
    'idas:chests/castle/castle_library': 10,
    'idas:chests/dread_citadel/dread_citadel_throne': 30,
    'idas:chests/dread_citadel/dread_citadel_library': 10,
    'idas:chests/haunted_manor/haunted_manor_library': 10,
    'idas:chests/haunted_manor/haunted_manor_tools': 5,
    'idas:chests/haunted_manor/haunted_manor_treasure': 10,
    'idas:chests/enchantingtower/enchantingtower_top': 10,
    'idas:chests/enchantingtower/enchantingtower_library': 3,
    'idas:chests/frozen_crypt/frozen_crypt': 10,
    'idas:chests/labyrinth/labyrinth_tomb': 10,
    'idas:chests/labyrinth/labyrinth_library': 3,
    'idas:chests/labyrinth/labyrinth_treasure': 5,
    'idas:chests/necromancers_spire/necromancers_spire': 10,
    'idas:chests/nexus/nexus': 5,
    'idas:chests/pillager_fortress/pillager_library': 3,
    'idas:chests/ruins_of_the_deep/ruins_tools': 3,
    'idas:chests/ruins_of_the_deep/ruins_treasure': 5,
    'idas:chests/tinkers_citadel/tinkers_citadel_vault': 10,
    'idas:chests/tinkers_workshop/tinkers_workshop/vault': 5,
    'idas:chests/treetop_tavern/treetop_tavern_tools': 3,
    'idas:chests/wizardtower/wizardtower_top': 10,
    'integrated_stronghold:chests/treasure': 10,
    'dungeons_arise_seven_seas:chests/corsair_corvette/corsair_corvette_treasure': 10,
    'dungeons_arise_seven_seas:chests/unicorn_galleon/unicorn_galleon_treasure': 10,
    'dungeons_arise_seven_seas:chests/victory_frigate/victory_frigate_treasure': 10,
    'mss:houses_uncommon': 20,
    'mss:houses_rare': 5,
    'mss:rare': 5,

}

let rare_gun_crate_insert = {
    'wrd:stronghold_loot_diamond': 15,
    'wrd:stronghold_loot_gold': 5,
    'wrd:stronghold_loot_iron': 4,
    'wrd:stronghold_loot_redstone': 2,
    'wrd:stronghold_loot_normal': 2,
    'wrd:treasure_chest_loot': 2,
    'wrd:chests/purpur_chest': 5,
    'wrd:fierytomb': 5,
    'wrd:chests/endpalacelootable': 10,
    'idas:chests/ancient_mines/minesbasic': 3,
    'idas:chests/castle/castle': 5,
    'idas:chests/castle/castle_throne': 15,
    'idas:chests/castle/castle_library': 3,
    'idas:chests/dread_citadel/dread_citadel_throne': 20,
    'idas:chests/dread_citadel/dread_citadel_library': 3,
    'idas:chests/haunted_manor/haunted_manor_library': 3,
    'idas:chests/haunted_manor/haunted_manor_tools': 2,
    'idas:chests/haunted_manor/haunted_manor_treasure': 4,
    'idas:chests/enchantingtower/enchantingtower_top': 4,
    'idas:chests/enchantingtower/enchantingtower_library': 3,
    'idas:chests/frozen_crypt/frozen_crypt': 5,
    'idas:chests/labyrinth/labyrinth_tomb': 5,
    'idas:chests/labyrinth/labyrinth_library': 3,
    'idas:chests/labyrinth/labyrinth_treasure': 5,
    'idas:chests/necromancers_spire/necromancers_spire': 5,
    'idas:chests/nexus/nexus': 4,
    'idas:chests/pillager_fortress/pillager_library': 2,
    'idas:chests/ruins_of_the_deep/ruins_tools': 2,
    'idas:chests/ruins_of_the_deep/ruins_treasure': 4,
    'idas:chests/tinkers_citadel/tinkers_citadel_vault': 7,
    'idas:chests/tinkers_workshop/tinkers_workshop/vault': 4,
    'idas:chests/treetop_tavern/treetop_tavern_tools': 2,
    'idas:chests/wizardtower/wizardtower_top': 5,
    'integrated_stronghold:chests/treasure': 5,
    'dungeons_arise_seven_seas:chests/corsair_corvette/corsair_corvette_treasure': 5,
    'dungeons_arise_seven_seas:chests/unicorn_galleon/unicorn_galleon_treasure': 5,
    'dungeons_arise_seven_seas:chests/victory_frigate/victory_frigate_treasure': 5,
    'mss:houses_uncommon': 5,
    'mss:houses_rare': 3,
    'mss:rare': 3,

}

let legendary_gun_crate_insert = {
    'wrd:stronghold_loot_diamond': 10,
    'wrd:stronghold_loot_gold': 3,
    'wrd:treasure_chest_loot': 1,
    'wrd:chests/purpur_chest': 3,
    'wrd:fierytomb': 3,
    'wrd:chests/endpalacelootable': 5,
    'idas:chests/ancient_mines/minesbasic': 1,
    'idas:chests/castle/castle': 1,
    'idas:chests/castle/castle_throne': 3,
    'idas:chests/castle/castle_library': 1,
    'idas:chests/dread_citadel/dread_citadel_throne': 3,
    'idas:chests/dread_citadel/dread_citadel_library': 1,
    'idas:chests/haunted_manor/haunted_manor_library': 1,
    'idas:chests/haunted_manor/haunted_manor_tools': 1,
    'idas:chests/haunted_manor/haunted_manor_treasure': 2,
    'idas:chests/enchantingtower/enchantingtower_top': 2,
    'idas:chests/enchantingtower/enchantingtower_library': 1,
    'idas:chests/frozen_crypt/frozen_crypt': 3,
    'idas:chests/labyrinth/labyrinth_tomb': 2,
    'idas:chests/labyrinth/labyrinth_library': 1,
    'idas:chests/labyrinth/labyrinth_treasure': 2,
    'idas:chests/necromancers_spire/necromancers_spire': 2,
    'idas:chests/nexus/nexus': 1,
    'idas:chests/pillager_fortress/pillager_library': 1,
    'idas:chests/ruins_of_the_deep/ruins_tools': 1,
    'idas:chests/ruins_of_the_deep/ruins_treasure': 2,
    'idas:chests/tinkers_citadel/tinkers_citadel_vault': 2,
    'idas:chests/tinkers_workshop/tinkers_workshop/vault': 2,
    'idas:chests/treetop_tavern/treetop_tavern_tools': 1,
    'idas:chests/wizardtower/wizardtower_top': 2,
    'integrated_stronghold:chests/treasure': 2,
    'dungeons_arise_seven_seas:chests/corsair_corvette/corsair_corvette_treasure': 2,
    'dungeons_arise_seven_seas:chests/unicorn_galleon/unicorn_galleon_treasure': 2,
    'dungeons_arise_seven_seas:chests/victory_frigate/victory_frigate_treasure': 2,
    'mss:houses_uncommon': 1,
    'mss:houses_rare': 2,
    'mss:rare': 3,
}

/**
* Object.entries(common_gun_crate_insert).forEach(([loottable, chance]) => {
LootJS.modifiers(event => {
    event
    .addLootTableModifier(loottable).pool((pool) => {
        pool.rolls([1, 1]);
        pool.randomChance(chance/100).addLoot('kubejs:common_gun_crate');
    })
})
})

Object.entries(rare_gun_crate_insert).forEach(([loottable, chance]) => {
LootJS.modifiers(event => {
    event
    .addLootTableModifier(loottable).pool((pool) => {
        pool.rolls([1, 1]);
        pool.randomChance(chance/100).addLoot('kubejs:rare_gun_crate');
    })
})
})

Object.entries(legendary_gun_crate_insert).forEach(([loottable, chance]) => {
LootJS.modifiers(event => {
    event
    .addLootTableModifier(loottable).pool((pool) => {
        pool.rolls([1, 1]);
        pool.randomChance(chance/100).addLoot('kubejs:legendary_gun_crate');
    })
})
})
* 
*/



