
/**
 * 
 * let apotheosis_loot = {
    common: 60,
    uncommon: 30,
    rare: 9,
    epic: 1
}


let valid_items = [
    'sword',
    'bow',
    'trident',
    'hammer',
    'staff',
    'dagger',
    'scythe',
    'spear',
    'halberd',
    'mace',
    'axe',
    'saber',
    'rapier',
    'flail',
    'knife',
    'katana',
    'lance',
    'tomahawk',
    'javelin',
    'boomerang',
    'chakram',
    'blade',
    'polearm',
    'modular,
    'helmet',
    'chestplate',
    'leggings',
    'boots',
]

let armor_items = [
    'helmet',
    'chestplate',
    'leggings',
    'boots',
]


PlayerEvents.tick(event => {
    if (event.player.mainHandItem.nbt == null) return
    if (event.player.mainHandItem.nbt.toString().includes('affix_data')) return
    //Utils.server.tell('affix')
    // check to see if the item id is in the weapon_items array
    weapon_items.forEach(weapon => {
        if (!event.player.mainHandItem.toString().includes(weapon)) return
        let chance = Math.floor(Math.random() * 100)
        let tier = ''
        if (chance <= apotheosis_loot.common) tier = 'common'
        if (chance <= apotheosis_loot.uncommon) tier = 'uncommon'
        if (chance <= apotheosis_loot.rare) tier = 'rare'
        if (chance <= apotheosis_loot.epic) tier = 'epic'
        Utils.server.runCommandSilent(`/execute as ${event.player.username} run apoth lootify apotheosis:${tier}`)
        return
    })

        
})

PlayerEvents.tick(event => {
    if (event.player.mainHandItem.nbt == null) return
    if (event.player.mainHandItem.nbt.toString().includes('affix_data')) return
    //Utils.server.tell('affix')
    // check to see if the item id is in the weapon_items array
    armor_items.forEach(armor => {
        if (!event.player.mainHandItem.toString().includes(armor)) return
        let chance = Math.floor(Math.random() * 100)
        let tier = ''
        if (chance <= apotheosis_loot.common) tier = 'common'
        if (chance <= apotheosis_loot.uncommon) tier = 'uncommon'
        if (chance <= apotheosis_loot.rare) tier = 'rare'
        if (chance <= apotheosis_loot.epic) tier = 'epic'
        Utils.server.runCommandSilent(`/execute as ${event.player.username} run apoth lootify apotheosis:${tier}`)
        return
    })

        
})
 */

let spark_colors = {
    'red': [0.5, 0.1, 0.1],
    'green': [0.1, 0.5, 0.1],
    'blue': [0.1, 0.5, 0.5],
    'purple': [0.3, 0.1, 1],
    'white': [1, 1, 1],
    'yellow': [1, 1, 0.1],
    'golden': [1, 0.8, 0.1],
}

let apoth_sparks = {
    'orb_of_corruption': ['red'],
    'orb_of_repentance': ['golden'],
    'orb_of_imbuement': ['purple'],
    'orb_of_ascension': ['red', 'blue'],
    'orb_of_sorcery': ['blue', 'green'],
    'orb_of_infusion': ['purple', 'blue'],
    'orb_of_reforging': ['purple', 'red'],
    'orb_of_dissonance': ['blue'],
    'orb_of_socketing': ['blue'],
    'orb_of_exaltation': ['green'],
    'sentient_stone': ['yellow'],
}




let apoth_rework_items = {
    additions: [
        'kubejs:orb_of_infusion',
        'kubejs:orb_of_imbuement',
        'kubejs:orb_of_socketing',
        'kubejs:empty_skill_totem',
    ], 
    changes: [
        'kubejs:orb_of_reforging',
        'kubejs:orb_of_dissonance',
    ],

    upgrades: [
        'kubejs:orb_of_ascension',
        'kubejs:orb_of_sorcery',
    ],

    chaos: [
        'kubejs:orb_of_corruption',
        'kubejs:orb_of_repentance',
    ],
    ultra_rare: [
        'kubejs:orb_of_exaltation',
        'kubejs:starlit_orb',
        'kubejs:orb_of_divinity',
    ],
}



let orbsAndTotemsDrop = {
    common: [
        'kubejs:boss_effigy',
        'kubejs:orb_of_infusion',
        'kubejs:orb_of_imbuement',
        'kubejs:empty_skill_totem',
    ],
    uncommon: [
        'kubejs:orb_of_knowledge',
        'kubejs:orb_of_rebirth',
        'kubejs:orb_of_ascension',
        'kubejs:orb_of_dissonance',
        'kubejs:orb_of_corruption',
        'kubejs:orb_of_discovery',
        'kubejs:orb_of_socketing',
        'kubejs:orb_of_severing',
        'apotheosis:sigil_of_withdrawal',
        'kubejs:orb_of_renewal',
    ],
    rare: [
        'kubejs:orb_of_sorcery',
        'kubejs:orb_of_reforging',
        'kubejs:orb_of_repentance',
        'kubejs:orb_of_binding',
        'kubejs:orb_of_fracturing',
        'kubejs:orb_of_revelation',
        'kubejs:orb_of_entropy',
        'kubejs:starlit_orb',
        'kubejs:orb_of_fate'
    ],
    epic: [
        'kubejs:orb_of_exaltation',
        'kubejs:orb_of_divinity',
    ],
}

function rollOrbsAndTotemsDrop(entity, mult) {
    let common_roll = Math.random()
    mult = Number(mult)
    //tell(common_roll + ' < ' + '0.08')
    let common_chance = 0.08 * mult
    if (common_roll < common_chance) {
        let common_item = orbsAndTotemsDrop.common[Math.floor(Math.random() * orbsAndTotemsDrop.common.length)]
        spawnItem(common_item, 1, entity)
    }

    let uncommon_roll = Math.random()
    let uncommon_chance = 0.05 * mult
    if (uncommon_roll < uncommon_chance) {
        let uncommon_item = orbsAndTotemsDrop.uncommon[Math.floor(Math.random() * orbsAndTotemsDrop.uncommon.length)]
        spawnItem(uncommon_item, 1, entity)
    }

    let rare_roll = Math.random()
    let rare_chance = 0.025 * mult
    if (rare_roll < rare_chance) {
        let rare_item = orbsAndTotemsDrop.rare[Math.floor(Math.random() * orbsAndTotemsDrop.rare.length)]
        spawnItem(rare_item, 1, entity)
    }

    let epic_roll = Math.random()
    let epic_chance = 0.0125 * mult
    if (epic_roll < epic_chance) {
        let epic_item = orbsAndTotemsDrop.epic[Math.floor(Math.random() * orbsAndTotemsDrop.epic.length)]
        spawnItem(epic_item, 1, entity)
    }
}

ServerEvents.genericLootTables(event => {
  Object.entries(orbsAndTotemsDrop).forEach(([rarity, drops]) => {
    event.addGeneric('kubejs:orbs/mob_drops/'+rarity, (table) => {
        table.addPool(pool => {
            drops.forEach(drop => {
                pool.addItem(drop)
            })
        })
    })
  })
})




/**
 * 
 * function rollApothReworkItemDrop(entity) {
    let additions_roll = Math.random()
    let changes_roll = Math.random()
    let upgrades_roll = Math.random()
    let chaos_roll = Math.random()
    let ultra_rare_roll = Math.random()

    let additions_item = apoth_rework_items.additions[Math.floor(Math.random() * apoth_rework_items.additions.length)]
    let changes_item = apoth_rework_items.changes[Math.floor(Math.random() * apoth_rework_items.changes.length)]
    let upgrades_item = apoth_rework_items.upgrades[Math.floor(Math.random() * apoth_rework_items.upgrades.length)]
    let chaos_item = apoth_rework_items.chaos[Math.floor(Math.random() * apoth_rework_items.chaos.length)]
    let ultra_rare_item = apoth_rework_items.ultra_rare[Math.floor(Math.random() * apoth_rework_items.ultra_rare.length)]

    if (additions_roll < 0.08) {
        spawnItem(additions_item, 1, entity)
    }
    if (changes_roll < 0.08) {
        spawnItem(changes_item, 1, entity)
    }
    if (upgrades_roll < 0.08) {
        spawnItem(upgrades_item, 1, entity)
    }
    if (chaos_roll < 0.08) {
        spawnItem(chaos_item, 1, entity)
    }
    if (ultra_rare_roll < 0.015) {
        spawnItem(ultra_rare_item, 1, entity)
    }
}
 */


EntityEvents.death(event => {
    if (event.source == null) return
    if (event.source.actual == null) return
    if (!event.entity.isMonster()) return
    if (isAlly(event.source.player, event.entity)) return
    if (!event.source.player) return
    rollOrbsAndTotemsDrop(event.entity, 0.35)
})
let activeTags = [
    'orb_of_exaltation_drop',
    'orb_of_sorcery_drop',
    'orb_of_ascension_drop',
    'orb_of_corruption_drop',
    'orb_of_repentance_drop',
    'orb_of_imbuement_drop',
    'orb_of_infusion_drop',
    'orb_of_reforging_drop',
    'common_socketing_chip_drop',
    'uncommon_socketing_chip_drop',
    'rare_socketing_chip_drop',
    'orb_of_dissonance_drop',
    'orb_of_socketing_drop',
    'orb_of_exaltation_drop',
    'sentient_stone_drop',
  ]




  /**
   * 
   * ItemEvents.dropped(event => {
    let player = event.player
    let itemName = event.item.toString()
  
    let isValidItem =
        apoth.lootify_valid.some(id => itemName.includes(id)) ||
        apoth.sockets_valid.some(id => itemName.includes(id)) ||
        isCurioItem(event.item)
  
    if (!isValidItem) return

  
    let valid_tag = null
  
    for (let tag of activeTags) {
      if (player.tags.contains(tag)) {
        valid_tag = tag
      } else {
        player.tags.remove(tag) // cleanup
      }
    }
  
    if (!valid_tag) return
    
    Utils.server.scheduleInTicks(8, () => {
      let newTag = valid_tag.replace('_drop', '')
  
      // Success
      player.tags.remove(valid_tag)       // remove drop tag
      player.tags.add(newTag)             // apply final activation tag
  
      //Utils.server.tell(`Granted tag: ${newTag}`)
  
      let { x, y, z } = event.itemEntity
      let dim = event.level.dimension
  
      for (let i = 0; i < 4; i++) {
        //event.level.spawnLightning(x, y, z, true)
      }

      let colors = apoth_sparks[newTag]
      let length = colors.length
      let quantity = 300/length
      colors.forEach(color => {
        let [r, g, b] = spark_colors[color]
        Utils.server.runCommandSilent(`/execute in ${dim} run particle irons_spellbooks:spark ${r} ${g} ${b} ${x} ${y} ${z} 0.2 0.3 0.2 0.2 ${quantity}`)
      })

      
      Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run playsound traveloptics:aqua_vortex_end ambient ${event.player.username} ${x} ${y} ${z} 1 2`)
      //Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run playsound createaddition:little_zap ambient ${event.player.username} ${x} ${y} ${z} 1 1.5`)

      
      event.itemEntity.setGlowing(true)
      Utils.server.runCommandSilent(`/execute in ${dim} run photon fx photon:tears_of_creation_item entity ${event.itemEntity.uuid}`)
    })
  })
   * 
   * 
   * 
   */



/**
 * 
 * 
 * 
 * 
 */
// 2% chance to drop a gem dust on monster death
EntityEvents.death(event => {
    if (event.level.day) return
    if (!event.entity.isMonster()) return
    if (!event.source.player) return
    if (isAlly(event.source.player, event.entity)) return
    // 2 percent chance
    let chance = Math.floor(Math.random() * 100)
    if (chance > 2) return
    Utils.server.runCommandSilent(`/execute in ${event.level.dimension} run loot spawn ${event.entity.x} ${event.entity.y} ${event.entity.z} loot minecraft:loot_boxes/gem_dust`)
})

let apoth = {
    'sentient_stone': {
        'common': 'apoth lootify apotheosis:common',
        'uncommon': 'apoth lootify apotheosis:uncommon',
        'rare': 'apoth lootify apotheosis:rare',
    },
    sockets_valid: [
        'sword',
        'bow',
        'trident',
        'hammer',
        'staff',
        'dagger',
        'scythe',
        'spear',
        'halberd',
        'mace',
        'axe',
        'saber',
        'rapier',
        'flail',
        'knife',
        'katana',
        'lance',
        'tomahawk',
        'javelin',
        'boomerang',
        'chakram',
        'blade',
        'polearm',
        'modular',
        'helmet',
        'chestplate',
        'leggings',
        'boots',
        'modular',
        'shovel',
        'pickaxe',
        'axe',
        'hoe',
        'shield',
        'crossbow',
        'hat',
    ],
    lootify_valid: [
        'sword',
        'bow',
        'trident',
        'hammer',
        'staff',
        'dagger',
        'scythe',
        'spear',
        'halberd',
        'mace',
        'axe',
        'saber',
        'rapier',
        'flail',
        'knife',
        'katana',
        'lance',
        'tomahawk',
        'javelin',
        'boomerang',
        'chakram',
        'blade',
        'polearm',
        'modular',
        'helmet',
        'chestplate',
        'leggings',
        'boots',
        'modular',
        'shovel',
        'pickaxe',
        'axe',
        'hoe',
        'shield',
        'crossbow',
        'hat',
    ],

}











