function isSkillTotem(item) {
  return item.id.startsWith('kubejs:') && item.id.includes('skill_totem')
}

function isSkillTotemOrb(item) {
  return global.validSkillTotemOrbs.includes(item.id)
}

function isAffixOrb(item) {
  return global.validAffixOrbs.includes(item.id)
}

function isMiscOrb(item) {
  return global.validMiscOrbs && global.validMiscOrbs.includes(item.id)
}



function shouldBlockCreative(player) {
  if (!player.isCreative()) return false

  // same debounce behavior as your code
  if (player.persistentData.getBoolean('creative_message') !== true) {
    player.tell('§7You need to be in §cSurvival mode§7 to use this.')
    player.persistentData.putBoolean('creative_message', true)
    Utils.server.scheduleInTicks(10, () => {
      player.persistentData.putBoolean('creative_message', false)
    })
  }
  return true
}

function getHoveredItem(player, screen) {
  let hovered = screen.hoveredSlot
  if (!hovered) return null
  return player.inventory.getItem(hovered.slot)
}

// ---------- main ----------
const GLFW = Java.loadClass('org.lwjgl.glfw.GLFW')
let wasShiftDown = false

ClientEvents.tick(event => {
  let screen = Client.screen
  if (!screen) return

  let screenClass = screen.class.toString()
  let isInventoryScreen =
    screenClass.includes('client.gui.screens.inventory') ||
    screenClass.includes('CuriosScreenV2')

  if (!isInventoryScreen) return
  let windowPtr = Client.getWindow().getWindow()
  let isShiftDown =
    GLFW.glfwGetKey(windowPtr, GLFW.GLFW_KEY_LEFT_SHIFT) === GLFW.GLFW_PRESS ||
    GLFW.glfwGetKey(windowPtr, GLFW.GLFW_KEY_RIGHT_SHIFT) === GLFW.GLFW_PRESS

  // only act on up -> down
  if (!isShiftDown || wasShiftDown) {
    wasShiftDown = isShiftDown
    return
  }

  let player = event.player
  let mouseItem = player.mouseItem
  if (!mouseItem) return
  let hoveredItem = getHoveredItem(player, screen)
  if (!hoveredItem) return

  // Rule list (easy to extend later)
  // Each rule returns { type, item } or null
  let rules = [
    () => (isSkillTotem(hoveredItem) && isSkillTotemOrb(mouseItem))
      ? { mouseItem: mouseItem, orbType: 'totem', itemSlot: screen.hoveredSlot.slot }
      : null,

    () => (isAffixOrb(mouseItem) && isValidApotheosisItem(hoveredItem))
      ? { mouseItem: mouseItem, orbType: 'affix', itemSlot: screen.hoveredSlot.slot }
      : null,

    () => (isMiscOrb(mouseItem))
      ? { mouseItem: mouseItem, orbType: 'misc', itemSlot: screen.hoveredSlot.slot }
      : null,
  ]

  let data = null
  for (let rule of rules) {
    data = rule()
    if (data) break
  }

  if (!data) {
    wasShiftDown = isShiftDown
    return
  }

  // creative block shared for both paths (same behavior)
  if (shouldBlockCreative(player)) {
    wasShiftDown = isShiftDown
    return
  }
  //player.tell(screen.hoveredSlot.slot)
  // data is now guaranteed populated and valid
  player.sendData('kubejs:modify_item', data)

  wasShiftDown = isShiftDown
})


const LootCategory = Java.loadClass("dev.shadowsoffire.apotheosis.adventure.loot.LootCategory");

/**
 * @param stack ItemStack
 * @return boolean – true if this item can have Apotheosis affixes
 */
function isValidApotheosisItem (stack) {
  if (!stack || stack.isEmpty()) return false;
  const cat = LootCategory.forItem(stack); // figures out sword/bow/armor/etc.
  return !cat.isNone(); // NONE = not affix-compatible
};
