/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util;

import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class TaskExecutor {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ScheduledExecutorService EXECUTOR = Executors.newScheduledThreadPool(20);

    public static void scheduleAtFixedRate(@NotNull Task task, long initialDelay, long period, @NotNull TimeUnit unit, boolean executeInMainThread) {
        ScheduledFuture[] future;
        future = new ScheduledFuture[]{EXECUTOR.scheduleAtFixedRate(() -> {
            Runnable r = () -> {
                try {
                    ScheduledFuture f = future[0];
                    if (f != null) {
                        task.run(f);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("[FANCYMENU] Error while trying to execute scheduled (fixed rate) task!", (Throwable)ex);
                }
            };
            if (executeInMainThread) {
                MainThreadTaskExecutor.executeInMainThread(r, MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
            } else {
                r.run();
            }
        }, initialDelay, period, unit)};
    }

    public static void schedule(@NotNull Task task, long delay, @NotNull TimeUnit unit, boolean executeInMainThread) {
        ScheduledFuture[] future;
        future = new ScheduledFuture[]{EXECUTOR.schedule(() -> {
            Runnable r = () -> {
                try {
                    ScheduledFuture f = future[0];
                    if (f != null) {
                        task.run(f);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("[FANCYMENU] Error while trying to execute scheduled task!", (Throwable)ex);
                }
            };
            if (executeInMainThread) {
                MainThreadTaskExecutor.executeInMainThread(r, MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
            } else {
                r.run();
            }
        }, delay, unit)};
    }

    public static void execute(@NotNull Runnable task, boolean executeInMainThread) {
        EXECUTOR.execute(() -> {
            Runnable r = () -> {
                try {
                    task.run();
                }
                catch (Exception ex) {
                    LOGGER.error("[FANCYMENU] Error while trying to execute task!", (Throwable)ex);
                }
            };
            if (executeInMainThread) {
                MainThreadTaskExecutor.executeInMainThread(r, MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
            } else {
                r.run();
            }
        });
    }

    @FunctionalInterface
    public static interface Task {
        public void run(@NotNull ScheduledFuture<?> var1);
    }
}

