/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.requirements.world.player;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.EditBoxSuggestions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class IsPlayerInDimensionRequirement
extends LoadingRequirement {
    private static final Logger LOGGER = LogManager.getLogger();

    public IsPlayerInDimensionRequirement() {
        super("is_player_in_dimension");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        try {
            if (value == null || value.trim().isEmpty()) {
                return false;
            }
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (level != null && player != null) {
                return value.equals(level.m_220362_().m_135782_().toString());
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to handle '" + this.getIdentifier() + "' loading requirement!", (Throwable)ex);
        }
        return false;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.m_118938_((String)"fancymenu.requirements.world.is_player_in_dimension", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.world.is_player_in_dimension.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.m_118938_((String)"fancymenu.requirements.categories.world", (Object[])new Object[0]);
    }

    @Override
    public String getValueDisplayName() {
        return I18n.m_118938_((String)"fancymenu.requirements.world.is_player_in_dimension.value", (Object[])new Object[0]);
    }

    @Override
    public String getValuePreset() {
        return "minecraft:overworld";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }

    @Override
    public void editValue(@NotNull Screen parentScreen, @NotNull LoadingRequirementInstance requirementInstance) {
        IsPlayerInDimensionValueConfigScreen s = new IsPlayerInDimensionValueConfigScreen(Objects.requireNonNullElse(requirementInstance.value, this.getValuePreset()), callback -> {
            if (callback != null) {
                requirementInstance.value = callback;
            }
            Minecraft.m_91087_().m_91152_(parentScreen);
        });
        Minecraft.m_91087_().m_91152_((Screen)s);
    }

    @NotNull
    private static List<ResourceLocation> getDimensionTypes() {
        ArrayList<ResourceLocation> types = new ArrayList<ResourceLocation>();
        try {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                level.m_9598_().m_255025_(Registries.f_256787_).m_255209_().forEach(dimensionTypeResourceKey -> types.add(dimensionTypeResourceKey.m_135782_()));
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to get dimension types for 'Is Player In Dimension' loading requirement!", (Throwable)ex);
        }
        return types;
    }

    public static class IsPlayerInDimensionValueConfigScreen
    extends StringBuilderScreen {
        @NotNull
        protected String value;
        protected CellScreen.TextInputCell textInput;
        protected EditBoxSuggestions suggestions;

        protected IsPlayerInDimensionValueConfigScreen(@NotNull String value, @NotNull Consumer<String> callback) {
            super((Component)Component.m_237115_((String)"fancymenu.elements.requirements.edit_value"), callback);
            this.value = value;
        }

        @Override
        protected void initCells() {
            this.addSpacerCell(20);
            String id = this.getValueString();
            this.addLabelCell((Component)Component.m_237115_((String)"fancymenu.requirements.world.is_player_in_dimension.value"));
            this.textInput = this.addTextInputCell(null, true, true).setText(id);
            this.addCellGroupEndSpacerCell();
            ArrayList<String> suggestionValues = new ArrayList<String>();
            IsPlayerInDimensionRequirement.getDimensionTypes().forEach(location -> suggestionValues.add(location.toString()));
            if (suggestionValues.isEmpty()) {
                suggestionValues.add(I18n.m_118938_((String)"fancymenu.requirements.world.is_player_in_dimension.suggestions.error", (Object[])new Object[0]));
            }
            this.suggestions = EditBoxSuggestions.createWithCustomSuggestions(this, this.textInput.editBox, EditBoxSuggestions.SuggestionsRenderPosition.ABOVE_EDIT_BOX, suggestionValues);
            UIBase.applyDefaultWidgetSkinTo(this.suggestions);
            this.textInput.editBox.m_94151_(s -> this.suggestions.m_93881_());
            this.addSpacerCell(20);
        }

        @Override
        public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            super.m_88315_(graphics, mouseX, mouseY, partial);
            this.suggestions.m_280540_(graphics, mouseX, mouseY);
        }

        @Override
        public boolean m_7933_(int $$0, int $$1, int $$2) {
            if (this.suggestions.m_93888_($$0, $$1, $$2)) {
                return true;
            }
            return super.m_7933_($$0, $$1, $$2);
        }

        public boolean m_6050_(double $$0, double $$1, double scrollDeltaY) {
            if (this.suggestions.m_93882_(scrollDeltaY)) {
                return true;
            }
            return super.m_6050_($$0, $$1, scrollDeltaY);
        }

        @Override
        public boolean m_6375_(double $$0, double $$1, int $$2) {
            if (this.suggestions.m_93884_($$0, $$1, $$2)) {
                return true;
            }
            return super.m_6375_($$0, $$1, $$2);
        }

        @Override
        @NotNull
        public String buildString() {
            return this.getValueString();
        }

        @NotNull
        protected String getValueString() {
            if (this.textInput != null) {
                return this.textInput.getText();
            }
            return this.value;
        }
    }
}

