/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnEntitySpawnedListener
extends AbstractListener {
    @Nullable
    private String cachedEntityKey;
    @Nullable
    private String cachedDistanceToPlayer;
    @Nullable
    private String cachedEntityPosX;
    @Nullable
    private String cachedEntityPosY;
    @Nullable
    private String cachedEntityPosZ;
    @Nullable
    private String cachedEntityUuid;
    @Nullable
    private String cachedDimensionKey;
    private boolean isSameDimensionAsPlayer;

    public OnEntitySpawnedListener() {
        super("entity_spawned");
    }

    public void onEntitySpawned(@Nullable String entityKey, @Nullable UUID entityUuid, double posX, double posY, double posZ, @Nullable String levelKey) {
        this.cachedEntityKey = entityKey;
        this.cachedEntityUuid = entityUuid != null ? entityUuid.toString() : null;
        this.cachedEntityPosX = Double.toString(posX);
        this.cachedEntityPosY = Double.toString(posY);
        this.cachedEntityPosZ = Double.toString(posZ);
        this.cachedDimensionKey = levelKey;
        this.cachedDistanceToPlayer = this.computeDistanceToPlayer(posX, posY, posZ, levelKey);
        this.notifyAllInstances();
    }

    @Nullable
    private String computeDistanceToPlayer(double posX, double posY, double posZ, @Nullable String levelKey) {
        boolean sameDimension;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null) {
            this.isSameDimensionAsPlayer = false;
            return null;
        }
        String playerLevelKey = minecraft.f_91074_.m_9236_() != null ? minecraft.f_91074_.m_9236_().m_46472_().m_135782_().toString() : null;
        this.isSameDimensionAsPlayer = sameDimension = levelKey != null && playerLevelKey != null && playerLevelKey.equals(levelKey) || levelKey == null && playerLevelKey == null;
        if (!sameDimension) {
            return "-1";
        }
        Vec3 playerPos = minecraft.f_91074_.m_20182_();
        double distance = playerPos.m_82554_(new Vec3(posX, posY, posZ));
        if (Double.isFinite(distance)) {
            return Double.toString(distance);
        }
        return null;
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("entity_key", () -> this.cachedEntityKey != null ? this.cachedEntityKey : "ERROR"));
        list.add(new AbstractListener.CustomVariable("distance_to_player", () -> this.cachedDistanceToPlayer != null ? this.cachedDistanceToPlayer : "0"));
        list.add(new AbstractListener.CustomVariable("entity_pos_x", () -> this.cachedEntityPosX != null ? this.cachedEntityPosX : "0"));
        list.add(new AbstractListener.CustomVariable("entity_pos_y", () -> this.cachedEntityPosY != null ? this.cachedEntityPosY : "0"));
        list.add(new AbstractListener.CustomVariable("entity_pos_z", () -> this.cachedEntityPosZ != null ? this.cachedEntityPosZ : "0"));
        list.add(new AbstractListener.CustomVariable("entity_uuid", () -> this.cachedEntityUuid != null ? this.cachedEntityUuid : "ERROR"));
        list.add(new AbstractListener.CustomVariable("dimension_key", () -> this.cachedDimensionKey != null ? this.cachedDimensionKey : "UNKNOWN"));
        list.add(new AbstractListener.CustomVariable("is_same_dimension_as_player", () -> Boolean.toString(this.isSameDimensionAsPlayer)));
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.m_237115_((String)"fancymenu.listeners.on_entity_spawned");
    }

    @Override
    @NotNull
    public List<Component> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_entity_spawned.desc", new String[0]));
    }
}

