/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnChatMessageSentListener
extends AbstractListener {
    @Nullable
    private String lastMessageString;
    @Nullable
    private String lastMessageJson;

    public OnChatMessageSentListener() {
        super("chat_message_sent");
    }

    public void onChatMessageSent(@NotNull Component message) {
        this.lastMessageString = message.getString();
        this.lastMessageJson = this.serializeComponent(message);
        this.notifyAllInstances();
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("chat_message_string", () -> this.lastMessageString != null ? this.lastMessageString : "ERROR"));
        list.add(new AbstractListener.CustomVariable("chat_message_component", () -> this.lastMessageJson != null ? this.lastMessageJson : "ERROR"));
    }

    @NotNull
    private String serializeComponent(@NotNull Component component) {
        return Component.Serializer.m_130703_((Component)component);
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.m_237115_((String)"fancymenu.listeners.on_chat_message_sent");
    }

    @Override
    @NotNull
    public List<Component> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_chat_message_sent.desc", new String[0]));
    }
}

