/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.state;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.util.TESClientUtil;
import net.tslat.tes.core.particle.TESParticleManager;
import net.tslat.tes.core.state.EntityState;
import org.jetbrains.annotations.Nullable;

public final class TESEntityTracking {
    private static final Int2ObjectOpenHashMap<EntityState> ENTITY_STATES = new Int2ObjectOpenHashMap(50);
    private static List<LivingEntity> ENTITIES_TO_RENDER = new ObjectArrayList();
    private static final IntSet RENDERED_NAMES = new IntOpenHashSet();

    public static void accountForEntity(LivingEntity entity) {
        ENTITY_STATES.compute(entity.m_19879_(), (key, value) -> {
            if (entity.m_20199_().anyMatch(passenger -> passenger == Minecraft.m_91087_().f_91074_) && !TESAPI.getConfig().inWorldHudForSelf()) {
                return null;
            }
            if (entity.m_6095_().m_204039_(TESConstants.NO_TES_HANDLING)) {
                return null;
            }
            if (TESClientUtil.getClosestEntityPosition((Entity)entity).m_82557_(TESClientUtil.getCameraPosition()) > Mth.m_144952_((double)TESAPI.getConfig().getEntityTrackingDistance())) {
                return null;
            }
            return value == null ? new EntityState(entity) : value;
        });
    }

    public static void tick() {
        TESParticleManager.clearClaims();
        ObjectIterator iterator = ENTITY_STATES.values().iterator();
        while (iterator.hasNext()) {
            EntityState state = (EntityState)iterator.next();
            if (!state.isValid()) {
                iterator.remove();
                continue;
            }
            state.tick();
        }
    }

    public static void addEntityToRender(LivingEntity entity) {
        ENTITIES_TO_RENDER.add(entity);
    }

    @Nullable
    public static EntityState getStateForEntity(LivingEntity entity) {
        return TESEntityTracking.getStateForEntityId(entity.m_19879_());
    }

    @Nullable
    public static EntityState getStateForEntityId(int id) {
        return (EntityState)ENTITY_STATES.get(id);
    }

    public static List<LivingEntity> getEntitiesToRender() {
        List<LivingEntity> entities = ENTITIES_TO_RENDER;
        ENTITIES_TO_RENDER = new ObjectArrayList(ENTITIES_TO_RENDER.size());
        RENDERED_NAMES.clear();
        return entities;
    }

    public static boolean wasNameRendered(int entityId) {
        return RENDERED_NAMES.contains(entityId);
    }

    public static void markNameRendered(LivingEntity entity) {
        RENDERED_NAMES.add(entity.m_19879_());
    }
}

