/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.mixin;

import com.legacy.structure_gel.api.structure.StructureAccessHelper;
import com.legacy.structure_gel.api.structure.base.IPieceBuilderModifier;
import com.legacy.structure_gel.core.mixin.ChunkAccessMixin;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Structure.class})
public class StructureMixin {
    @Inject(at={@At(value="HEAD")}, method={"generate"}, cancellable=true)
    private void checkDimension(RegistryAccess registryAccess, ChunkGenerator chunkGen, BiomeSource biomeSource, RandomState randomState, StructureTemplateManager structureTemplateManager, long levelSeed, ChunkPos chunkPos, int refs, LevelHeightAccessor levelHeight, Predicate<Holder<Biome>> biomeTest, CallbackInfoReturnable<StructureStart> callback) {
        ChunkAccessMixin.Access access;
        LevelHeightAccessor levelHeightAccessor;
        boolean validDim = true;
        if (levelHeight instanceof ChunkAccessMixin.Access && (levelHeightAccessor = (access = (ChunkAccessMixin.Access)levelHeight).getHeightAccessor()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelHeightAccessor;
            validDim = StructureAccessHelper.isValidDimension(registryAccess.m_175515_(Registries.f_256944_).m_7854_((Object)((Structure)this)), (ResourceKey<Level>)level.m_46472_());
        }
        if (!validDim) {
            callback.setReturnValue((Object)StructureStart.f_73561_);
        }
    }

    @ModifyVariable(at=@At(value="STORE"), method={"generate"})
    private StructurePiecesBuilder generateHook(StructurePiecesBuilder pieceBuilder, RegistryAccess registryAccess, ChunkGenerator chunkGen, BiomeSource biomeSource, RandomState randomState, StructureTemplateManager structureTemplateManager, long levelSeed, ChunkPos chunkPos, int refs, LevelHeightAccessor levelHeight, Predicate<Holder<Biome>> biomeTest) {
        Structure structure = (Structure)this;
        if (structure instanceof IPieceBuilderModifier) {
            IPieceBuilderModifier modifier = (IPieceBuilderModifier)structure;
            modifier.modifyPieceBuilder(pieceBuilder, new Structure.GenerationContext(registryAccess, chunkGen, biomeSource, randomState, structureTemplateManager, levelSeed, chunkPos, levelHeight, biomeTest));
        }
        return pieceBuilder;
    }
}

