/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.cardiac.common.entities;

import it.hurts.octostudios.cardiac.common.init.ConfigRegistry;
import it.hurts.octostudios.cardiac.common.init.SoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class LifeOrb
extends Entity {
    private static final EntityDataAccessor<Float> LIFE = SynchedEntityData.m_135353_(LifeOrb.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public LifeOrb(EntityType<? extends LifeOrb> type, Level level) {
        super(type, level);
    }

    public float getMaxLife() {
        return (float)ConfigRegistry.CONFIG.getMaxOrbHealth();
    }

    public float getLife() {
        return ((Float)this.m_20088_().m_135370_(LIFE)).floatValue();
    }

    public void setLife(float life) {
        this.m_20088_().m_135381_(LIFE, (Object)Float.valueOf(life));
    }

    public int getStage() {
        int stages = 5;
        return Mth.m_14045_((int)(this.getLife() <= 1.0f ? 1 : (int)Math.ceil(Math.min(this.getLife() / (this.getMaxLife() / (float)Math.max(1, stages - 1)) + 1.0f, (float)stages))), (int)1, (int)stages);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
        }
        if (!this.m_9236_().m_45772_(this.m_20191_())) {
            this.m_20314_(this.m_20185_(), (this.m_20191_().f_82289_ + this.m_20191_().f_82292_) / 2.0, this.m_20189_());
        }
        if (this.f_19797_ >= 20 && this.getLife() < this.getMaxLife()) {
            for (LifeOrb orb : this.m_9236_().m_45976_(LifeOrb.class, this.m_20191_().m_82400_(0.25))) {
                if (orb.m_20148_().equals(this.m_20148_()) || orb.m_213877_() || orb.getLife() >= this.getMaxLife()) continue;
                float diff = this.getMaxLife() - this.getLife();
                if (orb.getLife() < diff) {
                    this.setLife(this.getLife() + orb.getLife());
                    orb.m_146870_();
                    continue;
                }
                orb.setLife(orb.getLife() - diff);
                this.setLife(this.getMaxLife());
            }
        }
        double maxDistance = ConfigRegistry.CONFIG.getOrbFollowDistance();
        Player player = this.m_9236_().m_5788_(this.m_20185_(), this.m_20186_(), this.m_20189_(), maxDistance, entity -> {
            Player entry = (Player)entity;
            return !entry.m_5833_() && (ConfigRegistry.CONFIG.isAttractToFullHP() || entry.m_21223_() < entry.m_21233_());
        });
        if (player != null) {
            this.m_20256_(this.m_20184_().m_82549_(player.m_20182_().m_82520_(0.0, (double)(player.m_20206_() / 2.0f), 0.0).m_82546_(this.m_20182_()).m_82541_().m_82490_((maxDistance - this.m_20182_().m_82554_(player.m_20182_())) / (maxDistance * 8.0))));
            if (this.m_20182_().m_82554_(player.m_20182_()) <= (double)player.m_20205_() && (ConfigRegistry.CONFIG.isAttractToFullHP() || player.m_21223_() < player.m_21233_())) {
                float diff = player.m_21233_() - player.m_21223_();
                if (this.getLife() > diff && !ConfigRegistry.CONFIG.isAttractToFullHP()) {
                    this.setLife(this.getLife() - diff);
                    player.m_5634_(diff);
                } else {
                    player.m_5634_(this.getLife());
                    this.m_146870_();
                }
                this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.LIFE_ORB_PICKUP.get(), SoundSource.MASTER, 0.5f, 1.25f + this.m_9236_().m_213780_().m_188501_() * 0.75f);
            }
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        float friction = 0.98f;
        if (this.m_20096_()) {
            BlockPos pos = this.m_20099_();
            friction = this.m_9236_().m_8055_(pos).m_60734_().m_49958_() * 0.98f;
        }
        this.m_20256_(this.m_20184_().m_82542_((double)friction, 0.98, (double)friction));
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, -0.9, 1.0));
        }
        if (this.f_19797_ >= ConfigRegistry.CONFIG.getOrbLifetime() * 20) {
            this.m_146870_();
        }
    }

    protected void m_7378_(CompoundTag tag) {
        this.setLife(tag.m_128457_("life"));
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128350_("life", this.getLife());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(LIFE, (Object)Float.valueOf(1.0f));
    }

    public BlockPos m_20099_() {
        return this.m_216986_(0.999f);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6097_() {
        return false;
    }

    public SoundSource m_5720_() {
        return SoundSource.AMBIENT;
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (LIFE.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    public EntityDimensions m_6972_(Pose pPose) {
        float scale = 0.075f + (float)this.getStage() * 0.035f;
        return EntityDimensions.m_20395_((float)scale, (float)scale);
    }
}

