/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.cardiac.common;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.LootEvent;
import it.hurts.octostudios.cardiac.common.entities.LifeOrb;
import it.hurts.octostudios.cardiac.common.init.ConfigRegistry;
import it.hurts.octostudios.cardiac.common.init.DispenserBehaviorRegistry;
import it.hurts.octostudios.cardiac.common.init.EnchantmentRegistry;
import it.hurts.octostudios.cardiac.common.init.EntityRegistry;
import it.hurts.octostudios.cardiac.common.init.ItemRegistry;
import it.hurts.octostudios.cardiac.common.init.SoundRegistry;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class Cardiac {
    public static final String MODID = "cardiac";

    public static void init() {
        EnchantmentRegistry.registerCommon();
        EntityRegistry.registerCommon();
        SoundRegistry.registerCommon();
        ItemRegistry.registerCommon();
        EntityEvent.LIVING_DEATH.register((entity, source) -> {
            double toDrop;
            Entity killer = source.m_7639_();
            if (!(killer instanceof Player) && ConfigRegistry.CONFIG.isShouldBeKilledByPlayer()) {
                return EventResult.pass();
            }
            Level level = entity.m_20193_();
            RandomSource random = entity.m_217043_();
            double basePercentage = 0.0;
            String entityId = BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_()).toString();
            for (Map.Entry<String, Double> entry : ConfigRegistry.CONFIG.getGeneralPercentages().entrySet()) {
                String pattern = entry.getKey();
                Double percentage = entry.getValue();
                if (percentage == 0.0) continue;
                try {
                    if (!entityId.matches(pattern)) continue;
                    basePercentage = percentage;
                }
                catch (PatternSyntaxException exception) {
                    if (!entityId.equals(pattern)) continue;
                    basePercentage = percentage;
                }
            }
            double lifestealPercentage = 0.0;
            if (killer instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)killer;
                int enchantment = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)EnchantmentRegistry.LIFESTEAL.get()), (ItemStack)livingEntity.m_21205_());
                if (enchantment > 0) {
                    for (Map.Entry<String, Double> entry : ConfigRegistry.CONFIG.getLifestealPercentages().entrySet()) {
                        String pattern = entry.getKey();
                        Double percentage = entry.getValue();
                        if (percentage == 0.0) continue;
                        try {
                            if (!entityId.matches(pattern)) continue;
                            lifestealPercentage = percentage;
                        }
                        catch (PatternSyntaxException exception) {
                            if (!entityId.equals(pattern)) continue;
                            lifestealPercentage = percentage;
                        }
                    }
                }
            }
            if ((toDrop = (double)entity.m_21233_() * (basePercentage + lifestealPercentage)) == 0.0) {
                return EventResult.pass();
            }
            int steps = ConfigRegistry.CONFIG.getMinOrbsAmount() + random.m_188503_((int)Math.ceil(toDrop));
            for (int i = 0; i < steps; ++i) {
                LifeOrb orb = new LifeOrb((EntityType<? extends LifeOrb>)((EntityType)EntityRegistry.LIFE_ORB.get()), level);
                orb.setLife((float)(toDrop / (double)steps));
                orb.m_146884_(entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0));
                orb.m_20334_((-1.0f + 2.0f * random.m_188501_()) * 0.15f, 0.1f + random.m_188501_() * 0.3f, (-1.0f + 2.0f * random.m_188501_()) * 0.15f);
                level.m_7967_((Entity)orb);
            }
            return EventResult.pass();
        });
        LootEvent.MODIFY_LOOT_TABLE.register((lootDataManager, id, context, builtin) -> {
            if (id.m_135815_().matches(".*chests.*")) {
                context.addPool(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.LIFE_BOTTLE.get())).m_79707_(5).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.2f))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))));
            }
        });
        LifecycleEvent.SETUP.register(() -> {
            DispenserBehaviorRegistry.registerCommon();
            ConfigRegistry.registerCommon();
        });
    }
}

