/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import smartin.miapi.network.NetworkingImpl;

public class NetworkingImplCommon
extends NetworkingImpl {
    protected ResourceLocation channelIdentifier = new ResourceLocation("miapi", "defaultchannel");

    public NetworkingImplCommon() {
        if (Platform.getEnv().equals((Object)Dist.CLIENT)) {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)this.channelIdentifier, (buf, context) -> {
                String packetID = buf.m_130277_();
                this.trigger(packetID, buf, null);
            });
        }
    }

    public void setupServer() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)this.channelIdentifier, (buf, context) -> {
            String packetID = buf.m_130277_();
            this.trigger(packetID, buf, (ServerPlayer)context.getPlayer());
        });
    }

    @Override
    public void sendPacketToServer(String identifier, FriendlyByteBuf buffer) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130070_(identifier);
        buf.writeBytes(buffer.copy());
        NetworkManager.sendToServer((ResourceLocation)this.channelIdentifier, (FriendlyByteBuf)buf);
    }

    @Override
    public void sendPacketToClient(String identifier, ServerPlayer player, FriendlyByteBuf buffer) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130070_(identifier);
        buf.writeBytes(buffer.copy());
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)this.channelIdentifier, (FriendlyByteBuf)buf);
    }

    @Override
    public FriendlyByteBuf createBuffer() {
        return new FriendlyByteBuf(Unpooled.buffer());
    }
}

