/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.synergies;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.util.TriConsumer;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.conditions.ModuleCondition;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.modules.properties.TagProperty;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.registries.RegistryInventory;

public class SynergyManager {
    public static Map<ItemModule, List<Synergy>> maps = new ConcurrentHashMap<ItemModule, List<Synergy>>();
    public static Map<Material, List<Synergy>> materialSynergies = new ConcurrentHashMap<Material, List<Synergy>>();

    public static void setup() {
        Miapi.registerReloadHandler(ReloadEvents.MAIN, "synergies", maps, (TriConsumer<Boolean, String, String>)((TriConsumer)(isClient, path, data) -> {
            try {
                SynergyManager.load(data);
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("Could not load Synergy " + path, (Throwable)e);
            }
        }), 2.0f);
        ReloadEvents.END.subscribe(isClient -> {
            int size = 0;
            for (List<Synergy> synergies : maps.values()) {
                size += synergies.size();
            }
            Miapi.LOGGER.info("Loaded " + size + " Synergies");
        });
    }

    public static void load(String data) {
        JsonObject element = (JsonObject)Miapi.gson.fromJson(data, JsonObject.class);
        element.getAsJsonObject().entrySet().forEach(entry -> {
            if (element.has("type")) {
                String tagKey;
                String type = element.get("type").getAsString();
                if (type.equals("tag")) {
                    tagKey = (String)entry.getKey();
                    TagProperty.getModulesWithTag(tagKey).forEach(itemModule -> {
                        if (itemModule == null) {
                            Miapi.LOGGER.warn("Module does not exist " + (String)entry.getKey() + " cannot load synergy");
                        } else {
                            SynergyManager.loadSynergy(itemModule, ((JsonElement)entry.getValue()).getAsJsonObject());
                        }
                    });
                }
                if (type.equals("material")) {
                    tagKey = (String)entry.getKey();
                    Material material = MaterialProperty.materials.get(tagKey);
                    if (material != null) {
                        SynergyManager.loadSynergy(material, ((JsonElement)entry.getValue()).getAsJsonObject());
                    } else {
                        Miapi.LOGGER.warn("could not find material " + (String)entry.getKey() + " synergy will not be loaded");
                    }
                }
                if (type.equals("all") && ((JsonElement)entry.getValue()).isJsonObject()) {
                    RegistryInventory.modules.getFlatMap().forEach((id, module) -> SynergyManager.loadSynergy(module, ((JsonElement)entry.getValue()).getAsJsonObject()));
                }
            } else {
                if (((String)entry.getKey()).contains("great")) {
                    Miapi.LOGGER.error("greatsword");
                }
                ItemModule module2 = RegistryInventory.modules.get((String)entry.getKey());
                JsonObject entryData = ((JsonElement)entry.getValue()).getAsJsonObject();
                if (module2 == null) {
                    Miapi.LOGGER.warn("ItemModule does not exist " + (String)entry.getKey() + " cannot load synergy");
                } else {
                    SynergyManager.loadSynergy(module2, entryData);
                }
            }
        });
    }

    public static void loadSynergy(ItemModule itemModule, JsonObject entryData) {
        Synergy synergy = new Synergy();
        synergy.condition = ConditionManager.get(entryData.get("condition"));
        List synergies = maps.computeIfAbsent(itemModule, module -> new ArrayList());
        synergies.add(synergy);
        synergy.holder = PropertyHolderJsonAdapter.readFromObject((JsonElement)entryData, "synergy" + String.valueOf(entryData));
    }

    public static void loadSynergy(Material material, JsonObject entryData) {
        if (material == null) {
            Miapi.LOGGER.warn("Material is null? synergy wont load");
            return;
        }
        Synergy synergy = new Synergy();
        synergy.condition = ConditionManager.get(entryData.get("condition"));
        List synergies = materialSynergies.computeIfAbsent(material, module -> new ArrayList());
        synergies.add(synergy);
        synergy.holder = PropertyHolderJsonAdapter.readFromObject((JsonElement)entryData, "synergy" + String.valueOf(entryData));
    }

    public static PropertyHolder getFrom(JsonElement element, String context) {
        return PropertyHolderJsonAdapter.readFromObject(element, context);
    }

    public static Map<ModuleProperty, JsonElement> getProperties(JsonElement element) {
        HashMap<ModuleProperty, JsonElement> properties = new HashMap<ModuleProperty, JsonElement>();
        if (element == null) {
            return properties;
        }
        element.getAsJsonObject().entrySet().forEach(propertyEntry -> {
            ModuleProperty property1 = RegistryInventory.moduleProperties.get((String)propertyEntry.getKey());
            try {
                assert (property1 != null);
                property1.load("synergy", (JsonElement)propertyEntry.getValue(), Environment.isClient());
            }
            catch (Exception e) {
                Miapi.LOGGER.warn("could not load property " + (String)propertyEntry.getKey() + "for synergy");
                throw new RuntimeException(e);
            }
            properties.put(property1, (JsonElement)propertyEntry.getValue());
        });
        return properties;
    }

    public static List<ModuleProperty> getRemoveProperties(JsonElement element) {
        ArrayList<ModuleProperty> removeFields = new ArrayList<ModuleProperty>();
        if (element == null) {
            return removeFields;
        }
        if (element.isJsonArray()) {
            element.getAsJsonArray().forEach(element1 -> {
                String key;
                ModuleProperty moduleProperty;
                if (element1.isJsonPrimitive() && (moduleProperty = RegistryInventory.moduleProperties.get(key = element1.getAsString())) != null) {
                    removeFields.add(moduleProperty);
                }
            });
        }
        return removeFields;
    }

    public static class Synergy {
        public ModuleCondition condition;
        public PropertyHolder holder = new PropertyHolder();
    }

    public static class PropertyHolderJsonAdapter
    extends TypeAdapter<PropertyHolder> {
        public void write(JsonWriter jsonWriter, PropertyHolder propertyHolder) throws IOException {
        }

        public PropertyHolder read(JsonReader jsonReader) throws IOException {
            return PropertyHolderJsonAdapter.readFromObject((JsonElement)Miapi.gson.fromJson(jsonReader, JsonElement.class), "context missing");
        }

        public static PropertyHolder readFromObject(JsonElement jsonElement, String context) {
            JsonObject entryData = jsonElement.getAsJsonObject();
            PropertyHolder propertyHolder = new PropertyHolder();
            JsonElement replaceProperty = entryData.get("replace");
            if (entryData.has("properties")) {
                replaceProperty = entryData.get("properties");
                Miapi.LOGGER.warn("The raw use of the Field `properties` should be replaced with the field `replace`");
                Miapi.LOGGER.warn(context);
            }
            propertyHolder.replace = SynergyManager.getProperties(replaceProperty);
            propertyHolder.merge = SynergyManager.getProperties(entryData.get("merge"));
            propertyHolder.remove = SynergyManager.getRemoveProperties(entryData.get("remove"));
            return propertyHolder;
        }
    }

    @JsonAdapter(value=PropertyHolderJsonAdapter.class)
    public static class PropertyHolder {
        public Map<ModuleProperty, JsonElement> replace = new HashMap<ModuleProperty, JsonElement>();
        public Map<ModuleProperty, JsonElement> merge = new HashMap<ModuleProperty, JsonElement>();
        public List<ModuleProperty> remove = new ArrayList<ModuleProperty>();

        public Map<ModuleProperty, JsonElement> applyHolder(Map<ModuleProperty, JsonElement> oldMap) {
            this.remove.forEach(oldMap::remove);
            this.merge.forEach((key, value) -> {
                if (oldMap.containsKey(key)) {
                    oldMap.put((ModuleProperty)key, key.merge((JsonElement)oldMap.get(key), (JsonElement)value, MergeType.SMART));
                } else {
                    oldMap.put((ModuleProperty)key, (JsonElement)value);
                }
            });
            oldMap.putAll(this.replace);
            return oldMap;
        }

        public Map<String, JsonElement> applyHolderRaw(Map<String, JsonElement> oldMap) {
            this.remove.forEach(key -> {
                String stringKey = RegistryInventory.moduleProperties.findKey((ModuleProperty)key);
                oldMap.remove(stringKey);
            });
            this.merge.forEach((key, value) -> {
                String stringKey = RegistryInventory.moduleProperties.findKey((ModuleProperty)key);
                if (oldMap.containsKey(stringKey)) {
                    oldMap.put(stringKey, key.merge((JsonElement)oldMap.get(stringKey), (JsonElement)value, MergeType.SMART));
                } else {
                    oldMap.put(stringKey, (JsonElement)value);
                }
            });
            this.replace.forEach((key, value) -> {
                String stringKey = RegistryInventory.moduleProperties.findKey((ModuleProperty)key);
                oldMap.put(stringKey, (JsonElement)value);
            });
            return oldMap;
        }
    }
}

