/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.util.MergeType;

public interface ModuleProperty {
    public boolean load(String var1, JsonElement var2) throws Exception;

    default public boolean load(String moduleKey, JsonElement data, boolean isClient) throws Exception {
        return this.load(moduleKey, data);
    }

    default public JsonElement merge(JsonElement old, JsonElement toMerge, MergeType type) {
        Type typeToken = new TypeToken<List<JsonElement>>(){}.getType();
        if (old.isJsonArray() && toMerge.isJsonArray()) {
            List oldList = (List)Miapi.gson.fromJson(old, typeToken);
            List newList = (List)Miapi.gson.fromJson(toMerge, typeToken);
            if (Objects.requireNonNull(type) == MergeType.SMART || type == MergeType.EXTEND) {
                oldList.addAll(newList);
                return Miapi.gson.toJsonTree((Object)oldList, typeToken);
            }
            if (type == MergeType.OVERWRITE) {
                return toMerge;
            }
        } else {
            if (MergeType.EXTEND == type) {
                return old;
            }
            return toMerge;
        }
        return old;
    }

    public static JsonElement mergeList(JsonElement old, JsonElement toMerge, MergeType type) {
        switch (type) {
            case OVERWRITE: {
                return toMerge.deepCopy();
            }
            case SMART: 
            case EXTEND: {
                JsonArray array = old.deepCopy().getAsJsonArray();
                array.addAll(toMerge.deepCopy().getAsJsonArray());
                return array;
            }
        }
        return old;
    }

    public static JsonElement mergeToList(JsonElement left, JsonElement right) {
        JsonArray returnArray = new JsonArray();
        if (left != null && !left.isJsonNull()) {
            if (left.isJsonArray()) {
                left.getAsJsonArray().forEach(arg_0 -> ((JsonArray)returnArray).add(arg_0));
            } else {
                returnArray.add(left);
            }
        }
        if (right != null && !right.isJsonNull()) {
            if (right.isJsonArray()) {
                right.getAsJsonArray().forEach(arg_0 -> ((JsonArray)returnArray).add(arg_0));
            } else {
                returnArray.add(right);
            }
        }
        return right;
    }

    public static JsonElement mergeAsMap(JsonElement old, JsonElement toMerge, MergeType mergeType) {
        if (old != null && toMerge != null) {
            Map mapOld = old.getAsJsonObject().asMap();
            Map mapToMerge = toMerge.getAsJsonObject().asMap();
            if (mergeType.equals((Object)MergeType.OVERWRITE)) {
                return toMerge;
            }
            mapOld.putAll(mapToMerge);
            return Miapi.gson.toJsonTree((Object)mapToMerge);
        }
        if (old == null && toMerge != null) {
            return toMerge;
        }
        return old;
    }

    public static Map<ModuleProperty, JsonElement> mergeList(Map<ModuleProperty, JsonElement> old, Map<ModuleProperty, JsonElement> toMerge, MergeType type) {
        HashMap<ModuleProperty, JsonElement> mergedMap = new HashMap<ModuleProperty, JsonElement>(old);
        toMerge.forEach((key, json) -> {
            if (mergedMap.containsKey(key)) {
                mergedMap.put((ModuleProperty)key, ModuleProperty.mergeList((JsonElement)mergedMap.get(key), json, type));
            } else {
                mergedMap.put((ModuleProperty)key, (JsonElement)json);
            }
        });
        return mergedMap;
    }

    @Nullable
    default public JsonElement getJsonElement(ItemModule.ModuleInstance moduleInstance) {
        return moduleInstance.getProperties().get(this);
    }

    @Nullable
    default public JsonElement getJsonElement(ItemStack itemStack) {
        return ItemModule.getMergedProperty(itemStack, this);
    }

    public static boolean getBoolean(JsonObject object, String element, boolean defaultValue) {
        JsonElement json;
        if (object != null && (json = object.get(element)) != null && !json.isJsonNull() && json.isJsonPrimitive()) {
            return json.getAsBoolean();
        }
        return defaultValue;
    }

    public static boolean getBoolean(JsonObject object, String element, ItemModule.ModuleInstance moduleInstance, boolean defaultValue) {
        JsonElement json;
        if (object != null && (json = object.get(element)) != null && !json.isJsonNull()) {
            if (json.isJsonPrimitive()) {
                return json.getAsBoolean();
            }
            return StatResolver.resolveDouble(json, moduleInstance) > 0.0;
        }
        return defaultValue;
    }

    public static double getDouble(JsonObject object, String element, ItemModule.ModuleInstance moduleInstance, double defaultValue) {
        JsonElement json;
        if (object != null && (json = object.get(element)) != null && !json.isJsonNull()) {
            if (moduleInstance == null && json.isJsonPrimitive()) {
                return json.getAsDouble();
            }
            return StatResolver.resolveDouble(json, moduleInstance);
        }
        return defaultValue;
    }

    public static int getInteger(JsonObject object, String element, ItemModule.ModuleInstance moduleInstance, int defaultValue) {
        JsonElement json;
        if (object != null && (json = object.get(element)) != null && !json.isJsonNull()) {
            return (int)StatResolver.resolveDouble(json, moduleInstance);
        }
        return defaultValue;
    }

    public static String getString(JsonObject object, String element, ItemModule.ModuleInstance moduleInstance, String defaultValue) {
        JsonElement json;
        if (object != null && (json = object.get(element)) != null && !json.isJsonNull()) {
            return StatResolver.resolveString(json.getAsString(), moduleInstance);
        }
        return defaultValue;
    }

    public static Component getText(JsonObject object, String element, ItemModule.ModuleInstance moduleInstance, Component defaultValue) {
        JsonElement json;
        if (object != null && (json = object.get(element)) != null && !json.isJsonNull()) {
            return ExtraCodecs.f_252442_.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result().orElse(defaultValue);
        }
        return defaultValue;
    }

    public static Component getText(JsonObject object, String element, Component defaultValue) {
        JsonElement json;
        if (object != null && (json = object.get(element)) != null && !json.isJsonNull()) {
            return ExtraCodecs.f_252442_.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result().orElse(defaultValue);
        }
        return defaultValue;
    }

    default public Map<ItemModule.ModuleInstance, JsonElement> nonNullJsonElements(ItemStack itemStack) {
        LinkedHashMap<ItemModule.ModuleInstance, JsonElement> maps = new LinkedHashMap<ItemModule.ModuleInstance, JsonElement>();
        ItemModule.getModules(itemStack).allSubModules().forEach(moduleInstance -> {
            if (moduleInstance.getProperties().containsKey(this)) {
                maps.put((ItemModule.ModuleInstance)moduleInstance, moduleInstance.getProperties().get(this));
            }
        });
        return maps;
    }

    @Nullable
    default public Tuple<ItemModule.ModuleInstance, JsonElement> highestPriorityJsonElement(ItemStack itemStack) {
        LinkedHashMap maps = new LinkedHashMap();
        ItemModule.ModuleInstance moduleInstance = null;
        JsonElement element = null;
        for (ItemModule.ModuleInstance instance : ItemModule.getModules(itemStack).allSubModules()) {
            if (!instance.getProperties().containsKey(this)) continue;
            moduleInstance = instance;
            element = instance.getProperties().get(this);
        }
        if (moduleInstance == null) {
            return null;
        }
        return new Tuple(moduleInstance, element);
    }
}

