/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.util;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.util.ModuleProperty;

public abstract class CodecBasedProperty<T>
implements ModuleProperty {
    private final String key;
    protected final Codec<T> codec;

    protected CodecBasedProperty(String key, Codec<T> codec) {
        this.key = key;
        this.codec = codec;
        ModularItemCache.setSupplier(key + "_codec", this::createCache);
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) {
        this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)data).getOrThrow(false, s -> Miapi.LOGGER.error("Failed to load CodecBasedProperty! -> {}", s));
        return true;
    }

    public T get(ItemStack itemStack) {
        return ModularItemCache.getRaw(itemStack, this.key + "_codec");
    }

    public T createCache(ItemStack stack) {
        JsonElement element = ItemModule.getMergedProperty(stack, (ModuleProperty)this);
        if (element == null) {
            return null;
        }
        return (T)this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).getOrThrow(false, s -> Miapi.LOGGER.error("Failed to decode using codec during cache creation for a CodecBasedProperty! -> " + s));
    }
}

