/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.util;

import com.google.gson.JsonElement;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class BooleanProperty
implements ModuleProperty {
    private final String KEY_PRIVATE;
    public BooleanProperty property;
    private final boolean defaultValueSaved;

    protected BooleanProperty(String id, boolean defaultValue) {
        this.KEY_PRIVATE = id;
        this.defaultValueSaved = defaultValue;
        this.property = this;
        ModularItemCache.setSupplier(this.KEY_PRIVATE, stack -> this.property.isTruePrivate(stack));
    }

    private Boolean isTruePrivate(ItemStack stack) {
        JsonElement element = ItemModule.getMergedProperty(stack, (ModuleProperty)this.property);
        return this.getValue(element);
    }

    public boolean hasValue(ItemStack stack) {
        return ItemModule.getMergedProperty(stack, (ModuleProperty)this.property) != null;
    }

    public boolean isTrue(ItemStack stack) {
        return ModularItemCache.get(stack, this.KEY_PRIVATE, this.defaultValueSaved);
    }

    public boolean getValue(JsonElement element) {
        if (element != null) {
            try {
                return element.getAsBoolean();
            }
            catch (Exception e) {
                Miapi.LOGGER.warn("Error during PropertyResolve ", (Throwable)e);
            }
        }
        return this.defaultValueSaved;
    }

    public boolean isTrue(ItemModule.ModuleInstance moduleInstance) {
        JsonElement element = moduleInstance.getProperties().get(this);
        return this.getValue(element);
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        data.getAsBoolean();
        return true;
    }

    @Override
    public JsonElement merge(JsonElement old, JsonElement toMerge, MergeType type) {
        if (type == MergeType.SMART || type == MergeType.EXTEND) {
            return old;
        }
        if (type == MergeType.OVERWRITE) {
            return toMerge;
        }
        return old;
    }
}

