/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.render;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import smartin.miapi.Miapi;
import smartin.miapi.client.model.BakedMiapiModel;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.client.model.ModelHolder;
import smartin.miapi.client.renderer.RescaledVertexConsumer;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.modules.properties.render.ModelProperty;
import smartin.miapi.modules.properties.render.RenderProperty;
import smartin.miapi.modules.properties.render.colorproviders.ColorProvider;
import smartin.miapi.modules.properties.util.CodecBasedProperty;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class OverlayModelProperty
extends CodecBasedProperty<OverlayModelData>
implements RenderProperty {
    public static Codec<OverlayModelData> CODEC = AutoCodec.of(OverlayModelData.class).codec();
    public static String KEY = "overlay_texture_model";
    public static OverlayModelProperty property;

    public OverlayModelProperty() {
        super(KEY, CODEC);
        property = this;
        MiapiItemModel.modelSuppliers.add((key, module, stack) -> {
            ArrayList models = new ArrayList();
            ItemModule.ModuleInstance moduleInstance = module;
            for (ItemModule.ModuleInstance module2 : ItemModule.getModules(stack).allSubModules()) {
                for (OverlayModelData modelData : OverlayModelProperty.getData(module2)) {
                    if (modelData.onlyOnSameModule() && !moduleInstance.equals(module2)) continue;
                    List<ModelProperty.ModelJson> list = ModelProperty.getJson(moduleInstance);
                    list.forEach(modelJson -> {
                        ModelHolder holder;
                        if (modelData.isValid((ModelProperty.ModelJson)modelJson) && (holder = ModelProperty.bakedModel(moduleInstance, modelJson, stack, key)) != null) {
                            ColorProvider colorProvider = modelData.getColorProvider(stack, module2, moduleInstance, holder.colorProvider());
                            TextureAtlasSprite overWriteSprite = modelData.resolveSprite();
                            models.add(this.getBakedMiapiModel(module, stack, modelData, moduleInstance, holder, colorProvider, overWriteSprite));
                        }
                    });
                }
            }
            return models;
        });
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) {
        OverlayModelProperty.getData(new ItemModule.ModuleInstance(ItemModule.empty), data).forEach(OverlayModelData::loadSprite);
        return true;
    }

    @NotNull
    private BakedMiapiModel getBakedMiapiModel(final ItemModule.ModuleInstance module, ItemStack stack, final OverlayModelData modelData, ItemModule.ModuleInstance moduleInstance, ModelHolder holder, final ColorProvider colorProvider, final @Nullable TextureAtlasSprite overWriteSprite) {
        return new BakedMiapiModel(new ModelHolder(holder.model(), new Matrix4f((Matrix4fc)holder.matrix4f()), new ColorProvider(){

            @Override
            public VertexConsumer getConsumer(MultiBufferSource vertexConsumers, TextureAtlasSprite sprite, ItemStack stack, ItemModule.ModuleInstance moduleInstance, ItemDisplayContext mode) {
                return new RescaledVertexConsumer(colorProvider.getConsumer(vertexConsumers, overWriteSprite == null ? sprite : overWriteSprite, stack, modelData.useThisModule() ? module : moduleInstance, mode), sprite);
            }

            @Override
            public ColorProvider getInstance(ItemStack stack, ItemModule.ModuleInstance instance) {
                return this;
            }
        }, new int[]{-1, -1}, holder.trimMode(), holder.entityRendering(), null), modelData.useThisModule() ? module : moduleInstance, stack);
    }

    public static List<OverlayModelData> getData(ItemModule.ModuleInstance moduleInstance) {
        JsonElement element = moduleInstance.getProperties().get(property);
        return OverlayModelProperty.getData(moduleInstance, element);
    }

    public static List<OverlayModelData> getData(ItemModule.ModuleInstance moduleInstance, JsonElement element) {
        ArrayList<OverlayModelData> data = new ArrayList<OverlayModelData>();
        if (element != null && element.isJsonArray()) {
            element.getAsJsonArray().forEach(element1 -> {
                try {
                    OverlayModelData overlayModelData = (OverlayModelData)CODEC.parse((DynamicOps)JsonOps.INSTANCE, element1).getOrThrow(false, s -> Miapi.LOGGER.error("Failed to load OverlayModelData! -> {}", s));
                    overlayModelData.getPriority(moduleInstance, element1.getAsJsonObject());
                    data.add(overlayModelData);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        data.sort(Comparator.comparingDouble(a -> a.javaPriority));
        return data;
    }

    private /* synthetic */ void lambda$new$0(OverlayModelData modelData, ItemModule.ModuleInstance moduleInstance, ItemStack stack, String key, ItemModule.ModuleInstance module, List models, ModelProperty.ModelJson modelJson) {
        ModelHolder holder;
        if (modelData.isValid(modelJson) && (holder = ModelProperty.bakedModel(moduleInstance, modelJson, stack, key)) != null) {
            ColorProvider colorProvider = modelData.getColorProvider(stack, module, moduleInstance, holder.colorProvider());
            TextureAtlasSprite overWriteSprite = modelData.resolveSprite();
            models.add(this.getBakedMiapiModel(module, stack, modelData, moduleInstance, holder, colorProvider, overWriteSprite));
        }
    }

    public static class OverlayModelData {
        @CodecBehavior.Optional
        public String texture;
        public String modelTargetType;
        public String modelTargetInfo;
        public String colorProvider;
        @CodecBehavior.Optional
        public double javaPriority;
        @CodecBehavior.Optional
        public boolean allowOtherModules = false;

        @Nullable
        public TextureAtlasSprite resolveSprite() {
            if (this.texture == null) {
                return null;
            }
            return ModelProperty.textureGetter.apply(new Material(TextureAtlas.f_118259_, new ResourceLocation(this.texture)));
        }

        public void loadSprite() {
            if (this.texture != null) {
                ModelProperty.textureGetter.apply(new Material(TextureAtlas.f_118259_, new ResourceLocation(this.texture)));
            }
        }

        public double getPriority(ItemModule.ModuleInstance moduleInstance, JsonObject element) {
            this.javaPriority = ModuleProperty.getDouble(element, "priority", moduleInstance, 0.0);
            return this.javaPriority;
        }

        public ColorProvider getColorProvider(ItemStack itemStack, ItemModule.ModuleInstance current, ItemModule.ModuleInstance other, ColorProvider otherColor) {
            switch (this.colorProvider) {
                case "this": {
                    return ColorProvider.getProvider("material", itemStack, current);
                }
                case "other": {
                    return otherColor;
                }
            }
            if (ColorProvider.colorProviders.containsKey(this.colorProvider)) {
                return ColorProvider.getProvider(this.colorProvider, itemStack, current);
            }
            if (this.colorProvider.startsWith("material:")) {
                String materialId = this.colorProvider.split(":")[1];
                return new ColorProvider.MaterialColorProvider(MaterialProperty.materials.get(materialId));
            }
            return otherColor;
        }

        public boolean useThisModule() {
            return !this.colorProvider.equals("other");
        }

        public boolean onlyOnSameModule() {
            return !this.allowOtherModules;
        }

        public boolean isValid(ModelProperty.ModelJson modelJson) {
            Pattern pattern = Pattern.compile(this.modelTargetInfo);
            switch (this.modelTargetType) {
                case "id": {
                    return pattern.matcher(modelJson.id).find();
                }
                case "path": {
                    return pattern.matcher(modelJson.path).find();
                }
            }
            return false;
        }
    }
}

