/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.render;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.platform.Platform;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import smartin.miapi.Miapi;
import smartin.miapi.client.model.BakedMiapiModel;
import smartin.miapi.client.model.BannerMiapiModel;
import smartin.miapi.client.model.DynamicBakery;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.client.model.ModelHolder;
import smartin.miapi.client.model.ModelLoadAccessor;
import smartin.miapi.client.model.item.BakedSingleModel;
import smartin.miapi.client.renderer.TrimRenderer;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.item.modular.TransformMap;
import smartin.miapi.mixin.client.ModelLoaderInterfaceAccessor;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.modules.properties.EmissiveProperty;
import smartin.miapi.modules.properties.SlotProperty;
import smartin.miapi.modules.properties.render.RenderProperty;
import smartin.miapi.modules.properties.render.colorproviders.ColorProvider;
import smartin.miapi.modules.properties.util.ModuleProperty;

@OnlyIn(value=Dist.CLIENT)
public class ModelProperty
implements RenderProperty {
    public static ModuleProperty property;
    private static final String CACHE_KEY_MAP = "miapi:modelMap";
    private static final String CACHE_KEY_ITEM = "miapi:itemModelodel";
    public static final Map<String, UnbakedModelHolder> modelCache;
    public static final String KEY = "texture";
    public static final List<ModelTransformer> modelTransformers;
    public static Function<net.minecraft.client.resources.model.Material, TextureAtlasSprite> textureGetter;
    private static Function<net.minecraft.client.resources.model.Material, TextureAtlasSprite> mirroredGetter;
    private static ItemModelGenerator generator;

    public ModelProperty() {
        property = this;
        mirroredGetter = identifier -> textureGetter.apply((net.minecraft.client.resources.model.Material)identifier);
        generator = new ItemModelGenerator();
        ModularItemCache.setSupplier(CACHE_KEY_ITEM, stack -> ModelProperty.getModelMap(stack).get("item"));
        ModularItemCache.setSupplier(CACHE_KEY_MAP, ModelProperty::generateModels);
        MiapiItemModel.modelSuppliers.add((key, model, stack) -> {
            ArrayList<BakedMiapiModel> miapiModels = new ArrayList<BakedMiapiModel>();
            for (ModelHolder holder : ModelProperty.getForModule(model, key, stack)) {
                miapiModels.add(new BakedMiapiModel(holder, model, stack));
            }
            return miapiModels;
        });
    }

    public static List<ModelJson> getJson(ItemModule.ModuleInstance moduleInstance) {
        ArrayList<ModelJson> modelJsonList = new ArrayList<ModelJson>();
        JsonElement data = moduleInstance.getProperties().get(property);
        if (data == null) {
            return new ArrayList<ModelJson>();
        }
        if (data.isJsonArray()) {
            JsonArray dataArray = data.getAsJsonArray();
            for (JsonElement element : dataArray) {
                ModelJson propertyJson = (ModelJson)Miapi.gson.fromJson(element.toString(), ModelJson.class);
                propertyJson.repair();
                modelJsonList.add(propertyJson);
            }
        } else {
            ModelJson propertyJson = (ModelJson)Miapi.gson.fromJson(data.toString(), ModelJson.class);
            propertyJson.repair();
            modelJsonList.add(propertyJson);
        }
        return modelJsonList;
    }

    public static List<ModelHolder> getForModule(ItemModule.ModuleInstance instance, String key, ItemStack itemStack) {
        List<ModelJson> modelJsonList = ModelProperty.getJson(instance);
        ArrayList<ModelHolder> models = new ArrayList<ModelHolder>();
        for (ModelJson json : modelJsonList) {
            ModelHolder holder = ModelProperty.bakedModel(instance, json, itemStack, key);
            if (holder == null) continue;
            models.add(holder);
        }
        return models;
    }

    @Nullable
    public static ModelHolder bakedModel(ItemModule.ModuleInstance instance, ModelJson json, ItemStack itemStack, String key) {
        int condition = Material.getColor(StatResolver.resolveString(json.condition, instance));
        if (condition != 0 && (json.transform.origin == null && key == null || json.transform.origin != null && json.transform.origin.equals(key) || "item".equals(json.transform.origin) && key == null)) {
            return ModelProperty.bakedModel(instance, json, itemStack);
        }
        return null;
    }

    @Nullable
    public static ModelHolder bakedModel(ItemModule.ModuleInstance instance, ModelJson json, ItemStack itemStack) {
        Material material = MaterialProperty.getMaterial(instance);
        List<String> list = new ArrayList<String>();
        if (material != null) {
            list.add(material.getKey());
            list = material.getTextureKeys();
        } else {
            list.add("default");
        }
        UnbakedModelHolder unbakedModel = null;
        for (String str : list) {
            String fullPath = json.path.replace("[material.texture]", str);
            if (!modelCache.containsKey(fullPath)) continue;
            unbakedModel = modelCache.get(fullPath);
            break;
        }
        if (unbakedModel == null || unbakedModel.model == null) {
            return null;
        }
        BakedSingleModel model = DynamicBakery.bakeModel(unbakedModel.model, textureGetter, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255), Transform.IDENTITY);
        if (model != null) {
            Matrix4f matrix4f = Transform.toModelTransformation(json.transform).toMatrix();
            String colorProviderId = unbakedModel.modelData.colorProvider != null ? unbakedModel.modelData.colorProvider : json.color_provider;
            ColorProvider colorProvider = ColorProvider.getProvider(colorProviderId, itemStack, instance);
            if (colorProvider == null) {
                throw new RuntimeException("colorProvider is null");
            }
            BannerMiapiModel.BannerOnModel model1 = null;
            if (json.banner_mode != null) {
                model1 = new BannerMiapiModel.BannerOnModel(json.banner_mode, true);
            }
            return new ModelHolder(model.optimize(), matrix4f, colorProvider, unbakedModel.modelData.lightValues, json.getTrimMode(), json.entity_render, model1);
        }
        return null;
    }

    public static boolean isAllowedKey(@Nullable String jsonKey, @Nullable String modelTypeKey) {
        return jsonKey == null && modelTypeKey == null || jsonKey != null && jsonKey.equals(modelTypeKey) || "item".equals(jsonKey) && modelTypeKey == null;
    }

    public static Map<String, BakedModel> getModelMap(ItemStack stack) {
        return new HashMap<String, BakedModel>();
    }

    @Nullable
    public static BakedModel getItemModel(ItemStack stack) {
        return (BakedModel)ModularItemCache.getRaw(stack, CACHE_KEY_ITEM);
    }

    protected static Map<String, BakedModel> generateModels(ItemStack itemStack) {
        ItemModule.ModuleInstance root = ItemModule.getModules(itemStack);
        List<TransformedUnbakedModel> unbakedModels = ModelProperty.resolveUnbakedModel(root);
        for (ModelTransformer modelTransformer : modelTransformers) {
            unbakedModels = modelTransformer.unBakedTransform(unbakedModels, itemStack);
        }
        Map<String, BakedSingleModel> bakedModelMap = ModelProperty.bakedModelMap(unbakedModels);
        for (ModelTransformer transformer : modelTransformers) {
            bakedModelMap = transformer.bakedTransform(bakedModelMap, itemStack);
        }
        Map<String, BakedModel> map = ModelProperty.optimize(bakedModelMap);
        return map;
    }

    protected static Map<String, BakedModel> optimize(Map<String, BakedSingleModel> bakedModelMap) {
        HashMap<String, BakedModel> map = new HashMap<String, BakedModel>();
        bakedModelMap.forEach((id, dynamicModel) -> map.put((String)id, dynamicModel.optimize()));
        return map;
    }

    protected static Map<String, BakedSingleModel> bakedModelMap(List<TransformedUnbakedModel> unbakedModels) {
        HashMap<String, BakedSingleModel> bakedModelMap = new HashMap<String, BakedSingleModel>();
        for (TransformedUnbakedModel unbakedModel : unbakedModels) {
            ModelState settings = unbakedModel.transform.get().toModelBakeSettings();
            BakedSingleModel model = DynamicBakery.bakeModel(unbakedModel.unbakedModel, mirroredGetter, unbakedModel.color, unbakedModel.transform.get());
            BakedSingleModel bakedSIngleModel = bakedModelMap.computeIfAbsent(unbakedModel.transform.primary, key -> new BakedSingleModel(new ArrayList<BakedQuad>()));
            if (model != null) {
                if (model.m_7343_() == null || model.m_7343_().equals(ItemOverrides.f_111734_)) {
                    bakedSIngleModel.quads.addAll(model.m_213637_(null, null, RandomSource.m_216327_()));
                    for (Direction dir : Direction.values()) {
                        bakedSIngleModel.quads.addAll(model.m_213637_(null, dir, RandomSource.m_216327_()));
                    }
                    continue;
                }
                bakedSIngleModel.addModel(model);
                continue;
            }
            Miapi.LOGGER.warn("Model is null? - this probably indicates another issue");
        }
        return bakedModelMap;
    }

    protected static List<TransformedUnbakedModel> resolveUnbakedModel(ItemModule.ModuleInstance root) {
        ArrayList<TransformedUnbakedModel> unbakedModels = new ArrayList<TransformedUnbakedModel>();
        AtomicReference<Float> scaleAdder = new AtomicReference<Float>(Float.valueOf(1.0f));
        for (ItemModule.ModuleInstance moduleI : root.allSubModules()) {
            Gson gson = Miapi.gson;
            ArrayList<ModelJson> modelJsonList = new ArrayList<ModelJson>();
            JsonElement data = moduleI.getProperties().get(property);
            if (data == null) {
                return unbakedModels;
            }
            if (data.isJsonArray()) {
                JsonArray dataArray = data.getAsJsonArray();
                for (JsonElement element : dataArray) {
                    ModelJson propertyJson = (ModelJson)gson.fromJson(element.toString(), ModelJson.class);
                    propertyJson.repair();
                    modelJsonList.add(propertyJson);
                }
            } else {
                ModelJson propertyJson = (ModelJson)gson.fromJson(data.toString(), ModelJson.class);
                propertyJson.repair();
                modelJsonList.add(propertyJson);
            }
            if (modelJsonList == null) {
                Miapi.LOGGER.warn("Module " + moduleI.module.getName() + " has no Model Attached, is this intentional?");
                return new ArrayList<TransformedUnbakedModel>();
            }
            for (ModelJson json : modelJsonList) {
                int color = 0;
                int condition = Material.getColor(StatResolver.resolveString(json.condition, moduleI));
                if (condition == 0) continue;
                Material material = MaterialProperty.getMaterial(moduleI);
                List<String> list = new ArrayList<String>();
                if (material != null) {
                    list.add(material.getKey());
                    list = material.getTextureKeys();
                } else {
                    list.add("default");
                }
                BlockModel unbakedModel = null;
                for (String str : list) {
                    String fullPath = json.path.replace("[material.texture]", str);
                    if (!modelCache.containsKey(fullPath)) continue;
                    unbakedModel = ModelProperty.modelCache.get((Object)fullPath).model;
                }
                assert (unbakedModel != null);
                TransformMap transformMap = SlotProperty.getTransformStack(moduleI);
                if (json.transform == null) {
                    json.transform = Transform.IDENTITY;
                }
                transformMap.add(json.transform.copy());
                String modelId = transformMap.primary;
                Transform transform1 = transformMap.get(transformMap.primary);
                if (modelId == null) {
                    modelId = "item";
                }
                transformMap.primary = modelId;
                transform1.scale.mul(scaleAdder.get().floatValue());
                transformMap.set(transformMap.primary, transform1);
                unbakedModels.add(new TransformedUnbakedModel(transformMap, unbakedModel, moduleI, color));
            }
        }
        return unbakedModels;
    }

    protected static BlockModel loadModelFromFilePath(String filePath2) throws FileNotFoundException {
        if (modelCache.containsKey(filePath2)) {
            return ModelProperty.modelCache.get((Object)filePath2).model;
        }
        if (!((String)filePath2).endsWith(".json")) {
            filePath2 = (String)filePath2 + ".json";
        }
        if (((String)filePath2).contains("item/") && !((String)filePath2).contains("models/")) {
            filePath2 = ((String)filePath2).replace("item/", "models/item/");
        }
        ModelBakery loader = ModelLoadAccessor.getLoader();
        filePath2 = ((String)filePath2).replace(".json", "");
        filePath2 = ((String)filePath2).replace("models/", "");
        ResourceLocation modelId = new ResourceLocation((String)filePath2);
        BlockModel model = ((ModelLoaderInterfaceAccessor)loader).loadModelFromPath(modelId);
        if (!((String)filePath2).endsWith(".json")) {
            filePath2 = (String)filePath2 + ".json";
        }
        if (((String)filePath2).contains("item/") && !((String)filePath2).contains("models/")) {
            filePath2 = ((String)filePath2).replace("item/", "models/item/");
        }
        if (Platform.isForge()) {
            // empty if block
        }
        UnbakedModelHolder holder = new UnbakedModelHolder(model, ModelProperty.fromPath(ModelBakery.f_244378_.m_245698_(modelId)));
        modelCache.put((String)filePath2, holder);
        modelCache.put(modelId.toString(), holder);
        model.m_111484_().forEach(modelOverride -> {
            try {
                ModelProperty.loadModelFromFilePath(modelOverride.m_111718_().toString());
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
        ModelProperty.loadTextureDependencies(model);
        return model;
    }

    public static ModelData fromPath(ResourceLocation identifier) {
        try {
            Optional resource = Minecraft.m_91087_().m_91098_().m_213713_(identifier);
            if (resource.isPresent()) {
                return ((Resource)resource.get()).m_215509_().m_214059_((MetadataSectionSerializer)new ModelDecoder()).orElse(ModelDecoder.EMPTY());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ModelDecoder.EMPTY();
    }

    protected static Map<String, BlockModel> loadModelsByPath(String filePath) {
        String materialKey = "[material.texture]";
        HashMap<String, BlockModel> models = new HashMap<String, BlockModel>();
        if (filePath.contains(materialKey)) {
            try {
                String path2 = filePath.replace(materialKey, "default");
                BlockModel model = ModelProperty.loadModelFromFilePath(path2);
                models.put("default", model);
            }
            catch (FileNotFoundException | RuntimeException fileNotFoundException) {
                throw new RuntimeException(fileNotFoundException);
            }
            MaterialProperty.getTextureKeys().forEach(path -> {
                try {
                    String fullPath = filePath.replace(materialKey, (CharSequence)path);
                    BlockModel model = ModelProperty.loadModelFromFilePath(fullPath);
                    if (model != null) {
                        models.put((String)path, model);
                    }
                }
                catch (FileNotFoundException | RuntimeException exception) {
                    // empty catch block
                }
            });
        } else {
            try {
                BlockModel model = ModelProperty.loadModelFromFilePath(filePath);
                models.put("default", model);
            }
            catch (FileNotFoundException | RuntimeException fileNotFoundException) {
                throw new RuntimeException(fileNotFoundException);
            }
        }
        return models;
    }

    protected static void loadTextureDependencies(BlockModel model) {
        DynamicBakery.bakeModel(model, identifier -> mirroredGetter.apply((net.minecraft.client.resources.model.Material)identifier), 0, Transform.IDENTITY);
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        Gson gson = Miapi.gson;
        ArrayList<ModelJson> jsonList = new ArrayList<ModelJson>();
        if (data.isJsonArray()) {
            JsonArray dataArray = data.getAsJsonArray();
            for (JsonElement element : dataArray) {
                ModelJson propertyJson = (ModelJson)gson.fromJson(element.toString(), ModelJson.class);
                propertyJson.repair();
                ModelProperty.loadModelsByPath(propertyJson.path);
                jsonList.add(propertyJson);
            }
        } else {
            ModelJson propertyJson = (ModelJson)gson.fromJson(data.toString(), ModelJson.class);
            propertyJson.repair();
            ModelProperty.loadModelsByPath(propertyJson.path);
            jsonList.add(propertyJson);
        }
        return true;
    }

    static {
        modelCache = new HashMap<String, UnbakedModelHolder>();
        modelTransformers = new ArrayList<ModelTransformer>();
    }

    public static class ModelJson {
        public String path;
        public Transform transform = Transform.IDENTITY;
        public String condition = "1";
        public String color_provider = "material";
        public String trim_mode;
        public Boolean entity_render;
        public String id = null;
        public String banner_mode = null;

        public void repair() {
            if (this.transform == null) {
                this.transform = Transform.IDENTITY;
            }
            this.transform = Transform.repair(this.transform);
            if (this.entity_render == null) {
                this.entity_render = !this.getTrimMode().equals((Object)TrimRenderer.TrimMode.NONE);
            }
        }

        public TrimRenderer.TrimMode getTrimMode() {
            if (this.trim_mode == null) {
                return TrimRenderer.TrimMode.NONE;
            }
            switch (this.trim_mode.toLowerCase()) {
                case "armor_layer_one": {
                    return TrimRenderer.TrimMode.ARMOR_LAYER_ONE;
                }
                case "armor_layer_two": {
                    return TrimRenderer.TrimMode.ARMOR_LAYER_TWO;
                }
                case "item": {
                    return TrimRenderer.TrimMode.ITEM;
                }
            }
            return TrimRenderer.TrimMode.NONE;
        }
    }

    public record UnbakedModelHolder(BlockModel model, ModelData modelData) {
    }

    public record ModelData(String colorProvider, int[] lightValues) {
    }

    public static interface ModelTransformer {
        default public Map<String, BakedSingleModel> bakedTransform(Map<String, BakedSingleModel> dynamicBakedModelMap, ItemStack stack) {
            return dynamicBakedModelMap;
        }

        default public List<TransformedUnbakedModel> unBakedTransform(List<TransformedUnbakedModel> list, ItemStack itemStack) {
            return list;
        }
    }

    public record TransformedUnbakedModel(TransformMap transform, BlockModel unbakedModel, ItemModule.ModuleInstance instance, int color) {
    }

    static class ModelDecoder
    implements MetadataSectionSerializer<ModelData> {
        ModelDecoder() {
        }

        public static ModelData EMPTY() {
            return new ModelData(null, null);
        }

        public String m_7991_() {
            return "miapi_model_data";
        }

        public ModelData fromJson(JsonObject json) {
            String data = null;
            int[] light = null;
            if (json.has("modelProvider") && !ColorProvider.colorProviders.containsKey(data = json.get("modelProvider").getAsString())) {
                Miapi.LOGGER.error("Color Provider " + data + " does not exist");
                data = null;
            }
            if (json.has("lightValues")) {
                light = EmissiveProperty.getLightValues(json.get("lightValues"));
            }
            return new ModelData(data, light);
        }
    }
}

