/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.render;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.Miapi;
import smartin.miapi.client.model.ItemMiapiModel;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.item.modular.items.ModularCrossbow;
import smartin.miapi.modules.material.MaterialInscribeDataProperty;
import smartin.miapi.modules.properties.render.ModelProperty;
import smartin.miapi.modules.properties.render.RenderProperty;

@OnlyIn(value=Dist.CLIENT)
public class ItemModelProperty
implements RenderProperty {
    public static final String KEY = "item_model";
    public static ItemModelProperty property;

    public ItemModelProperty() {
        property = this;
        MiapiItemModel.modelSuppliers.add((key, model, stack) -> {
            JsonElement element = model.getProperties().get(property);
            ArrayList models = new ArrayList();
            if (element != null && stack.m_41782_()) {
                element.getAsJsonArray().forEach(element1 -> {
                    ModelJson modelJson = (ModelJson)Miapi.gson.fromJson(element1, ModelJson.class);
                    Supplier<ItemStack> stackSupplier = switch (modelJson.type) {
                        case "item_nbt" -> {
                            CompoundTag itemCompound = stack.m_41784_().m_128469_(modelJson.model);
                            if (!itemCompound.m_128456_() && ModelProperty.isAllowedKey(modelJson.modelType, key)) {
                                yield () -> ItemStack.m_41712_((CompoundTag)itemCompound);
                            }
                            yield () -> ItemStack.f_41583_;
                        }
                        case "module_data" -> {
                            if (ModelProperty.isAllowedKey(modelJson.modelType, key)) {
                                yield () -> MaterialInscribeDataProperty.readStackFromModuleInstance(model, modelJson.model);
                            }
                            yield () -> ItemStack.f_41583_;
                        }
                        case "item" -> {
                            if (ModelProperty.isAllowedKey(modelJson.modelType, key)) {
                                yield () -> new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(modelJson.model)));
                            }
                            yield () -> ItemStack.f_41583_;
                        }
                        case "projectile" -> {
                            if (stack.m_41720_() instanceof ModularCrossbow && ModelProperty.isAllowedKey(modelJson.modelType, key)) {
                                yield () -> ModularCrossbow.getProjectiles(stack).stream().findFirst().orElse(ItemStack.f_41583_);
                            }
                            yield () -> ItemStack.f_41583_;
                        }
                        default -> throw new IllegalStateException("Unexpected value: " + modelJson.type);
                    };
                    ItemMiapiModel miapiModel = new ItemMiapiModel(stackSupplier, modelJson.transform.toMatrix());
                    models.add(miapiModel);
                });
            }
            return models;
        });
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        return true;
    }

    static class ModelJson {
        public String type;
        public String model;
        public String modelType;
        public Transform transform = Transform.IDENTITY;

        ModelJson() {
        }
    }
}

