/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.render;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import smartin.miapi.Miapi;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.client.model.item.BakedSingleModel;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.SlotProperty;
import smartin.miapi.modules.properties.render.ModelProperty;
import smartin.miapi.modules.properties.render.RenderProperty;
import smartin.miapi.modules.properties.util.ModuleProperty;

@OnlyIn(value=Dist.CLIENT)
public class GuiOffsetProperty
implements RenderProperty {
    public static final String KEY = "guiOffset";
    public static ModuleProperty property;

    public GuiOffsetProperty() {
        property = this;
        ModularItemCache.setSupplier("guiOffset_pure_gui", stack -> new HashMap());
        MiapiItemModel.modelTransformers.add((matrices, itemStack, mode, modelType, tickDelta) -> {
            if (mode.equals((Object)ItemDisplayContext.GUI) && MiapiConfig.INSTANCE.client.other.uiScale) {
                Map cache = ModularItemCache.getVisualOnlyCache(itemStack, "guiOffset_pure_gui", new HashMap());
                float[] data = cache.computeIfAbsent(modelType, s -> this.getGuiOffsets(itemStack, modelType));
                matrices.m_252880_(data[0], data[1], 0.0f);
                matrices.m_85841_(data[2], data[3], data[4]);
            }
            return matrices;
        });
        ModelProperty.modelTransformers.add(new ModelProperty.ModelTransformer(){

            @Override
            public Map<String, BakedSingleModel> bakedTransform(Map<String, BakedSingleModel> dynamicBakedModelmap, ItemStack stack) {
                if (MiapiConfig.INSTANCE.client.other.uiScale) {
                    dynamicBakedModelmap.forEach((id, dynamicBakedModel) -> {
                        GuiOffsetJson guiOffsetJson = new GuiOffsetJson();
                        for (ItemModule.ModuleInstance instance : ItemModule.createFlatList(ItemModule.getModules(stack))) {
                            JsonElement element = instance.getProperties().get(property);
                            if (element == null) continue;
                            GuiOffsetJson add = (GuiOffsetJson)Miapi.gson.fromJson(element, GuiOffsetJson.class);
                            guiOffsetJson.x += add.x;
                            guiOffsetJson.y += add.y;
                            guiOffsetJson.sizeX += add.sizeX;
                            guiOffsetJson.sizeY += add.sizeY;
                        }
                        Transform guiTransform = new Transform(dynamicBakedModel.m_7442_().m_269404_(ItemDisplayContext.GUI));
                        guiOffsetJson.x -= guiOffsetJson.sizeX / 2.0f / 16.0f;
                        guiOffsetJson.y -= guiOffsetJson.sizeY / 2.0f / 16.0f;
                        guiOffsetJson.sizeX /= 16.0f;
                        guiOffsetJson.sizeY /= 16.0f;
                        float guiZ = (guiOffsetJson.sizeX + guiOffsetJson.sizeY) / 2.0f;
                        guiTransform = new Transform(guiTransform.rotation, new Vector3f(guiOffsetJson.x / 16.0f, guiOffsetJson.y / 16.0f, 0.0f), new Vector3f(guiOffsetJson.sizeX, guiOffsetJson.sizeY, guiZ));
                        dynamicBakedModel.modelTransformation = new ItemTransforms(dynamicBakedModel.m_7442_().m_269404_(ItemDisplayContext.THIRD_PERSON_LEFT_HAND), dynamicBakedModel.m_7442_().m_269404_(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND), dynamicBakedModel.m_7442_().m_269404_(ItemDisplayContext.FIRST_PERSON_LEFT_HAND), dynamicBakedModel.m_7442_().m_269404_(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND), dynamicBakedModel.m_7442_().m_269404_(ItemDisplayContext.HEAD), guiTransform.toTransformation(), dynamicBakedModel.m_7442_().m_269404_(ItemDisplayContext.GROUND), dynamicBakedModel.m_7442_().m_269404_(ItemDisplayContext.FIXED));
                        dynamicBakedModelmap.put((String)id, (BakedSingleModel)dynamicBakedModel);
                    });
                }
                return dynamicBakedModelmap;
            }
        });
    }

    public float[] getGuiOffsets(ItemStack itemStack, String modelType) {
        GuiOffsetJson guiOffsetJson = new GuiOffsetJson();
        for (ItemModule.ModuleInstance instance : ItemModule.createFlatList(ItemModule.getModules(itemStack))) {
            JsonElement element = instance.getProperties().get(property);
            if (element == null) continue;
            GuiOffsetJson add = (GuiOffsetJson)Miapi.gson.fromJson(element, GuiOffsetJson.class);
            Transform transform = SlotProperty.getLocalTransformStack(instance).get(modelType);
            Matrix4f matrix4f = transform.toMatrix();
            Vector4f offsetPos = new Vector4f(add.x, add.y, 0.0f, 0.0f);
            offsetPos = offsetPos.mul((Matrix4fc)matrix4f);
            guiOffsetJson.x += offsetPos.x();
            guiOffsetJson.y += offsetPos.y();
            Vector4f sizeVec = new Vector4f(add.sizeX, add.sizeY, 0.0f, 0.0f);
            sizeVec = sizeVec.mul((Matrix4fc)matrix4f);
            guiOffsetJson.sizeX += sizeVec.x();
            guiOffsetJson.sizeY += sizeVec.y();
        }
        float baseSize = 16.0f;
        guiOffsetJson.x /= baseSize;
        guiOffsetJson.y /= baseSize;
        guiOffsetJson.sizeX = baseSize / (baseSize + guiOffsetJson.sizeX);
        guiOffsetJson.sizeY = baseSize / (baseSize + guiOffsetJson.sizeY);
        float zScale = (guiOffsetJson.sizeX + guiOffsetJson.sizeY) / 2.0f;
        return new float[]{guiOffsetJson.x, guiOffsetJson.y, guiOffsetJson.sizeX, guiOffsetJson.sizeY, zScale};
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        return true;
    }

    private static class GuiOffsetJson {
        public float x = 0.0f;
        public float y = 0.0f;
        public float sizeX = 0.0f;
        public float sizeY = 0.0f;

        private GuiOffsetJson() {
        }
    }
}

