/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.render;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import smartin.miapi.Miapi;
import smartin.miapi.client.model.BlockRenderModel;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.modules.material.MaterialIcons;
import smartin.miapi.modules.properties.render.RenderProperty;

public class BlockModelProperty
implements RenderProperty {
    public static String KEY = "block_model";
    public static BlockModelProperty property;

    public BlockModelProperty() {
        property = this;
        MiapiItemModel.modelSuppliers.add((key, model, stack) -> {
            JsonElement element;
            ArrayList models = new ArrayList();
            if (model.getProperties().containsKey(property) && (element = model.getProperties().get(property)) != null && element.isJsonArray()) {
                element.getAsJsonArray().forEach(jsonElement -> {
                    JsonObject object = jsonElement.getAsJsonObject();
                    ResourceLocation identifier = new ResourceLocation(object.get("id").getAsString());
                    Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(identifier);
                    Transform transform = (Transform)Miapi.gson.fromJson(object.get("transform"), Transform.class);
                    BlockState blockState = block.m_49966_();
                    if (object.has("nbt")) {
                        blockState = BlockState.f_61039_.parse((DynamicOps)JsonOps.INSTANCE, (Object)object.get("nbt")).result().orElse(blockState);
                    }
                    BlockRenderModel blockRenderModel = new BlockRenderModel(blockState, transform);
                    if (object.has("spin")) {
                        blockRenderModel.spinSettings = (MaterialIcons.SpinSettings)MaterialIcons.SpinSettings.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)object.get("spin")).result().get();
                    }
                    models.add(blockRenderModel);
                });
            }
            return models;
        });
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        return true;
    }
}

